/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ExtendedScreen
extends Screen
implements NarratableEntry {
    private static int lastIndex = 0;
    public final Screen parentScreen;
    public final Screen currentScreen;
    private final List<GuiEventListener> extendedControls = StringUtils.newArrayList();
    private final List<DynamicWidget> extendedWidgets = StringUtils.newArrayList();
    private final List<ScrollableListControl> extendedLists = StringUtils.newArrayList();
    protected GuiGraphics currentMatrix;
    private Phase currentPhase = Phase.PREINIT;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int screenX = 0;
    private int screenY = 0;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private int lastMouseScroll = 0;
    private int contentHeight;
    private boolean canClose;
    private boolean isOverScreen;

    public ExtendedScreen(Screen parentScreen) {
        super((Component)Component.m_237113_((String)""));
        this.setGameInstance(CraftPresence.instance);
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.canClose = true;
        this.setContentHeight(0);
        this.setDebugMode(CommandUtils.isDebugMode());
        this.setVerboseMode(CommandUtils.isVerboseMode());
    }

    public ExtendedScreen() {
        this(null);
        this.canClose = false;
    }

    public ExtendedScreen(Screen parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(boolean debugMode) {
        this();
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(Screen parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public ExtendedScreen(boolean debugMode, boolean verboseMode) {
        this(debugMode);
        this.setVerboseMode(verboseMode);
    }

    public static int getNextIndex() {
        return lastIndex++;
    }

    public static void resetIndex() {
        lastIndex = 0;
    }

    public static void copyToClipboard(Minecraft instance, String input) {
        instance.f_91068_.m_90911_(StringUtils.normalize(input));
    }

    public void copyToClipboard(String input) {
        ExtendedScreen.copyToClipboard(this.getGameInstance(), input);
    }

    public void m_7856_() {
        super.m_7856_();
        this.clearData();
        this.currentPhase = Phase.INIT;
        this.initializeUi();
        this.currentPhase = Phase.READY;
    }

    public void clearData() {
        if (this.currentPhase != Phase.PREINIT) {
            this.currentPhase = Phase.PREINIT;
            this.setContentHeight(0);
            this.m_169413_();
            this.extendedControls.clear();
            this.extendedWidgets.clear();
            this.extendedLists.clear();
        }
    }

    public void initializeUi() {
        if (this.currentPhase == Phase.PREINIT) {
            this.m_7856_();
            return;
        }
        if (this.currentPhase == Phase.INIT) {
            this.resetMouseScroll();
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).initializeUi();
            }
            this.refreshContentHeight();
        }
    }

    public void reloadUi() {
        this.m_6574_(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
    }

    public void m_6574_(@Nonnull Minecraft mcIn, int w, int h) {
        if (this.isLoaded()) {
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).m_6574_(mcIn, w, h);
            }
        }
        super.m_6574_(mcIn, w, h);
    }

    @Nonnull
    public <T extends GuiEventListener & Renderable> T addControl(@Nonnull T buttonIn) {
        if (buttonIn instanceof DynamicWidget && !this.extendedWidgets.contains(buttonIn)) {
            this.addWidget((DynamicWidget)buttonIn);
        }
        if (buttonIn instanceof Renderable) {
            this.m_142416_(buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends ScrollableListControl> T addList(@Nonnull T buttonIn) {
        if (buttonIn instanceof Renderable) {
            this.m_142416_((GuiEventListener)buttonIn);
        }
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends DynamicWidget> T addWidget(@Nonnull T buttonIn) {
        if (!this.extendedWidgets.contains(buttonIn)) {
            buttonIn.setControlPosY(this.getTop() + buttonIn.getTop());
            this.extendedWidgets.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        RenderUtils.drawBackground(this.getGameInstance(), this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), this.getScreenBackground());
    }

    public boolean hasWorld() {
        return this.getGameInstance().f_91073_ != null;
    }

    public ColorData getRawBackground() {
        return this.hasWorld() ? CraftPresence.CONFIG.accessibilitySettings.worldGuiBackground : CraftPresence.CONFIG.accessibilitySettings.guiBackground;
    }

    public float getTintFactor() {
        return 1.0f;
    }

    public ColorData getScreenBackground() {
        ColorData data = this.getRawBackground();
        if (!this.hasWorld()) {
            data.getStart().alpha = 255;
            data.getEnd().alpha = 255;
        }
        return data;
    }

    public double getOffset() {
        return 0.0;
    }

    public void preRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.preDraw(this);
        }
    }

    public void renderExtra() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.draw(this);
        }
    }

    public void postRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.postDraw(this);
        }
    }

    public void m_280273_(@Nonnull GuiGraphics matrixStack) {
        this.renderCriticalData();
    }

    public void m_88315_(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentMatrix = matrixStack;
        if (this.isLoaded()) {
            this.preRender();
            int scale = this.computeGuiScale();
            RenderUtils.drawWithin(this.getLeft() * scale, this.getGameInstance().m_91268_().m_85442_() - this.getBottom() * scale, this.getScreenWidth() * scale, this.getScreenHeight() * scale);
            this.m_280273_(matrixStack);
            super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
            this.renderExtra();
            RenderUtils.drawAnywhere();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.isOverScreen = RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this);
            this.postRender();
        }
    }

    public boolean m_7979_(double mX, double mY, int mouseButton, double dragX, double dragY) {
        if (this.isLoaded()) {
            for (ScrollableListControl listControl : this.getLists()) {
                if (!listControl.m_7979_(mX, mY, mouseButton, dragX, dragY)) continue;
                return true;
            }
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen) || !((ExtendedScreen)extendedControl).m_7979_(mX, mY, mouseButton, dragX, dragY)) continue;
                return true;
            }
            return super.m_7979_(mX, mY, mouseButton, dragX, dragY);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isLoaded()) {
            this.setMouseScroll((int)delta);
            for (ScrollableListControl listControl : this.getLists()) {
                if (!listControl.m_6050_(mouseX, mouseY, delta)) continue;
                return true;
            }
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen) || !((ExtendedScreen)extendedControl).m_6050_(mouseX, mouseY, delta)) continue;
                return true;
            }
            return super.m_6050_(mouseX, mouseY, delta);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int mouseX, int mouseY) {
        if (this.isLoaded()) {
            if (keyCode == 256 && this.canClose) {
                this.openScreen(this.parentScreen);
                return true;
            }
            if (this.getGameInstance() != null && this.getGameInstance().f_91080_ == this) {
                return super.m_7933_(keyCode, mouseX, mouseY);
            }
            if (this.m_7222_() != null) {
                return this.m_7222_().m_7933_(keyCode, mouseX, mouseY);
            }
        }
        return false;
    }

    public void m_86600_() {
        if (this.isLoaded()) {
            for (GuiEventListener extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.m_94120_();
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).m_86600_();
            }
            super.m_86600_();
        }
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_7861_() {
        if (this.isLoaded()) {
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).m_7861_();
            }
            this.clearData();
            ExtendedScreen.resetIndex();
        }
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142227_(@NotNull NarrationElementOutput arg) {
    }

    public Minecraft getGameInstance() {
        return this.f_96541_;
    }

    public void setGameInstance(Minecraft instance) {
        this.f_96541_ = instance;
    }

    public void openScreen(Screen targetScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen);
    }

    public int computeGuiScale() {
        return RenderUtils.computeGuiScale(this.getGameInstance());
    }

    public int getButtonY(int order) {
        return 40 + 25 * (order - 1);
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY) {
        RenderUtils.drawMultiLineString(this.getGameInstance(), this.currentMatrix, textToInput, posX, posY, this.getScreenWidth(), this.getScreenHeight(), this.getWrapWidth(), this.getFontRenderer(), new Tuple<Boolean, ColorData, ColorData>(CraftPresence.CONFIG.accessibilitySettings.renderTooltips, CraftPresence.CONFIG.accessibilitySettings.tooltipBackground, CraftPresence.CONFIG.accessibilitySettings.tooltipBorder));
    }

    public void drawMultiLineString(List<String> textToInput) {
        this.drawMultiLineString(textToInput, this.getMouseX(), this.getMouseY());
    }

    public void renderNotice(List<String> notice) {
        this.renderNotice(notice, 2.0f, 3.0f);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale) {
        this.renderNotice(notice, widthScale, heightScale, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale, boolean useXAsActual, boolean useYAsActual) {
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = notice.get(i);
                this.renderString(string, (useXAsActual ? widthScale : (float)this.getScreenWidth() / widthScale) - (float)this.getStringWidth(string) / widthScale, (useYAsActual ? heightScale : (float)this.getScreenHeight() / heightScale) + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    public void renderCenteredString(String text, float xPos, float yPos, int color) {
        this.renderString(text, xPos - (float)this.getStringWidth(text) / 2.0f, yPos, color);
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.currentMatrix.m_280056_(this.getFontRenderer(), text, Math.round(xPos), Math.round(yPos), color, true);
    }

    public int getStringWidth(String string) {
        return this.getFontRenderer().m_92895_(string);
    }

    public List<String> createRenderLines(List<String> original, int wrapWidth) {
        List<String> data = StringUtils.newArrayList();
        for (String line : original) {
            data.addAll(RenderUtils.listFormattedStringToWidth(this.getFontRenderer(), line, wrapWidth));
        }
        return data;
    }

    public List<String> createRenderLines(String original, int wrapWidth) {
        return this.createRenderLines(StringUtils.splitTextByNewLine(original, true), wrapWidth);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public int getMouseScroll() {
        return this.lastMouseScroll;
    }

    public void setMouseScroll(int mouseScroll) {
        this.lastMouseScroll = mouseScroll;
    }

    public void resetMouseScroll() {
        this.setMouseScroll(0);
    }

    public int getMaxWidth() {
        return this.getScreenWidth();
    }

    public int getScreenWidth() {
        return this.f_96543_;
    }

    public void setScreenWidth(int screenWidth) {
        this.f_96543_ = screenWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public void refreshContentHeight() {
        this.setContentHeight(0);
        for (DynamicWidget widget : this.getWidgets()) {
            int widgetHeight = widget.getBottom();
            if (widgetHeight <= this.getContentHeight()) continue;
            this.setContentHeight(widgetHeight);
        }
    }

    public int getScreenHeight() {
        return this.f_96544_;
    }

    public void setScreenHeight(int screenHeight) {
        this.f_96544_ = screenHeight;
    }

    public Font getFontRenderer() {
        return this.getGameInstance().f_91062_ != null ? this.getGameInstance().f_91062_ : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public int getLeft() {
        return this.getScreenX();
    }

    public int getRight() {
        return this.getScreenX() + this.getScreenWidth();
    }

    public int getBottom() {
        return this.getScreenY() + this.getScreenHeight();
    }

    public int getTop() {
        return this.getScreenY();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }

    public List<GuiEventListener> getControls() {
        return StringUtils.newArrayList(this.extendedControls);
    }

    public List<DynamicWidget> getWidgets() {
        return StringUtils.newArrayList(this.extendedWidgets);
    }

    public List<ScrollableListControl> getLists() {
        return StringUtils.newArrayList(this.extendedLists);
    }

    public boolean isLoaded() {
        return this.currentPhase == Phase.READY;
    }

    public static enum Phase {
        PREINIT,
        INIT,
        READY;

    }
}

