/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.KeyConverter;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.mojang.blaze3d.platform.InputConstants;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import org.lwjgl.glfw.GLFW;

public class KeyUtils {
    private static final List<Integer> clearKeys = StringUtils.newArrayList();
    private static final List<Integer> invalidKeys = StringUtils.newArrayList();
    private final Map<String, Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> KEY_MAPPINGS = StringUtils.newHashMap();
    public Map<String, Integer> keySyncQueue = StringUtils.newHashMap();
    private boolean keysRegistered = false;

    public static boolean isValidKeyCode(int sourceKeyCode) {
        return !invalidKeys.contains(sourceKeyCode);
    }

    public static boolean isValidClearCode(int sourceKeyCode) {
        if (clearKeys.isEmpty()) {
            clearKeys.add(ModUtils.MCProtocolID > 340 ? 256 : 1);
        }
        return clearKeys.contains(sourceKeyCode);
    }

    public static String getKeyName(int original) {
        int unknownKeyCode = ModUtils.MCProtocolID <= 340 ? -1 : 0;
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(unknownKeyCode) : KeyConverter.toGlfw.get(unknownKeyCode)).getSecond();
        if (KeyUtils.isValidKeyCode(original)) {
            if (ModUtils.MCProtocolID <= 340 && KeyConverter.toGlfw.containsKey(original)) {
                return KeyConverter.toGlfw.get(original).getSecond();
            }
            if (ModUtils.MCProtocolID > 340 && KeyConverter.fromGlfw.containsKey(original)) {
                return KeyConverter.fromGlfw.get(original).getSecond();
            }
            String altKeyName = Integer.toString(original);
            String keyName = original != unknownKeyCode ? GLFW.glfwGetKeyName((int)original, (int)GLFW.glfwGetKeyScancode((int)original)) : unknownKeyName;
            return StringUtils.getOrDefault(keyName, altKeyName);
        }
        return unknownKeyName;
    }

    public static int convertKey(int originalKey, int protocol, KeyConverter.ConversionMode mode) {
        int resultKey;
        Pair<Integer, String> unknownKeyData = mode == KeyConverter.ConversionMode.Lwjgl2 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0);
        int n = resultKey = protocol <= 340 ? -1 : 0;
        if (mode == KeyConverter.ConversionMode.Lwjgl2) {
            resultKey = KeyConverter.fromGlfw.getOrDefault(originalKey, unknownKeyData).getFirst();
        } else if (mode == KeyConverter.ConversionMode.Lwjgl3) {
            resultKey = KeyConverter.toGlfw.getOrDefault(originalKey, unknownKeyData).getFirst();
        } else if (mode == KeyConverter.ConversionMode.None) {
            if (protocol <= 340 && KeyConverter.toGlfw.containsKey(originalKey)) {
                resultKey = originalKey;
            } else if (protocol > 340 && KeyConverter.fromGlfw.containsKey(originalKey)) {
                resultKey = originalKey;
            }
        }
        if (resultKey == originalKey && mode != KeyConverter.ConversionMode.None) {
            Constants.LOG.debugWarn(Constants.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", Integer.toString(resultKey), mode.name()), new Object[0]);
        }
        return resultKey;
    }

    KeyMapping createKey(String id, String name, String category, int defaultKey, int currentKey) {
        KeyMapping result = new KeyMapping(name, defaultKey, category);
        this.keySyncQueue.put(id, currentKey);
        return result;
    }

    void setKey(KeyMapping instance, int newKey) {
        instance.m_90848_(InputConstants.m_84827_((int)newKey, (int)GLFW.glfwGetKeyScancode((int)newKey)));
        KeyMapping.m_90854_();
    }

    void register() {
        this.KEY_MAPPINGS.put("configKeyCode", new Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Object>(this.createKey("configKeyCode", "key.craftpresence.config_keycode.name", "key.craftpresence.category", CraftPresence.CONFIG.accessibilitySettings.getDefaults().configKeyCode, CraftPresence.CONFIG.accessibilitySettings.configKeyCode), new Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>(() -> {
            if (!CraftPresence.GUIS.isFocused && !(CraftPresence.instance.f_91080_ instanceof ExtendedScreen)) {
                RenderUtils.openScreen(CraftPresence.instance, new MainGui(CraftPresence.instance.f_91080_));
            }
        }, (keyCode, shouldSave) -> {
            CraftPresence.CONFIG.accessibilitySettings.configKeyCode = keyCode;
            if (shouldSave.booleanValue()) {
                CraftPresence.CONFIG.save();
            }
        }, vanillaBind -> vanillaBind != CraftPresence.CONFIG.accessibilitySettings.configKeyCode), null));
    }

    public boolean areKeysRegistered() {
        return this.keysRegistered;
    }

    public Map<String, Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> getRawKeyMappings() {
        return StringUtils.newHashMap(this.KEY_MAPPINGS);
    }

    public String getKeyName(String original) {
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0)).getSecond();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pair<Boolean, Integer> integerData = StringUtils.getValidInteger(original);
            if (integerData.getFirst().booleanValue()) {
                return KeyUtils.getKeyName(integerData.getSecond());
            }
            return unknownKeyName;
        }
        return unknownKeyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTick() {
        if (!this.keysRegistered) {
            if (CraftPresence.instance.f_91066_ != null) {
                Iterator<Map.Entry<String, Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>>> iterator = this.KEY_MAPPINGS.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map map = KeyMapping.f_90812_;
                    Map.Entry<String, Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entry = iterator.next();
                    KeyMapping mapping = entry.getValue().getFirst();
                    if (!map.containsKey(mapping.m_90858_())) {
                        Optional largest = map.values().stream().max(Integer::compareTo);
                        int largestInt = largest.orElse(0);
                        map.put(mapping.m_90858_(), largestInt + 1);
                    }
                    CraftPresence.instance.f_91066_.f_92059_ = (KeyMapping[])StringUtils.addToArray(CraftPresence.instance.f_91066_.f_92059_, mapping);
                }
                this.keysRegistered = true;
            } else {
                return;
            }
        }
        if (CraftPresence.instance.m_91268_() != null && CraftPresence.CONFIG != null) {
            int unknownKeyCode = ModUtils.MCProtocolID <= 340 ? -1 : 0;
            String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(unknownKeyCode) : KeyConverter.toGlfw.get(unknownKeyCode)).getSecond();
            try {
                for (Map.Entry entry : this.KEY_MAPPINGS.entrySet()) {
                    String keyName = (String)entry.getKey();
                    Tuple keyData = (Tuple)entry.getValue();
                    KeyMapping keyBind = (KeyMapping)keyData.getFirst();
                    Tuple callbackData = (Tuple)keyData.getSecond();
                    int currentBind = keyBind.f_90816_.m_84873_();
                    boolean hasBeenRun = false;
                    if (!(KeyUtils.getKeyName(currentBind).equals(unknownKeyName) || KeyUtils.isValidClearCode(currentBind) || GLFW.glfwGetKey((long)CraftPresence.instance.m_91268_().m_85439_(), (int)currentBind) != 1 || CraftPresence.instance.f_91080_ instanceof ControlsScreen)) {
                        try {
                            ((Runnable)callbackData.getFirst()).run();
                        }
                        catch (Throwable ex) {
                            if (keyData.getThird() != null) {
                                ((Consumer)keyData.getThird()).accept(ex);
                            } else {
                                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.keycode", keyBind.m_90860_()), new Object[0]);
                                this.syncKeyData(keyName, ImportMode.Specific, keyBind.m_90861_().m_84873_());
                            }
                        }
                        finally {
                            hasBeenRun = true;
                        }
                    }
                    if (hasBeenRun || CraftPresence.CONFIG.hasChanged) continue;
                    if (this.keySyncQueue.containsKey(keyName)) {
                        this.syncKeyData(keyName, ImportMode.Config, this.keySyncQueue.get(keyName));
                        this.keySyncQueue.remove(keyName);
                        continue;
                    }
                    if (!((Predicate)callbackData.getThird()).test(currentBind)) continue;
                    this.syncKeyData(keyName, ImportMode.Vanilla, currentBind);
                }
            }
            catch (Throwable ex) {
                Constants.LOG.debugError(ex);
            }
        }
    }

    private void syncKeyData(String keyName, ImportMode mode, int keyCode) {
        Tuple keyData = this.KEY_MAPPINGS.getOrDefault(keyName, null);
        if (mode == ImportMode.Config) {
            this.setKey((KeyMapping)keyData.getFirst(), keyCode);
        } else if (mode == ImportMode.Vanilla) {
            ((BiConsumer)((Tuple)keyData.getSecond()).getSecond()).accept(keyCode, true);
        } else if (mode == ImportMode.Specific) {
            this.syncKeyData(((KeyMapping)keyData.getFirst()).m_90860_(), ImportMode.Config, keyCode);
            this.syncKeyData(keyName, ImportMode.Vanilla, keyCode);
        } else {
            Constants.LOG.debugWarn(Constants.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", keyName, mode.name()), new Object[0]);
        }
    }

    public Map<String, Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> getKeyMappings(FilterMode mode, List<String> filterData) {
        Map<String, Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> filteredMappings = StringUtils.newHashMap();
        for (Map.Entry<String, Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entry : this.KEY_MAPPINGS.entrySet()) {
            String keyName = entry.getKey();
            if (mode != FilterMode.None && mode != FilterMode.Category && mode != FilterMode.Id && (mode != FilterMode.Name || !filterData.contains(keyName))) continue;
            Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData = entry.getValue();
            if (!(mode == FilterMode.None || mode == FilterMode.Category && filterData.contains(keyData.getFirst().m_90858_()) || mode == FilterMode.Id && filterData.contains(keyData.getFirst().m_90860_())) && mode != FilterMode.Name) continue;
            filteredMappings.put(keyName, keyData);
        }
        return filteredMappings;
    }

    public Map<String, Tuple<KeyMapping, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> getKeyMappings() {
        return this.getKeyMappings(FilterMode.None, StringUtils.newArrayList());
    }

    public static enum ImportMode {
        Config,
        Vanilla,
        Specific;

    }

    public static enum FilterMode {
        Category,
        Name,
        Id,
        None;

    }
}

