/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.HashMapBuilder;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Status;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;

public class StatusMessagesGui
extends ConfigurationGui<Status> {
    private final Status INSTANCE;
    private final Map<String, Pair<String, Runnable>> eventMappings = new HashMapBuilder<String, Pair<String, Runnable>>().put("gui.config.name.status_messages.main_menu_message", new Pair<String, Runnable>("mainMenuData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.status_messages.main_menu_message", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom.")))))).put("gui.config.name.status_messages.loading_message", new Pair<String, Runnable>("loadingData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.status_messages.loading_message", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom.")))))).put("gui.config.name.status_messages.lan_message", new Pair<String, Runnable>("lanData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.status_messages.lan_message", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")))))).put("gui.config.name.status_messages.single_player_message", new Pair<String, Runnable>("singleplayerData", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.status_messages.single_player_message", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")))))).build();

    StatusMessagesGui(Screen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.status_messages");
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int midCalc = this.getScreenWidth() / 2 - 90;
        int buttonRow = 0;
        int index = 1;
        for (Map.Entry<String, Pair<String, Runnable>> entry : this.eventMappings.entrySet()) {
            int startX;
            boolean isEven = index % 2 == 0;
            int n = startX = isEven ? calc2 : calc1;
            if (index >= this.eventMappings.size() && startX == calc1) {
                startX = midCalc;
            }
            this.childFrame.addControl(new ExtendedButtonControl(startX, this.getButtonY(buttonRow), 180, 20, entry.getKey(), () -> this.openScreen(new DynamicEditorGui(this.currentScreen, (String)((Pair)entry.getValue()).getFirst(), (attributeName, screenInstance) -> {
                screenInstance.defaultData = (ModuleData)this.getCurrentData().getDefaults().getProperty((String)attributeName);
                screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
                screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
                screenInstance.resetText = "gui.config.message.button.reset";
            }, (attributeName, screenInstance) -> {
                screenInstance.defaultData = (ModuleData)this.getCurrentData().getDefaults().getProperty((String)attributeName);
                screenInstance.currentData = (ModuleData)this.getCurrentData().getProperty((String)attributeName);
                screenInstance.isPreliminaryData = screenInstance.currentData == null;
                screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.gui.edit_specific_gui", attributeName);
                screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
                screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
                screenInstance.resetText = "gui.config.message.button.reset";
            }, (screenInstance, attributeName, inputText) -> {
                screenInstance.currentData.setTextOverride((String)inputText);
                CraftPresence.CONFIG.hasChanged = true;
                this.getCurrentData().setProperty((String)attributeName, screenInstance.currentData);
                if (!CraftPresence.GUIS.GUI_NAMES.contains(attributeName)) {
                    CraftPresence.GUIS.GUI_NAMES.add((String)attributeName);
                }
            }, (screenInstance, attributeName, inputText) -> {
                CraftPresence.CONFIG.hasChanged = true;
                this.getCurrentData().resetProperty((String)attributeName);
            }, (attributeName, screenInstance, isPresenceButton) -> {
                if (isPresenceButton.booleanValue()) {
                    PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                    PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                    this.openScreen(new PresenceSettingsGui((Screen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
                } else {
                    String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : CraftPresence.CONFIG.generalSettings.defaultIcon;
                    String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                    this.openScreen(new SelectorGui((Screen)screenInstance, Constants.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
                }
            })), entry.getValue().getSecond(), new String[0]));
            if (isEven) {
                ++buttonRow;
            }
            ++index;
        }
    }

    @Override
    protected Status getOriginalData() {
        return this.INSTANCE;
    }

    @Override
    protected Status getCurrentData() {
        return CraftPresence.CONFIG.statusMessages;
    }

    @Override
    protected boolean setCurrentData(Status data) {
        if (!this.getCurrentData().equals(data)) {
            this.getCurrentData().transferFrom(data);
            CraftPresence.CONFIG.hasChanged = true;
            return true;
        }
        return false;
    }
}

