/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.PartyPrivacy;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import external.com.jagrosh.discordipc.entities.DiscordBuild;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.General;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import net.minecraft.client.gui.screens.Screen;

public class GeneralSettingsGui
extends ConfigurationGui<General> {
    private final General INSTANCE;
    private final General DEFAULTS;
    private ExtendedButtonControl partyPrivacyLevelButton;
    private ExtendedButtonControl preferredClientLevelButton;
    private CheckBoxControl detectCurseManifestButton;
    private CheckBoxControl detectMultiMCManifestButton;
    private CheckBoxControl detectMCUpdaterInstanceButton;
    private CheckBoxControl detectTechnicPackButton;
    private CheckBoxControl detectATLauncherButton;
    private CheckBoxControl detectModrinthPackButton;
    private CheckBoxControl detectBiomeDataButton;
    private CheckBoxControl detectDimensionDataButton;
    private CheckBoxControl detectWorldDataButton;
    private CheckBoxControl enableJoinRequestButton;
    private CheckBoxControl resetTimeOnInitButton;
    private CheckBoxControl autoRegisterButton;
    private TextWidget clientId;
    private TextWidget defaultIcon;
    private int currentPartyPrivacy = PartyPrivacy.Public.ordinal();
    private int currentPreferredClient = DiscordBuild.ANY.ordinal();
    private String currentIcon;

    GeneralSettingsGui(Screen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.general");
        this.DEFAULTS = this.getCurrentData().getDefaults();
        this.INSTANCE = this.getCurrentData().copy();
        this.currentIcon = this.getCurrentData().defaultIcon;
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        this.clientId = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, "gui.config.name.general.client_id", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.client_id", new Object[0])))));
        this.clientId.setControlMessage(this.getCurrentData().clientId);
        this.clientId.setControlMaxLength(32);
        int buttonCalc1 = this.getScreenWidth() / 2 - 183;
        int buttonCalc2 = this.getScreenWidth() / 2 + 3;
        int checkboxCalc1 = this.getScreenWidth() / 2 - 168;
        int checkboxCalc2 = this.getScreenWidth() / 2 + 18;
        this.defaultIcon = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(1), 147, 20, "gui.config.name.general.default_icon", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.default_icon", new Object[0])))).setTitleXOffset(-16.0f));
        this.addIconSelector(this.childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
            this.currentIcon = currentValue;
        });
        this.defaultIcon.setControlMessage(this.currentIcon);
        this.currentPartyPrivacy = this.getCurrentData().partyPrivacyLevel;
        this.partyPrivacyLevelButton = this.childFrame.addControl(new ExtendedButtonControl(buttonCalc1, this.getButtonY(2), 180, 20, "gui.config.name.general.party_privacy => " + PartyPrivacy.from(this.currentPartyPrivacy).name(), () -> {
            this.currentPartyPrivacy = (this.currentPartyPrivacy + 1) % PartyPrivacy.values().length;
            this.partyPrivacyLevelButton.setControlMessage("gui.config.name.general.party_privacy => " + PartyPrivacy.from(this.currentPartyPrivacy).name());
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.party_privacy", new Object[0]))), new String[0]));
        this.currentPreferredClient = this.getCurrentData().preferredClientLevel;
        this.preferredClientLevelButton = this.childFrame.addControl(new ExtendedButtonControl(buttonCalc2, this.getButtonY(2), 180, 20, "gui.config.name.general.preferred_client => " + DiscordBuild.from(this.currentPreferredClient).name(), () -> {
            this.currentPreferredClient = (this.currentPreferredClient + 1) % DiscordBuild.values().length;
            this.preferredClientLevelButton.setControlMessage("gui.config.name.general.preferred_client => " + DiscordBuild.from(this.currentPreferredClient).name());
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.preferred_client", new Object[0]))), new String[0]));
        this.detectCurseManifestButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc1, this.getButtonY(3), "gui.config.name.general.detect_curse_manifest", this.getCurrentData().detectCurseManifest, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_curse_manifest", new Object[0])))));
        this.detectMultiMCManifestButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc2, this.getButtonY(3), "gui.config.name.general.detect_multimc_manifest", this.getCurrentData().detectMultiMCManifest, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_multimc_manifest", new Object[0])))));
        this.detectMCUpdaterInstanceButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc1, this.getButtonY(4, -10), "gui.config.name.general.detect_mcupdater_instance", this.getCurrentData().detectMCUpdaterInstance, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_mcupdater_instance", new Object[0])))));
        this.detectTechnicPackButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc2, this.getButtonY(4, -10), "gui.config.name.general.detect_technic_pack", this.getCurrentData().detectTechnicPack, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_technic_pack", new Object[0])))));
        this.detectATLauncherButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc1, this.getButtonY(5, -20), "gui.config.name.general.detect_atlauncher_instance", this.getCurrentData().detectATLauncherInstance, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_atlauncher_instance", new Object[0])))));
        this.detectModrinthPackButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc2, this.getButtonY(5, -20), "gui.config.name.general.detect_modrinth_pack", this.getCurrentData().detectModrinthPack, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_modrinth_pack", new Object[0])))));
        this.enableJoinRequestButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc1, this.getButtonY(6, -30), "gui.config.name.general.enable_join_request", this.getCurrentData().enableJoinRequests, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.enable_join_request", new Object[0])))));
        this.detectDimensionDataButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc2, this.getButtonY(6, -30), "gui.config.name.general.detect_dimension_data", this.getCurrentData().detectDimensionData, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_dimension_data", new Object[0])))));
        this.autoRegisterButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc1, this.getButtonY(7, -40), "gui.config.name.general.auto_register", this.getCurrentData().autoRegister, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.auto_register", new Object[0])))));
        this.detectBiomeDataButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc2, this.getButtonY(7, -40), "gui.config.name.general.detect_biome_data", this.getCurrentData().detectBiomeData, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_biome_data", new Object[0])))));
        this.resetTimeOnInitButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc1, this.getButtonY(8, -50), "gui.config.name.general.reset_time_on_init", this.getCurrentData().resetTimeOnInit, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.reset_time_on_init", new Object[0])))));
        this.detectWorldDataButton = this.childFrame.addControl(new CheckBoxControl(checkboxCalc2, this.getButtonY(8, -50), "gui.config.name.general.detect_world_data", this.getCurrentData().detectWorldData, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_world_data", new Object[0])))));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected void applySettings() {
        if (!this.clientId.getControlMessage().equals(this.getCurrentData().clientId)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().clientId = this.clientId.getControlMessage();
        }
        if (!this.defaultIcon.getControlMessage().equals(this.getCurrentData().defaultIcon)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().defaultIcon = this.defaultIcon.getControlMessage();
        }
        if (this.currentPartyPrivacy != this.getCurrentData().partyPrivacyLevel) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().partyPrivacyLevel = this.currentPartyPrivacy;
        }
        if (this.currentPreferredClient != this.getCurrentData().preferredClientLevel) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().preferredClientLevel = this.currentPreferredClient;
        }
        if (this.detectATLauncherButton.isChecked() != this.getCurrentData().detectATLauncherInstance) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().detectATLauncherInstance = this.detectATLauncherButton.isChecked();
        }
        if (this.detectCurseManifestButton.isChecked() != this.getCurrentData().detectCurseManifest) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().detectCurseManifest = this.detectCurseManifestButton.isChecked();
        }
        if (this.detectMultiMCManifestButton.isChecked() != this.getCurrentData().detectMultiMCManifest) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().detectMultiMCManifest = this.detectMultiMCManifestButton.isChecked();
        }
        if (this.detectMCUpdaterInstanceButton.isChecked() != this.getCurrentData().detectMCUpdaterInstance) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().detectMCUpdaterInstance = this.detectMCUpdaterInstanceButton.isChecked();
        }
        if (this.detectTechnicPackButton.isChecked() != this.getCurrentData().detectTechnicPack) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().detectTechnicPack = this.detectTechnicPackButton.isChecked();
        }
        if (this.detectModrinthPackButton.isChecked() != this.getCurrentData().detectModrinthPack) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().detectModrinthPack = this.detectModrinthPackButton.isChecked();
        }
        if (this.detectBiomeDataButton.isChecked() != this.getCurrentData().detectBiomeData) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().detectBiomeData = this.detectBiomeDataButton.isChecked();
        }
        if (this.detectDimensionDataButton.isChecked() != this.getCurrentData().detectDimensionData) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().detectDimensionData = this.detectDimensionDataButton.isChecked();
        }
        if (this.detectWorldDataButton.isChecked() != this.getCurrentData().detectWorldData) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().detectWorldData = this.detectWorldDataButton.isChecked();
        }
        if (this.enableJoinRequestButton.isChecked() != this.getCurrentData().enableJoinRequests) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().enableJoinRequests = this.enableJoinRequestButton.isChecked();
        }
        if (this.resetTimeOnInitButton.isChecked() != this.getCurrentData().resetTimeOnInit) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().resetTimeOnInit = this.resetTimeOnInitButton.isChecked();
        }
        if (this.autoRegisterButton.isChecked() != this.getCurrentData().autoRegister) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().autoRegister = this.autoRegisterButton.isChecked();
        }
    }

    @Override
    protected boolean canReset() {
        return !this.getCurrentData().equals(this.DEFAULTS);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean resetData() {
        return this.setCurrentData(this.DEFAULTS);
    }

    @Override
    protected boolean canSync() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected boolean syncData() {
        return this.setCurrentData(Config.loadOrCreate().generalSettings);
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(DiscordAssetUtils.isValidId(this.clientId.getControlMessage()));
    }

    @Override
    protected General getOriginalData() {
        return this.INSTANCE;
    }

    @Override
    protected General getCurrentData() {
        return CraftPresence.CONFIG.generalSettings;
    }

    @Override
    protected boolean setCurrentData(General data) {
        if (!this.getCurrentData().equals(data)) {
            this.getCurrentData().transferFrom(data);
            CraftPresence.CONFIG.hasChanged = true;
            return true;
        }
        return false;
    }
}

