/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorSection;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.HashMapBuilder;
import com.gitlab.cdagaming.craftpresence.core.impl.KeyConverter;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.MathUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.OSUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.TranslationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Accessibility;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Advanced;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Biome;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Dimension;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Display;
import forge.com.gitlab.cdagaming.craftpresence.config.category.General;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Server;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Status;
import forge.com.gitlab.cdagaming.craftpresence.config.migration.HypherConverter;
import forge.com.gitlab.cdagaming.craftpresence.config.migration.Legacy2Modern;
import forge.com.gitlab.cdagaming.craftpresence.config.migration.TextReplacer;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Config
extends Module
implements Serializable {
    private static final long serialVersionUID = -4853238501768086595L;
    private static final int MC_VERSION = ModUtils.MCProtocolID;
    private static final int VERSION = 6;
    private static final List<String> keyCodeTriggers = StringUtils.newArrayList("keycode", "keybinding");
    private static final List<String> languageTriggers = StringUtils.newArrayList("language", "lang", "langId", "languageId");
    private static final Config DEFAULT = new Config().applyDefaults();
    private static final Config INSTANCE = Config.loadOrCreate();
    public transient boolean hasChanged = false;
    public transient boolean isNewFile = false;
    public String _README = "https://gitlab.com/CDAGaming/CraftPresence/-/wikis/home";
    public String _SOURCE = "https://gitlab.com/CDAGaming/CraftPresence";
    public int _schemaVersion = 0;
    public int _lastMCVersionId = 0;
    public General generalSettings = new General();
    public Biome biomeSettings = new Biome();
    public Dimension dimensionSettings = new Dimension();
    public Server serverSettings = new Server();
    public Status statusMessages = new Status();
    public Advanced advancedSettings = new Advanced();
    public Accessibility accessibilitySettings = new Accessibility();
    public Display displaySettings = new Display();

    public Config(Config other) {
        this.transferFrom(other);
    }

    public Config() {
    }

    public static Config getInstance() {
        return new Config(INSTANCE);
    }

    public static String getConfigPath() {
        return Constants.configDir + File.separator + "craftpresence.json";
    }

    public static File getConfigFile() {
        return new File(Config.getConfigPath());
    }

    public static Pair<Config, JsonElement> read() {
        JsonElement rawJson;
        Config config;
        block2: {
            config = null;
            rawJson = null;
            try {
                config = FileUtils.getJsonData(Config.getConfigFile(), Config.class, new FileUtils.Modifiers[]{FileUtils.Modifiers.DISABLE_ESCAPES, FileUtils.Modifiers.PRETTY_PRINT});
                rawJson = FileUtils.getJsonData(Config.getConfigFile(), new FileUtils.Modifiers[0]);
            }
            catch (Exception ex) {
                if (ex.getClass() == FileNotFoundException.class || ex.getClass() == NoSuchFileException.class) break block2;
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
                Constants.LOG.debugError(ex);
                if (Config.getConfigFile().renameTo(new File(Config.getConfigPath() + ".bak"))) break block2;
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.backup", new Object[0]), new Object[0]);
            }
        }
        return new Pair<Object, Object>(config, rawJson);
    }

    public static Config loadOrCreate(boolean forceCreate) {
        boolean isInvalidData;
        Pair<Config, JsonElement> data = Config.read();
        Config config = data.getFirst();
        JsonElement rawJson = data.getSecond();
        boolean hasNoData = config == null;
        boolean bl = isInvalidData = !hasNoData && (forceCreate || config._schemaVersion <= 0 || config._lastMCVersionId <= 0);
        if (hasNoData || isInvalidData) {
            config = hasNoData ? DEFAULT : config.getDefaults();
            config.isNewFile = true;
            config.hasChanged = isInvalidData;
        }
        boolean wasNewFile = config.isNewFile;
        config.handleSync(rawJson);
        if (!forceCreate) {
            config.save();
        }
        if (wasNewFile) {
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.config.new", new Object[0]), new Object[0]);
        } else {
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
        }
        return config;
    }

    public static Config loadOrCreate() {
        return Config.loadOrCreate(false);
    }

    public static Object getProperty(Config instance, String ... path) {
        if (instance == null) {
            return null;
        }
        return instance.getProperty(path);
    }

    public static Object getProperty(Module instance, String name) {
        if (instance == null) {
            return null;
        }
        return instance.getProperty(name);
    }

    public static boolean isValidProperty(Config instance, String ... path) {
        Object property = Config.getProperty(instance, path);
        return property != null && !StringUtils.isNullOrEmpty(property.toString());
    }

    public static boolean isValidProperty(Config instance, String name) {
        return Config.isValidProperty(instance, name.split("\\."));
    }

    public static boolean isValidProperty(Module instance, String name) {
        Object property = Config.getProperty(instance, name);
        return property != null && !StringUtils.isNullOrEmpty(property.toString());
    }

    public static int getGameVersion() {
        return MC_VERSION;
    }

    public static int getSchemaVersion() {
        return 6;
    }

    public Config applyDefaults(Config config) {
        config._schemaVersion = Config.getSchemaVersion();
        config._lastMCVersionId = Config.getGameVersion();
        return config;
    }

    public Config applyDefaults() {
        return this.applyDefaults(this);
    }

    @Override
    public Config getDefaults() {
        return new Config(DEFAULT);
    }

    @Override
    public Config copy() {
        return new Config(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof Config && !this.equals(target)) {
            Config data = (Config)target;
            this.hasChanged = data.hasChanged;
            this.isNewFile = data.isNewFile;
            this._README = data._README;
            this._SOURCE = data._SOURCE;
            this._schemaVersion = data._schemaVersion;
            this._lastMCVersionId = data._lastMCVersionId;
            this.generalSettings = new General(data.generalSettings);
            this.biomeSettings = new Biome(data.biomeSettings);
            this.dimensionSettings = new Dimension(data.dimensionSettings);
            this.serverSettings = new Server(data.serverSettings);
            this.statusMessages = new Status(data.statusMessages);
            this.advancedSettings = new Advanced(data.advancedSettings);
            this.accessibilitySettings = new Accessibility(data.accessibilitySettings);
            this.displaySettings = new Display(data.displaySettings);
        }
    }

    public void applySettings() {
        if (this.hasChanged) {
            CommandUtils.reloadData(true);
            this.hasChanged = false;
        }
        this.isNewFile = false;
    }

    public void applyFrom(Config old) {
        boolean needsReboot = false;
        if (!this.generalSettings.clientId.equals(old.generalSettings.clientId)) {
            needsReboot = true;
        } else if (this.generalSettings.preferredClientLevel != old.generalSettings.preferredClientLevel) {
            needsReboot = true;
        } else if (this.generalSettings.resetTimeOnInit != old.generalSettings.resetTimeOnInit) {
            needsReboot = true;
        } else if (this.generalSettings.autoRegister != old.generalSettings.autoRegister) {
            needsReboot = true;
        } else if (!this.accessibilitySettings.languageId.equals(old.accessibilitySettings.languageId)) {
            Constants.TRANSLATOR.syncTranslations();
        } else if (this.advancedSettings.allowDuplicatePackets != old.advancedSettings.allowDuplicatePackets) {
            needsReboot = true;
        } else if (this.advancedSettings.maxConnectionAttempts != old.advancedSettings.maxConnectionAttempts) {
            needsReboot = true;
        }
        if (this.advancedSettings.debugMode != old.advancedSettings.debugMode || this.advancedSettings.verboseMode != old.advancedSettings.verboseMode || this.advancedSettings.refreshRate != old.advancedSettings.refreshRate) {
            CommandUtils.updateModes();
        }
        if (this.accessibilitySettings.stripTranslationColors != old.accessibilitySettings.stripTranslationColors) {
            Constants.TRANSLATOR.setStripColors(this.accessibilitySettings.stripTranslationColors);
        }
        if (needsReboot) {
            CommandUtils.setupRPC();
        }
    }

    public JsonElement handleMigrations(JsonElement rawJson, int oldVer, int newVer) {
        if (this.isNewFile) {
            File legacyFile = new File(Constants.configDir + File.separator + "craftpresence.properties");
            if (legacyFile.exists()) {
                new Legacy2Modern(legacyFile, "UTF-8").apply(this, rawJson, new Object[0]);
            } else {
                Map<Integer, CallSite> hypherionFiles = new HashMapBuilder<Integer, CallSite>().put(0, (CallSite)((Object)(Constants.configDir + File.separator))).put(31, (CallSite)((Object)(OSUtils.USER_DIR + File.separator + "simple-rpc" + File.separator))).put(32, (CallSite)((Object)(Constants.configDir + File.separator + "simple-rpc" + File.separator))).build();
                for (Map.Entry<Integer, CallSite> entry : hypherionFiles.entrySet()) {
                    File hypherionFile = new File((String)((Object)entry.getValue()) + "simple-rpc.toml");
                    if (!hypherionFile.exists()) continue;
                    new HypherConverter(entry).apply(this, rawJson, new Object[0]);
                    break;
                }
            }
        }
        if (!this.isNewFile) {
            int currentVer = oldVer;
            if (currentVer < newVer) {
                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.config.outdated", currentVer, newVer), new Object[0]);
                if (MathUtils.isWithinValue(currentVer, 1.0, 2.0, true, false)) {
                    boolean showTime = rawJson.getAsJsonObject().getAsJsonObject("generalSettings").getAsJsonPrimitive("showTime").getAsBoolean();
                    this.displaySettings.presenceData.startTimestamp = showTime ? "{data.general.time}" : "";
                    currentVer = 2;
                }
                if (MathUtils.isWithinValue(currentVer, 2.0, 3.0, true, false)) {
                    new TextReplacer(new HashMapBuilder<String, String>().put("world.time24", "world.time.format_24").put("world.time12", "world.time.format_12").put("world.day", "world.time.day").build(), true, true, false, true).apply(this, rawJson, new Object[0]);
                    currentVer = 3;
                }
                if (MathUtils.isWithinValue(currentVer, 3.0, 4.0, true, false)) {
                    JsonObject oldData = rawJson.getAsJsonObject().getAsJsonObject("accessibilitySettings");
                    boolean showBackgroundAsDark = oldData.getAsJsonPrimitive("showBackgroundAsDark").getAsBoolean();
                    Map<String, String> propsToChange = new HashMapBuilder<String, String>().put("tooltipBackgroundColor", "tooltipBackground").put("tooltipBorderColor", "tooltipBorder").put("guiBackgroundColor", "guiBackground").build();
                    for (Map.Entry<String, String> entry : propsToChange.entrySet()) {
                        String oldValue = oldData.getAsJsonPrimitive(entry.getKey()).getAsString();
                        ColorData newValue = new ColorData();
                        if (!StringUtils.isNullOrEmpty(oldValue)) {
                            if (StringUtils.isValidColorCode(oldValue)) {
                                ColorSection startColor = new ColorSection(StringUtils.findColor(oldValue));
                                newValue.setStartColor(startColor);
                                if (entry.getKey().equalsIgnoreCase("tooltipBorderColor")) {
                                    int borderColorCode = startColor.getColor().getRGB();
                                    String borderColorEnd = Integer.toString((borderColorCode & 0xFEFEFE) >> 1 | borderColorCode & 0xFF000000);
                                    newValue.setEndColor(new ColorSection(StringUtils.findColor(borderColorEnd)));
                                }
                            } else {
                                boolean applyTint;
                                boolean bl = applyTint = showBackgroundAsDark && entry.getKey().equalsIgnoreCase("guiBackgroundColor");
                                if (applyTint) {
                                    newValue.setStartColor(new ColorSection(64, 64, 64, 255));
                                }
                                newValue.setTexLocation(oldValue);
                            }
                        }
                        this.accessibilitySettings.setProperty(entry.getValue(), newValue);
                    }
                    currentVer = 4;
                }
                if (MathUtils.isWithinValue(currentVer, 4.0, 5.0, true, false)) {
                    new TextReplacer(new HashMapBuilder<String, String>().put("data.screen.class", "getClass(data.screen.instance)").build(), true, true, false, true).apply(this, rawJson, new Object[0]);
                    currentVer = 5;
                }
                if (MathUtils.isWithinValue(currentVer, 5.0, 6.0, true, false)) {
                    this.accessibilitySettings.renderTooltips = rawJson.getAsJsonObject().getAsJsonObject("advancedSettings").getAsJsonPrimitive("renderTooltips").getAsBoolean();
                    currentVer = 6;
                }
                this.save();
            }
            rawJson = Config.read().getSecond();
        }
        return rawJson;
    }

    public JsonElement handleVerification(JsonElement rawJson, KeyConverter.ConversionMode keyCodeMigrationId, TranslationUtils.ConversionMode languageMigrationId, String ... path) {
        Object pathPrefix = StringUtils.join(".", Arrays.asList(path));
        if (!StringUtils.isNullOrEmpty((String)pathPrefix)) {
            pathPrefix = (String)pathPrefix + ".";
        }
        if (rawJson != null) {
            Object parentValue = this.getProperty(path);
            for (Map.Entry entry : rawJson.getAsJsonObject().entrySet()) {
                String rawName = (String)pathPrefix + (String)entry.getKey();
                List<String> configPath = StringUtils.newArrayList(path);
                configPath.add((String)entry.getKey());
                String[] pathData = configPath.toArray(new String[0]);
                JsonElement rawValue = (JsonElement)entry.getValue();
                Object defaultValue = this.getDefaults().getProperty(pathData);
                Object currentValue = this.getProperty(pathData);
                boolean shouldReset = false;
                boolean shouldContinue = true;
                if (defaultValue == null) {
                    if (!(currentValue != null && (parentValue instanceof ColorData || parentValue instanceof ColorSection || parentValue instanceof PresenceData || parentValue instanceof ModuleData || parentValue instanceof Button))) {
                        Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.prop.invalid", rawName), new Object[0]);
                        shouldContinue = false;
                    } else {
                        defaultValue = currentValue;
                    }
                }
                if (!shouldContinue) continue;
                if (Module.class.isAssignableFrom(defaultValue.getClass())) {
                    List<String> paths = StringUtils.newArrayList(path);
                    paths.add((String)entry.getKey());
                    this.handleVerification((JsonElement)entry.getValue(), keyCodeMigrationId, languageMigrationId, paths.toArray(new String[0]));
                    continue;
                }
                if (rawName.contains("presence")) continue;
                if (!StringUtils.isNullOrEmpty(defaultValue.toString()) && StringUtils.isNullOrEmpty(currentValue.toString())) {
                    shouldReset = true;
                } else {
                    Class<?> expectedClass = currentValue.getClass();
                    if (expectedClass == Boolean.class && !StringUtils.isValidBoolean(rawValue.getAsString())) {
                        shouldReset = true;
                    } else if (expectedClass == Integer.class) {
                        Pair<Boolean, Integer> boolData = StringUtils.getValidInteger(rawValue.getAsString());
                        if (boolData.getFirst().booleanValue()) {
                            for (String string : keyCodeTriggers) {
                                int migratedKeyCode;
                                if (!rawName.toLowerCase().contains(string.toLowerCase())) continue;
                                if (!KeyUtils.isValidKeyCode(boolData.getSecond())) {
                                    shouldReset = true;
                                    break;
                                }
                                if (keyCodeMigrationId == KeyConverter.ConversionMode.Unknown || (migratedKeyCode = KeyUtils.convertKey(boolData.getSecond(), Config.getGameVersion(), keyCodeMigrationId)) == boolData.getSecond()) break;
                                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.migration.apply", "KEYCODE", keyCodeMigrationId.name(), rawName, boolData.getSecond(), migratedKeyCode), new Object[0]);
                                this.setProperty(migratedKeyCode, pathData);
                                break;
                            }
                        } else {
                            shouldReset = true;
                        }
                    } else if (currentValue instanceof Map) {
                        Map newData = StringUtils.newHashMap((Map)currentValue);
                        Map defaultData = StringUtils.newHashMap((Map)defaultValue);
                        if (!newData.containsKey("default")) {
                            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.missing.default", rawName), new Object[0]);
                            newData.putAll(defaultData);
                            this.setProperty(newData, pathData);
                        } else if (((JsonElement)entry.getValue()).isJsonObject()) {
                            for (Object dataEntry : newData.keySet()) {
                                List<String> paths = StringUtils.newArrayList(path);
                                paths.add((String)entry.getKey());
                                paths.add(dataEntry.toString());
                                JsonElement dataValue = ((JsonElement)entry.getValue()).getAsJsonObject().get(dataEntry.toString());
                                if (!dataValue.isJsonObject()) continue;
                                this.handleVerification(dataValue, keyCodeMigrationId, languageMigrationId, paths.toArray(new String[0]));
                            }
                        }
                    } else if (rawValue.isJsonPrimitive()) {
                        String rawStringValue = rawValue.getAsString();
                        for (String string : languageTriggers) {
                            String migratedLanguageId;
                            if (!rawName.toLowerCase().contains(string.toLowerCase())) continue;
                            if (languageMigrationId == TranslationUtils.ConversionMode.Unknown || (migratedLanguageId = TranslationUtils.convertId(rawStringValue, Config.getGameVersion(), languageMigrationId)).equals(rawStringValue)) break;
                            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.migration.apply", "LANGUAGE", languageMigrationId.name(), rawName, rawStringValue, migratedLanguageId), new Object[0]);
                            this.setProperty((Object)migratedLanguageId, pathData);
                            break;
                        }
                    }
                }
                if (!shouldReset) continue;
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.prop.empty", rawName), new Object[0]);
                this.resetProperty(pathData);
            }
        }
        return rawJson;
    }

    public JsonElement handleSync(JsonElement rawJson) {
        int newMCVer;
        int oldMCVer;
        int newSchemaVer = Config.getSchemaVersion();
        if (this.isNewFile || this._schemaVersion != newSchemaVer) {
            int oldVer = this._schemaVersion;
            rawJson = this.handleMigrations(rawJson, oldVer, newSchemaVer);
            this._schemaVersion = newSchemaVer;
        }
        if ((oldMCVer = this._lastMCVersionId) != (newMCVer = Config.getGameVersion())) {
            this._lastMCVersionId = newMCVer;
        }
        if (ModUtils.IS_TEXT_COLORS_BLOCKED) {
            this.accessibilitySettings.stripTranslationColors = true;
        }
        KeyConverter.ConversionMode keyCodeMigrationId = oldMCVer < 341 && newMCVer >= 341 ? KeyConverter.ConversionMode.Lwjgl3 : (oldMCVer >= 341 && newMCVer < 341 ? KeyConverter.ConversionMode.Lwjgl2 : (oldMCVer >= 0 && newMCVer >= 0 ? KeyConverter.ConversionMode.None : KeyConverter.ConversionMode.Unknown));
        TranslationUtils.ConversionMode languageMigrationId = oldMCVer < 301 && newMCVer >= 301 ? TranslationUtils.ConversionMode.PackFormat3 : (oldMCVer >= 301 && newMCVer < 301 ? TranslationUtils.ConversionMode.PackFormat2 : (oldMCVer >= 0 && newMCVer >= 0 ? TranslationUtils.ConversionMode.None : TranslationUtils.ConversionMode.Unknown));
        Constants.LOG.debugInfo(Constants.TRANSLATOR.translate("craftpresence.logger.info.migration.add", new Object[]{keyCodeTriggers.toString(), keyCodeMigrationId, keyCodeMigrationId.equals((Object)KeyConverter.ConversionMode.None) ? "Verification" : "Setting Change"}), new Object[0]);
        Constants.LOG.debugInfo(Constants.TRANSLATOR.translate("craftpresence.logger.info.migration.add", new Object[]{languageTriggers.toString(), languageMigrationId, languageMigrationId.equals((Object)TranslationUtils.ConversionMode.None) ? "Verification" : "Setting Change"}), new Object[0]);
        return !this.isNewFile ? this.handleVerification(rawJson, keyCodeMigrationId, languageMigrationId, new String[0]) : rawJson;
    }

    public void save(boolean shouldApply) {
        FileUtils.writeJsonData(this, Config.getConfigFile(), "UTF-8", FileUtils.Modifiers.DISABLE_ESCAPES, FileUtils.Modifiers.PRETTY_PRINT);
        if (shouldApply) {
            this.applySettings();
        }
    }

    public void save() {
        this.save(true);
    }

    public Pair<Object, Tuple<Class<?>, Object, String>> lookupProperty(String ... path) {
        Class classObj = Config.class;
        Object instance = this;
        Object result = null;
        String name = null;
        for (int i = 0; i < path.length; ++i) {
            if (StringUtils.isNullOrEmpty(path[i])) continue;
            name = path[i];
            result = instance instanceof Map ? (Object)StringUtils.newHashMap((Map)instance).get(name) : StringUtils.getField(classObj, instance, name);
            if (result == null) break;
            if (i >= path.length - 1) continue;
            classObj = result.getClass();
            instance = result;
        }
        return new Pair<Object, Tuple<Class<Config>, Config, String>>(result, new Tuple<Class<Config>, Config, String>(classObj, (Config)instance, name));
    }

    public Object getProperty(String ... path) {
        return this.lookupProperty(path).getFirst();
    }

    @Override
    public Object getProperty(String name) {
        return this.getProperty(name.split("\\."));
    }

    public void setProperty(Object value, String ... path) {
        Pair<Object, Tuple<Class<?>, Object, String>> propertyData = this.lookupProperty(path);
        if (propertyData.getFirst() != null) {
            Tuple<Class<?>, Object, String> fieldData = propertyData.getSecond();
            if (fieldData.getSecond() instanceof Map) {
                String[] parentPath = Arrays.copyOf(path, path.length - 1);
                Tuple<Class<?>, Object, String> parentData = this.lookupProperty(parentPath).getSecond();
                Map<String, Object> data = StringUtils.newHashMap((Map)fieldData.getSecond());
                data.put(fieldData.getThird(), value);
                StringUtils.updateField(parentData.getFirst(), parentData.getSecond(), data, parentData.getThird());
            } else {
                StringUtils.updateField(fieldData.getFirst(), fieldData.getSecond(), value, fieldData.getThird());
            }
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        this.setProperty(value, name.split("\\."));
    }

    public void resetProperty(String ... path) {
        this.setProperty(this.getDefaults().getProperty(path), path);
    }

    @Override
    public void resetProperty(String name) {
        this.resetProperty(name.split("\\."));
    }
}

