/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.updater;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.UrlUtils;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ScrollPane;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextDisplayWidget;
import fabric.com.gitlab.cdagaming.craftpresence.utils.updater.ModUpdaterUtils;
import java.util.Map;
import net.minecraft.class_437;

public class UpdateInfoGui
extends ExtendedScreen {
    private final ModUpdaterUtils modUpdater;
    private TextDisplayWidget infoPane;
    private ExtendedButtonControl downloadButton;
    private ExtendedButtonControl checkButton;

    public UpdateInfoGui(class_437 parentScreen, ModUpdaterUtils modUpdater) {
        super(parentScreen);
        this.modUpdater = modUpdater;
    }

    @Override
    public void initializeUi() {
        this.checkButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, 180, 20, "gui.config.message.button.check_for_updates", () -> {
            this.resetNotes();
            this.modUpdater.checkForUpdates(this::updateNotes);
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(6, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.back", () -> this.openScreen(this.parentScreen), new String[0]));
        this.downloadButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 101, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.download", () -> UrlUtils.openUrl(this.modUpdater.downloadUrl), new String[0]));
        ScrollPane childFrame = this.addControl(new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 32));
        this.infoPane = childFrame.addWidget(new TextDisplayWidget((ExtendedScreen)childFrame, 0, 0, this.getScreenWidth()));
        this.updateNotes();
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.downloadButton.setControlEnabled(this.modUpdater.currentState == ModUpdaterUtils.UpdateState.OUTDATED || this.modUpdater.currentState == ModUpdaterUtils.UpdateState.BETA_OUTDATED);
        this.checkButton.setControlEnabled(this.modUpdater.currentState != ModUpdaterUtils.UpdateState.PENDING);
        super.preRender();
    }

    @Override
    public void renderExtra() {
        String mainTitle = Constants.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = Constants.TRANSLATOR.translate("gui.config.title.changes", this.modUpdater.currentState.getDisplayName());
        this.renderCenteredString(mainTitle, (float)this.getScreenWidth() / 2.0f, 10.0f, 0xFFFFFF);
        this.renderCenteredString(subTitle, (float)this.getScreenWidth() / 2.0f, 20.0f, 0xFFFFFF);
        super.renderExtra();
    }

    @Override
    public void postRender() {
        String mainTitle = Constants.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = Constants.TRANSLATOR.translate("gui.config.title.changes", this.modUpdater.currentState.getDisplayName());
        if (RenderUtils.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0, this.getStringWidth(mainTitle), this.getFontHeight())) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.title", "v2.2.2", CraftPresence.CONFIG._schemaVersion)));
        }
        if (RenderUtils.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0, this.getStringWidth(subTitle), this.getFontHeight())) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.title.changes", ModUtils.MCVersion)));
        }
        super.postRender();
    }

    private void resetNotes() {
        String notice = Constants.TRANSLATOR.translate("gui.config.message.changelog", new Object[0]) + "\n  N/A";
        this.infoPane.setMessage(notice);
    }

    private void updateNotes() {
        if (!this.modUpdater.changelogData.isEmpty()) {
            StringBuilder notice = new StringBuilder();
            notice.append(Constants.TRANSLATOR.translate("gui.config.message.changelog", new Object[0]));
            for (Map.Entry<String, String> entry : this.modUpdater.changelogData.entrySet()) {
                notice.append('\n').append("  ").append(entry.getKey()).append(":").append('\n').append(entry.getValue()).append('\n').append(' ');
            }
            this.infoPane.setMessage(notice.toString());
        } else {
            this.resetNotes();
        }
    }
}

