/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.core.utils.MathUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import java.awt.Color;

public class ScrollPane
extends ExtendedScreen {
    private static final Color NONE = StringUtils.getColorFrom(0, 0, 0, 0);
    private static final int DEFAULT_PADDING = 4;
    private static final int DEFAULT_BAR_WIDTH = 6;
    private static final int DEFAULT_HEIGHT_PER_SCROLL = 8;
    private boolean clickedScrollbar;
    private int padding;
    private float amountScrolled;

    public ScrollPane(int startX, int startY, int width, int height, int padding) {
        this.setScreenX(startX);
        this.setScreenY(startY);
        this.setScreenWidth(width - startX);
        this.setScreenHeight(height - startY);
        this.setPadding(padding);
        this.setScroll(0.0f);
    }

    public ScrollPane(int startX, int startY, int width, int height) {
        this(startX, startY, width, height, 4);
    }

    public ScrollPane(int width, int height, int padding) {
        this(0, 0, width, height, padding);
    }

    public ScrollPane(int width, int height) {
        this(width, height, 4);
    }

    @Override
    public void resetMouseScroll() {
        super.resetMouseScroll();
        this.setScroll(this.getMouseScroll());
    }

    @Override
    public void refreshContentHeight() {
        super.refreshContentHeight();
        this.setContentHeight((int)((float)this.getContentHeight() + this.getAmountScrolled()));
    }

    @Override
    public double getOffset() {
        return this.getAmountScrolled();
    }

    @Override
    public float getTintFactor() {
        return 0.5f;
    }

    @Override
    public void postRender() {
        RenderUtils.drawGradient(this.getLeft(), this.getRight(), this.getTop(), this.getTop() + this.getPadding(), 0.0, Color.black, NONE);
        RenderUtils.drawGradient(this.getLeft(), this.getRight(), this.getBottom() - this.getPadding(), this.getBottom(), 0.0, NONE, Color.black);
        if (this.needsScrollbar()) {
            int scrollBarX = this.getScrollBarX();
            int scrollBarRight = scrollBarX + this.getScrollBarWidth();
            int bottom = this.getBottom();
            int top = this.getTop();
            int maxScroll = this.getMaxScroll();
            int screenHeight = this.getScreenHeight();
            int height = this.getBarHeight();
            float barTop = this.getAmountScrolled() * (float)(screenHeight - height) / (float)maxScroll + (float)top;
            if (barTop < (float)top) {
                barTop = top;
            }
            RenderUtils.drawGradient(scrollBarX, scrollBarRight, top, bottom, 0.0, Color.black, Color.black);
            RenderUtils.drawGradient(scrollBarX, scrollBarRight, barTop, barTop + (float)height, 0.0, Color.gray, Color.gray);
            RenderUtils.drawGradient(scrollBarX, scrollBarRight - 1, barTop, barTop + (float)height - 1.0f, 0.0, Color.lightGray, Color.lightGray);
        }
        super.postRender();
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.isLoaded()) {
            this.checkScrollbarClick(mouseX, mouseY, mouseButton);
            return super.method_25402(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isLoaded()) {
            if (button == 0 && this.needsScrollbar() && this.clickedScrollbar) {
                if (mouseY < (double)this.getTop()) {
                    this.setScroll(0.0f);
                } else if (mouseY > (double)this.getBottom()) {
                    this.setScroll(this.getMaxScroll());
                } else {
                    int deltaYInt = (int)(deltaY > 0.0 ? deltaY + 0.5 : deltaY - 0.5);
                    int height = this.getBarHeight();
                    int scrollLimit = Math.max(1, this.getMaxScroll());
                    int heightPerScroll = Math.max(1, scrollLimit / (this.getScreenHeight() - height));
                    this.scrollBy(deltaYInt * heightPerScroll);
                }
                return true;
            }
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double wheelY) {
        this.scrollBy((float)(-wheelY * (double)this.getHeightPerScroll()));
        return true;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int newPadding) {
        this.padding = newPadding;
    }

    public int getScrollBarX() {
        return this.getRight() - this.getScrollBarWidth();
    }

    public int getScrollBarWidth() {
        return 6;
    }

    public int getHeightPerScroll() {
        return 8;
    }

    public void scrollBy(float amount) {
        this.setScroll(this.getAmountScrolled() + amount);
    }

    public void setScroll(float amount) {
        float prevScrollAmount = this.getAmountScrolled();
        this.setAmountScrolled(amount);
        this.bindAmountScrolled();
        if (this.getAmountScrolled() != prevScrollAmount) {
            int scrollDiff = (int)(this.getAmountScrolled() - prevScrollAmount);
            for (DynamicWidget widget : this.getWidgets()) {
                widget.setControlPosY(widget.getControlPosY() - scrollDiff);
            }
        }
    }

    public void checkScrollbarClick(double mouseX, double mouseY, int button) {
        this.clickedScrollbar = button == 0 && MathUtils.isWithinValue(mouseX, this.getScrollBarX(), this.getScrollBarX() + this.getScrollBarWidth(), true, false);
    }

    public void bindAmountScrolled() {
        this.setAmountScrolled(MathUtils.clamp(this.getAmountScrolled(), 0.0f, (float)this.getMaxScroll()));
    }

    public float getAmountScrolled() {
        return this.amountScrolled;
    }

    public void setAmountScrolled(float scrolled) {
        this.amountScrolled = scrolled;
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.getBottom() - this.getPadding()));
    }

    public int getBarHeight() {
        if (!this.needsScrollbar()) {
            return 0;
        }
        int barHeight = this.getScreenHeight() * this.getScreenHeight() / this.getContentHeight();
        return MathUtils.clamp(barHeight, 32, this.getScreenHeight() - this.getPadding() * 2);
    }

    public boolean needsScrollbar() {
        return this.getMaxScroll() > 0;
    }

    @Override
    public int getMaxWidth() {
        return this.getScreenWidth() - this.getPadding() - this.getScrollBarWidth();
    }
}

