/*
 * Decompiled with CFR 0.152.
 */
package external.net.lenni0451.reflect.stream.method;

import external.net.lenni0451.reflect.JavaBypass;
import external.net.lenni0451.reflect.Methods;
import external.net.lenni0451.reflect.stream.RStream;
import external.net.lenni0451.reflect.stream.method.MethodWrapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MethodStream {
    private final RStream parent;
    private final List<MethodWrapper> methods;

    public MethodStream(RStream parent, boolean withSuper) {
        this.parent = parent;
        this.methods = new ArrayList<MethodWrapper>();
        Class<?> clazz = parent.clazz();
        do {
            for (Method method : Methods.getDeclaredMethods(clazz)) {
                this.methods.add(new MethodWrapper(this, method));
            }
        } while (withSuper && (clazz = clazz.getSuperclass()) != null);
    }

    public RStream parent() {
        return this.parent;
    }

    public int size() {
        return this.methods.size();
    }

    public MethodWrapper by(String name) {
        for (MethodWrapper method : this.methods) {
            if (!method.name().equals(name)) continue;
            return method;
        }
        JavaBypass.UNSAFE.throwException(new NoSuchMethodException());
        return null;
    }

    public MethodWrapper by(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            for (MethodWrapper method : this.methods) {
                if (method.parameterCount() != 0) continue;
                return method;
            }
        } else {
            for (MethodWrapper method : this.methods) {
                if (!Arrays.equals(method.parameterTypes(), parameterTypes)) continue;
                return method;
            }
        }
        JavaBypass.UNSAFE.throwException(new NoSuchMethodException());
        return null;
    }

    public MethodWrapper by(String name, Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            for (MethodWrapper method : this.methods) {
                if (!method.name().equals(name) || method.parameterCount() != 0) continue;
                return method;
            }
        } else {
            for (MethodWrapper method : this.methods) {
                if (!method.name().equals(name) || !Arrays.equals(method.parameterTypes(), parameterTypes)) continue;
                return method;
            }
        }
        JavaBypass.UNSAFE.throwException(new NoSuchMethodException());
        return null;
    }

    public MethodWrapper by(int index) {
        try {
            return this.methods.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            JavaBypass.UNSAFE.throwException(new NoSuchMethodException());
            return null;
        }
    }

    public MethodStream filter(Predicate<MethodWrapper> filter) {
        this.methods.removeIf(filter.negate());
        return this;
    }

    public MethodStream filter(String name) {
        return this.filter((MethodWrapper method) -> method.name().equals(name));
    }

    public MethodStream filter(Collection<String> names) {
        return this.filter((MethodWrapper method) -> names.contains(method.name()));
    }

    public MethodStream filter(String ... names) {
        return this.filter(Arrays.asList(names));
    }

    public MethodStream filter(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return this.filter((MethodWrapper method) -> method.parameterCount() == 0);
        }
        return this.filter((MethodWrapper method) -> Arrays.equals(method.parameterTypes(), parameterTypes));
    }

    public MethodStream filter(boolean isStatic) {
        return this.filter((MethodWrapper method) -> method.modifier().isStatic() == isStatic);
    }

    public Iterator<MethodWrapper> iterator() {
        return this.methods.iterator();
    }

    public Stream<MethodWrapper> jstream() {
        return this.methods.stream();
    }

    public MethodStream forEach(Consumer<MethodWrapper> consumer) {
        this.methods.forEach(consumer);
        return this;
    }
}

