/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.utils;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.utils.MappingUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.UrlUtils;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import external.io.github.classgraph.ClassGraph;
import external.io.github.classgraph.ClassInfo;
import external.io.github.classgraph.ScanResult;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class FileUtils {
    private static final GsonBuilder GSON_BUILDER = new GsonBuilder();
    private static final Map<String, ClassInfo> CLASS_MAP = StringUtils.newHashMap();
    private static boolean ARE_CLASSES_LOADING = false;

    public static <T> T getJsonData(File data, Class<T> classObj, Modifiers ... args) throws Exception {
        return (T)FileUtils.getJsonData(FileUtils.fileToString(data, "UTF-8"), classObj, args);
    }

    public static JsonElement getJsonData(File data, Modifiers ... args) throws Exception {
        return FileUtils.getJsonData(data, JsonElement.class, args);
    }

    public static <T> T getJsonData(String data, Class<T> classObj, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        return (T)builder.create().fromJson(data, classObj);
    }

    public static JsonElement getJsonData(String data, Modifiers ... args) {
        return FileUtils.getJsonData(data, JsonElement.class, args);
    }

    public static <T> T getJsonData(File data, Type typeObj, Modifiers ... args) throws Exception {
        return FileUtils.getJsonData(FileUtils.fileToString(data, "UTF-8"), typeObj, args);
    }

    public static <T> T getJsonData(String data, Type typeObj, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        return (T)builder.create().fromJson(data, typeObj);
    }

    public static <T> T getJsonData(T data, Class<T> classObj, Modifiers ... args) {
        return (T)FileUtils.getJsonData(data.toString(), classObj, args);
    }

    public static String toJsonData(Object obj, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        if (obj instanceof String || obj instanceof Reader || obj instanceof JsonReader) {
            obj = FileUtils.parseJson(obj);
        }
        return builder.create().toJson(obj);
    }

    public static JsonElement parseJson(Object json) {
        if (json instanceof String) {
            return new JsonParser().parse((String)json);
        }
        if (json instanceof Reader) {
            return new JsonParser().parse((Reader)json);
        }
        if (json instanceof JsonReader) {
            return new JsonParser().parse((JsonReader)json);
        }
        return null;
    }

    public static void writeJsonData(Object json, File file, String encoding, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        try {
            FileUtils.assertFileExists(file);
        }
        catch (Exception ex1) {
            Constants.LOG.error("Failed to create json data @ " + file.getAbsolutePath(), new Object[0]);
            Constants.LOG.debugError(ex1);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), Charset.forName(encoding));){
            builder.create().toJson(json, (Appendable)writer);
        }
        catch (Exception ex2) {
            Constants.LOG.error("Failed to write json data @ " + file.getAbsolutePath(), new Object[0]);
            Constants.LOG.debugError(ex2);
        }
    }

    public static void assertFileExists(File file) throws Exception {
        boolean fileAvailable;
        File parentDir = file.getParentFile();
        boolean parentDirPresent = file.getParentFile().exists() || file.getParentFile().mkdirs();
        boolean bl = fileAvailable = file.exists() && file.isFile() || file.createNewFile();
        if (!parentDirPresent) {
            throw new UnsupportedOperationException("Failed to setup parent directory @ " + parentDir.getAbsolutePath());
        }
        if (!fileAvailable) {
            throw new UnsupportedOperationException("Failed to setup target file (Unable to create or is not a file) @ " + file.getAbsolutePath());
        }
    }

    public static void downloadFile(String urlString, File file) {
        try {
            Constants.LOG.info("Downloading \"%s\" to \"%s\"... (From: \"%s\")", file.getName(), file.getAbsolutePath(), urlString);
            URL url = new URL(urlString);
            if (file.exists() && !file.delete()) {
                Constants.LOG.error("Failed to remove: " + file.getName(), new Object[0]);
            }
            FileUtils.copyStreamToFile(UrlUtils.getURLStream(url), file);
            Constants.LOG.info("\"%s\" has been successfully downloaded to \"%s\"! (From: \"%s\")", file.getName(), file.getAbsolutePath(), urlString);
        }
        catch (Exception ex) {
            Constants.LOG.error("Failed to download \"%s\" from \"%s\"", file.getName(), urlString);
            Constants.LOG.debugError(ex);
        }
    }

    public static void copyStreamToFile(InputStream stream, File file, boolean close) throws Exception {
        FileUtils.assertFileExists(file);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = stream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
        }
        if (close) {
            stream.close();
        }
    }

    public static void copyStreamToFile(InputStream stream, File file) throws Exception {
        FileUtils.copyStreamToFile(stream, file, true);
    }

    public static void copyToFile(InputStream stream, File file) throws Exception {
        FileUtils.copyStreamToFile(stream, file, false);
    }

    public static String fileToString(File file, String encoding) throws Exception {
        return FileUtils.fileToString(Files.newInputStream(file.toPath(), new OpenOption[0]), encoding);
    }

    public static String fileToString(InputStream stream, String encoding) throws Exception {
        return UrlUtils.readerToString(new BufferedReader(new InputStreamReader(stream, Charset.forName(encoding))));
    }

    public static InputStream stringToStream(String stream, String encoding) {
        return new ByteArrayInputStream(StringUtils.getBytes(stream, encoding));
    }

    public static String getFileExtension(File file) {
        return FileUtils.getFileExtension(file.getName());
    }

    public static String getFileExtension(String name) {
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    public static String getFileNameWithoutExtension(File file) {
        return FileUtils.getFileNameWithoutExtension(file.getName());
    }

    public static String getFileNameWithoutExtension(String name) {
        if (name.indexOf(".") > 0) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public static int getModCount() {
        Object mods;
        Object loaderInstance;
        int modCount = -1;
        Class<?> fmlLoader = FileUtils.findValidClass("net.minecraftforge.fml.common.Loader");
        Class<?> quiltLoader = FileUtils.findValidClass("org.quiltmc.loader.api.QuiltLoader");
        Class<?> fabricLoader = FileUtils.findValidClass("net.fabricmc.loader.api.FabricLoader");
        if (fmlLoader != null) {
            Object mods2;
            Object loaderInstance2 = StringUtils.executeMethod(fmlLoader, null, null, null, "instance");
            if (loaderInstance2 != null && (mods2 = StringUtils.executeMethod(fmlLoader, loaderInstance2, null, null, "getModList")) instanceof List) {
                modCount = ((List)mods2).size();
            }
        } else if (quiltLoader != null) {
            Object mods3 = StringUtils.executeMethod(quiltLoader, null, null, null, "getAllMods");
            if (mods3 instanceof List) {
                modCount = ((List)mods3).size();
            }
        } else if (fabricLoader != null && (loaderInstance = StringUtils.executeMethod(fabricLoader, null, null, null, "getInstance")) != null && (mods = StringUtils.executeMethod(fabricLoader, loaderInstance, null, null, "getAllMods")) instanceof List) {
            modCount = ((List)mods).size();
        }
        return modCount > 0 ? modCount : FileUtils.getRawModCount();
    }

    public static int getRawModCount() {
        int modCount = 0;
        File[] mods = new File(Constants.modsDir).listFiles();
        if (mods != null) {
            for (File modFile : mods) {
                if (!FileUtils.getFileExtension(modFile).equals(".jar")) continue;
                ++modCount;
            }
        }
        return Math.max(1, modCount);
    }

    public static Map<String, ClassInfo> getClassNamesMatchingSuperType(List<Class<?>> searchList, String ... sourcePackages) {
        Map<String, ClassInfo> matchingClasses = StringUtils.newHashMap();
        List<String> sourceData = StringUtils.newArrayList(sourcePackages);
        Pair<Boolean, Map<Object, Object>> subClassData = new Pair(false, StringUtils.newHashMap());
        block0: for (Map.Entry<String, ClassInfo> classInfo : FileUtils.getClasses(sourceData).entrySet()) {
            for (Class<?> searchClass : searchList) {
                subClassData = FileUtils.isSubclassOf(classInfo.getValue(), searchClass, subClassData.getSecond());
                if (subClassData.getFirst().booleanValue()) {
                    if (!matchingClasses.containsKey(classInfo.getKey())) {
                        matchingClasses.put(classInfo.getKey(), classInfo.getValue());
                    }
                    for (Map.Entry<Object, Object> subClassInfo : subClassData.getSecond().entrySet()) {
                        if (matchingClasses.containsKey(subClassInfo.getKey())) continue;
                        matchingClasses.put((String)subClassInfo.getKey(), (ClassInfo)subClassInfo.getValue());
                    }
                    continue block0;
                }
                subClassData = new Pair(false, StringUtils.newHashMap());
            }
        }
        return matchingClasses;
    }

    protected static Pair<Boolean, Map<String, ClassInfo>> isSubclassOf(ClassInfo originalClass, Class<?> superClass, Map<String, ClassInfo> scannedClasses) {
        String superClassName;
        if (originalClass == null || superClass == null) {
            return new Pair<Boolean, Map<String, ClassInfo>>(false, scannedClasses);
        }
        if (originalClass.getName().equals(superClass.getName())) {
            return new Pair<Boolean, Map<String, ClassInfo>>(true, scannedClasses);
        }
        String originalName = MappingUtils.getMappedPath(originalClass.getName());
        String className = MappingUtils.getCanonicalName(originalClass);
        if (className.equals(superClassName = MappingUtils.getCanonicalName(superClass))) {
            return new Pair<Boolean, Map<String, ClassInfo>>(true, scannedClasses);
        }
        scannedClasses.put(originalName, originalClass);
        Pair<Boolean, Map<String, ClassInfo>> subClassInfo = FileUtils.isSubclassOf(originalClass.getSuperclass(), superClass, scannedClasses);
        if (!subClassInfo.getFirst().booleanValue() && originalClass.getInterfaces() != null) {
            for (ClassInfo inter : originalClass.getInterfaces()) {
                if (!FileUtils.isSubclassOf(inter, superClass, scannedClasses).getFirst().booleanValue()) continue;
                return new Pair<Boolean, Map<String, ClassInfo>>(true, scannedClasses);
            }
        }
        return new Pair<Boolean, Map<String, ClassInfo>>(subClassInfo.getFirst(), scannedClasses);
    }

    public static Map<String, ClassInfo> getClassNamesMatchingSuperType(Class<?> searchTarget, String ... sourcePackages) {
        return FileUtils.getClassNamesMatchingSuperType(StringUtils.newArrayList(searchTarget), sourcePackages);
    }

    public static Class<?> findValidClass(ClassLoader loader, boolean init, String ... paths) {
        List<String> classList = StringUtils.newArrayList(paths);
        for (String path : paths) {
            StringUtils.addEntriesNotPresent(classList, MappingUtils.getUnmappedClassesMatching(path, true));
        }
        Iterator<String> iterator = classList.iterator();
        while (iterator.hasNext()) {
            String path;
            switch (path = (String)iterator.next()) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
            try {
                if (loader == null) {
                    return Class.forName(path);
                }
                return Class.forName(path, init, loader);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static Class<?> findValidClass(ClassLoader loader, String ... paths) {
        return FileUtils.findValidClass(loader, false, paths);
    }

    public static Class<?> findValidClass(boolean useClassLoader, String ... paths) {
        return FileUtils.findValidClass(useClassLoader ? MappingUtils.CLASS_LOADER : null, paths);
    }

    public static Class<?> findValidClass(String ... paths) {
        return FileUtils.findValidClass(true, paths);
    }

    public static boolean canScanClasses() {
        return !ARE_CLASSES_LOADING;
    }

    public static void detectClasses() {
        Constants.getThreadFactory().newThread(FileUtils::scanClasses).start();
    }

    public static Map<String, ClassInfo> scanClasses() {
        if (FileUtils.canScanClasses()) {
            ARE_CLASSES_LOADING = true;
            CLASS_MAP.clear();
            ClassGraph graphInfo = new ClassGraph().enableClassInfo().rejectPackages("net.java", "com.sun", "com.jcraft", "com.intellij", "jdk", "akka", "ibxm", "scala", "*.mixin.*", "*.mixins.*", "*.jetty.*").disableModuleScanning();
            if (MappingUtils.JAVA_SPEC < 16.0f) {
                graphInfo.overrideClassLoaders(MappingUtils.CLASS_LOADER);
            }
            try (ScanResult scanResult = graphInfo.scan();){
                for (ClassInfo result : scanResult.getAllClasses()) {
                    String resultName = MappingUtils.getMappedPath(result.getName());
                    if (CLASS_MAP.containsKey(resultName) || resultName.toLowerCase().contains("mixin")) continue;
                    CLASS_MAP.put(resultName, result);
                }
            }
            catch (Throwable ex) {
                Constants.LOG.debugError(ex);
            }
            ARE_CLASSES_LOADING = false;
        }
        return StringUtils.newHashMap(CLASS_MAP);
    }

    public static Map<String, ClassInfo> getClassMap() {
        if (CLASS_MAP.isEmpty()) {
            return FileUtils.scanClasses();
        }
        return StringUtils.newHashMap(CLASS_MAP);
    }

    public static Map<String, ClassInfo> getClasses(List<String> paths) {
        Map<String, ClassInfo> results = StringUtils.newHashMap();
        Map<String, Set<String>> unmappedNames = StringUtils.newHashMap();
        for (String string : paths) {
            unmappedNames.put(string, MappingUtils.getUnmappedClassesMatching(string));
        }
        for (Map.Entry entry : FileUtils.getClassMap().entrySet()) {
            if (entry == null) continue;
            String classPath = (String)entry.getKey();
            boolean hasMatch = paths.isEmpty();
            for (String path : paths) {
                Set unmapped = (Set)unmappedNames.get(path);
                if (!classPath.startsWith(path) && !unmapped.contains(classPath)) continue;
                hasMatch = true;
                break;
            }
            if (!hasMatch) continue;
            try {
                results.put(classPath, (ClassInfo)entry.getValue());
            }
            catch (Throwable throwable) {}
        }
        return results;
    }

    public static List<String> filesInDir(Class<?> fallbackClass, String pathToSearch) {
        List<String> paths = StringUtils.newArrayList();
        if (!((String)pathToSearch).endsWith("/")) {
            pathToSearch = (String)pathToSearch + "/";
        }
        try {
            Path myPath;
            URI uri = FileUtils.getResource(fallbackClass, (String)pathToSearch).toURI();
            FileSystem fileSystem = null;
            if (uri.getScheme().equals("jar")) {
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (Exception ex) {
                    fileSystem = FileSystems.newFileSystem(uri, StringUtils.newHashMap());
                }
                myPath = fileSystem.getPath((String)pathToSearch, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
            try {
                Iterator it = walk.iterator();
                it.next();
                while (it.hasNext()) {
                    paths.add((String)pathToSearch + ((Path)it.next()).getFileName());
                }
            }
            catch (Throwable ex) {
                if (walk != null) {
                    try {
                        walk.close();
                    }
                    catch (Throwable ex2) {
                        ex.addSuppressed(ex2);
                    }
                }
                throw ex;
            }
            walk.close();
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return paths;
    }

    public static InputStream getResourceAsStream(Class<?> fallbackClass, String pathToSearch) {
        InputStream in = null;
        boolean useFallback = false;
        try {
            in = MappingUtils.CLASS_LOADER.getResourceAsStream(pathToSearch);
        }
        catch (Exception ex) {
            useFallback = true;
        }
        if (useFallback || in == null) {
            in = fallbackClass.getResourceAsStream(pathToSearch);
        }
        return in;
    }

    public static URL getResource(Class<?> fallbackClass, String pathToSearch) {
        URL in = null;
        boolean useFallback = false;
        try {
            in = MappingUtils.CLASS_LOADER.getResource(pathToSearch);
        }
        catch (Exception ex) {
            useFallback = true;
        }
        if (useFallback || in == null) {
            in = fallbackClass.getResource(pathToSearch);
        }
        return in;
    }

    public static GsonBuilder applyModifiers(GsonBuilder instance, Modifiers ... args) {
        block4: for (Modifiers param : args) {
            switch (param) {
                case DISABLE_ESCAPES: {
                    instance.disableHtmlEscaping();
                    continue block4;
                }
                case PRETTY_PRINT: {
                    instance.setPrettyPrinting();
                    continue block4;
                }
            }
        }
        return instance;
    }

    public static enum Modifiers {
        DISABLE_ESCAPES,
        PRETTY_PRINT;

    }
}

