/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import me.pepperbell.continuity.client.config.Option;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuityConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"Continuity Config");
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ContinuityConfig INSTANCE = new ContinuityConfig(FabricLoader.getInstance().getConfigDir().resolve("continuity.json").toFile());
    protected final File file;
    protected final Object2ObjectLinkedOpenHashMap<String, Option<?>> optionMap = new Object2ObjectLinkedOpenHashMap();
    protected final Map<String, Option<?>> optionMapView = Collections.unmodifiableMap(this.optionMap);
    public final Option.BooleanOption connectedTextures = this.addOption(new Option.BooleanOption("connected_textures", true));
    public final Option.BooleanOption emissiveTextures = this.addOption(new Option.BooleanOption("emissive_textures", true));
    public final Option.BooleanOption customBlockLayers = this.addOption(new Option.BooleanOption("custom_block_layers", true));
    public final Option.BooleanOption useManualCulling = this.addOption(new Option.BooleanOption("use_manual_culling", true));

    public ContinuityConfig(File file) {
        this.file = file;
    }

    public void load() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                this.fromJson(JsonParser.parseReader((Reader)reader));
            }
            catch (Exception e) {
                LOGGER.error("Could not load config from file '" + this.file.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        this.save();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson(this.toJson(), (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Could not save config to file '" + this.file.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    protected void fromJson(JsonElement json) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
                JsonElement element = object.get((String)entry.getKey());
                if (element == null) continue;
                try {
                    ((Option)entry.getValue()).fromJson(element);
                }
                catch (JsonParseException e) {
                    LOGGER.error("Could not read option '" + (String)entry.getKey() + "'", (Throwable)e);
                }
            }
        } else {
            throw new JsonParseException("Json must be an object");
        }
    }

    protected JsonElement toJson() {
        JsonObject object = new JsonObject();
        ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
            object.add((String)entry.getKey(), ((Option)entry.getValue()).toJson());
        }
        return object;
    }

    protected <T extends Option<?>> T addOption(T option) {
        Option old = (Option)this.optionMap.put((Object)option.getKey(), option);
        if (old != null) {
            LOGGER.warn("Option with key '" + old.getKey() + "' was overridden");
        }
        return option;
    }

    @Nullable
    public Option<?> getOption(String key) {
        return (Option)this.optionMap.get((Object)key);
    }

    public Map<String, Option<?>> getOptionMapView() {
        return this.optionMapView;
    }

    static {
        INSTANCE.load();
    }
}

