/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandAction;
import thetadev.constructionwand.api.IWandCore;
import thetadev.constructionwand.api.IWandSupplier;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.ModStats;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.items.ModItems;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.wand.supplier.SupplierInventory;
import thetadev.constructionwand.wand.supplier.SupplierRandom;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class WandJob {
    public final PlayerEntity player;
    public final World world;
    public final BlockRayTraceResult rayTraceResult;
    public final WandOptions options;
    public final ItemStack wand;
    public final ItemWand wandItem;
    private final IWandAction wandAction;
    private final IWandSupplier wandSupplier;
    private List<ISnapshot> placeSnapshots;

    public WandJob(PlayerEntity player, World world, BlockRayTraceResult rayTraceResult, ItemStack wand) {
        this.player = player;
        this.world = world;
        this.rayTraceResult = rayTraceResult;
        this.placeSnapshots = new ArrayList<ISnapshot>();
        this.wand = wand;
        this.wandItem = (ItemWand)wand.func_77973_b();
        this.options = new WandOptions(wand);
        this.wandSupplier = this.options.random.get() != false ? new SupplierRandom(player, this.options) : new SupplierInventory(player, this.options);
        this.wandAction = ((IWandCore)this.options.cores.get()).getWandAction();
        this.wandSupplier.getSupply(WandJob.getTargetItem(world, rayTraceResult));
    }

    @Nullable
    private static BlockItem getTargetItem(World world, BlockRayTraceResult rayTraceResult) {
        Item tgitem = world.func_180495_p(rayTraceResult.func_216350_a()).func_177230_c().func_199767_j();
        if (!(tgitem instanceof BlockItem)) {
            return null;
        }
        return (BlockItem)tgitem;
    }

    public void getSnapshots() {
        int limit = this.player.func_184812_l_() && this.wandItem == ModItems.WAND_INFINITY ? (Integer)ConfigServer.LIMIT_CREATIVE.get() : Math.min(this.wandItem.remainingDurability(this.wand), this.wandAction.getLimit(this.wand));
        this.placeSnapshots = this.rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK ? this.wandAction.getSnapshots(this.world, this.player, this.rayTraceResult, this.wand, this.options, this.wandSupplier, limit) : this.wandAction.getSnapshotsFromAir(this.world, this.player, this.rayTraceResult, this.wand, this.options, this.wandSupplier, limit);
    }

    public Set<BlockPos> getBlockPositions() {
        return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
    }

    public boolean doIt() {
        ArrayList<ISnapshot> executed = new ArrayList<ISnapshot>();
        for (ISnapshot snapshot : this.placeSnapshots) {
            if (this.wand.func_190926_b() || this.wandItem.remainingDurability(this.wand) == 0) break;
            if (!snapshot.execute(this.world, this.player, this.rayTraceResult)) continue;
            if (this.player.func_184812_l_()) {
                executed.add(snapshot);
            } else if (this.wandSupplier.takeItemStack(snapshot.getRequiredItems()) == 0) {
                executed.add(snapshot);
                this.wand.func_222118_a(1, (LivingEntity)this.player, e -> e.func_213334_d(this.player.field_184622_au));
            } else {
                ConstructionWand.LOGGER.info("Item could not be taken. Remove block: " + snapshot.getBlockState().func_177230_c().toString());
                snapshot.forceRestore(this.world);
            }
            this.player.func_195066_a(ModStats.USE_WAND);
        }
        this.placeSnapshots = executed;
        if (!this.placeSnapshots.isEmpty()) {
            SoundType sound = this.placeSnapshots.get(0).getBlockState().func_215695_r();
            this.world.func_184133_a(null, WandUtil.playerPos(this.player), sound.func_185841_e(), SoundCategory.BLOCKS, sound.field_185860_m, sound.field_185861_n);
            ConstructionWand.instance.undoHistory.add(this.player, this.world, this.placeSnapshots);
        }
        return !this.placeSnapshots.isEmpty();
    }
}

