/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.logging;

import com.connectivity.Connectivity;
import com.connectivity.logging.ByteBufferTypeHandler;
import com.connectivity.logging.EntityTypeHandler;
import com.connectivity.logging.GsonOptionalTypeHandler;
import com.connectivity.networkstats.INamedPacket;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ReflectionAccessFilter;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2540;
import net.minecraft.class_2596;

public class PacketLogging {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().addReflectionAccessFilter(ReflectionAccessFilter.BLOCK_INACCESSIBLE_JAVA).registerTypeHierarchyAdapter(Optional.class, new GsonOptionalTypeHandler()).registerTypeHierarchyAdapter(class_1299.class, new EntityTypeHandler()).registerTypeHierarchyAdapter(class_2540.class, new ByteBufferTypeHandler()).create();

    public static void logPacket(class_2596<?> packet) {
        PacketLogging.logPacket(packet, "");
    }

    public static void logPacket(class_2596<?> packet, String warning) {
        String name = packet.getClass().getSimpleName();
        if (packet instanceof INamedPacket && !((INamedPacket)packet).getName().isEmpty()) {
            name = ((INamedPacket)packet).getName();
        }
        Connectivity.LOGGER.warn("Packet:" + name + " " + warning);
        try {
            Connectivity.LOGGER.warn("Packet data:\n" + GSON.toJson(packet));
        }
        catch (Throwable e) {
            Connectivity.LOGGER.warn("Failed to print data for packet", e);
        }
    }
}

