/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.mixin.server.world;

import com.google.common.collect.Lists;
import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import com.lilypuree.connectiblechains.network.ModPacketHandler;
import com.lilypuree.connectiblechains.network.S2CMultiChainAttachPacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkManager.class})
public class ChunkManagerMixin {
    @Shadow
    @Final
    private Int2ObjectMap<ChunkManager.EntityTracker> entityMap;

    @Inject(method={"playerLoadedChunk"}, at={@At(value="TAIL")})
    public void sendAttachChainPackets(ServerPlayerEntity player, IPacket<?>[] packets, Chunk chunk, CallbackInfo ci) {
        ObjectIterator var6 = this.entityMap.values().iterator();
        ArrayList list = Lists.newArrayList();
        while (var6.hasNext()) {
            ChunkManager.EntityTracker entityTracker = (ChunkManager.EntityTracker)var6.next();
            Entity entity = entityTracker.field_219403_c;
            if (entity == player || entity.field_70176_ah != chunk.func_76632_l().field_77276_a || entity.field_70164_aj != chunk.func_76632_l().field_77275_b || !(entity instanceof ChainKnotEntity) || ((ChainKnotEntity)entity).getHoldingEntities().isEmpty()) continue;
            list.add((ChainKnotEntity)entity);
        }
        if (!list.isEmpty()) {
            for (ChainKnotEntity chainKnotEntity : list) {
                int[] ids = chainKnotEntity.getHoldingEntities().stream().mapToInt(Entity::func_145782_y).toArray();
                if (ids.length <= 0) continue;
                S2CMultiChainAttachPacket packet = new S2CMultiChainAttachPacket(chainKnotEntity.func_145782_y(), ids);
                ModPacketHandler.sendToClient(packet, player);
            }
        }
    }
}

