/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.events;

import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import com.lilypuree.connectiblechains.entity.ModEntityTypes;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="connectiblechains", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity.func_200600_R() == ModEntityTypes.CHAIN_KNOT.get()) {
            entity.func_213317_d(Vector3d.field_186680_a);
        }
    }

    @SubscribeEvent
    public static void onBlockUpdate(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        if (world.func_180495_p(event.getPos()).func_235714_a_((ITag)BlockTags.field_219748_G)) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            List list = world.func_217357_a(ChainKnotEntity.class, new AxisAlignedBB((double)x - 1.0, (double)y - 1.0, (double)z - 1.0, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0));
            boolean isCreative = event.getPlayer().func_184812_l_();
            for (ChainKnotEntity entity : list) {
                entity.breakChain(isCreative);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        boolean isChain;
        PlayerEntity playerEntity = event.getPlayer();
        World world = event.getWorld();
        BlockPos blockPos = event.getPos();
        Block block = world.func_180495_p(blockPos).func_177230_c();
        boolean bl = isChain = event.getItemStack().func_77973_b() == Items.field_234729_dO_;
        if (isChain) {
            ItemStack itemStack = event.getItemStack();
            if (ChainKnotEntity.canConnectTo(block) && playerEntity != null && !playerEntity.func_213453_ef()) {
                ChainKnotEntity knot;
                if (!world.func_201670_d() && !ChainKnotEntity.tryAttachHeldChainsToBlock(playerEntity, world, blockPos, knot = ChainKnotEntity.getOrCreate(world, blockPos, false)).booleanValue()) {
                    if (knot.getHoldingEntities().contains(playerEntity)) {
                        knot.detachChain((Entity)playerEntity, true, false);
                        knot.func_110128_b(null);
                        if (!playerEntity.func_184812_l_()) {
                            itemStack.func_190917_f(1);
                        }
                    } else {
                        knot.attachChain((Entity)playerEntity, true, 0);
                        knot.func_184523_o();
                        if (!playerEntity.func_184812_l_()) {
                            itemStack.func_190918_g(1);
                        }
                    }
                }
                playerEntity.func_184609_a(event.getHand());
                event.setUseItem(Event.Result.DENY);
            }
        } else if (block instanceof FenceBlock || block instanceof WallBlock) {
            if (!world.func_201670_d()) {
                boolean attached = ChainKnotEntity.tryAttachHeldChainsToBlock(playerEntity, world, blockPos, ChainKnotEntity.getOrCreate(world, blockPos, true));
                if (attached) {
                    event.setUseBlock(Event.Result.ALLOW);
                    event.setUseItem(Event.Result.DENY);
                } else {
                    event.setUseBlock(Event.Result.DEFAULT);
                }
            } else if (isChain) {
                event.setUseBlock(Event.Result.ALLOW);
            }
        }
    }
}

