/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.entity;

import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import com.lilypuree.connectiblechains.entity.ModEntityTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class ChainCollisionEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private int startOwnerId;
    private int endOwnerId;

    public ChainCollisionEntity(EntityType<? extends ChainCollisionEntity> entityType, World world) {
        super(entityType, world);
        this.field_98038_p = true;
    }

    public ChainCollisionEntity(World world, double x, double y, double z, int startOwnerId, int endOwnerId) {
        this((EntityType<? extends ChainCollisionEntity>)((EntityType)ModEntityTypes.CHAIN_COLLISION.get()), world);
        this.startOwnerId = startOwnerId;
        this.endOwnerId = endOwnerId;
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            Entity startOwner = this.field_70170_p.func_73045_a(this.startOwnerId);
            Entity endOwner = this.field_70170_p.func_73045_a(this.endOwnerId);
            Entity sourceEntity = source.func_76346_g();
            if (sourceEntity instanceof PlayerEntity && startOwner instanceof ChainKnotEntity && endOwner instanceof ChainKnotEntity) {
                boolean isCreative = ((PlayerEntity)sourceEntity).func_184812_l_();
                if (!((PlayerEntity)sourceEntity).func_184614_ca().func_190926_b() && ((PlayerEntity)sourceEntity).func_184614_ca().func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS)) {
                    ((ChainKnotEntity)startOwner).damageLink(isCreative, (ChainKnotEntity)endOwner);
                }
            }
            return true;
        }
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS)) {
            return super.func_70112_a(distance);
        }
        return false;
    }

    protected void func_70037_a(CompoundNBT tag) {
    }

    protected void func_213281_b(CompoundNBT tag) {
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_85031_j(Entity attacker) {
        this.func_184185_a(SoundEvents.field_232694_bB_, 0.5f, 1.0f);
        if (attacker instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)attacker;
            return this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)playerEntity), 0.0f);
        }
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(this.startOwnerId);
        buffer.func_150787_b(this.endOwnerId);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.setStartOwnerId(additionalData.func_150792_a());
        this.setEndOwnerId(additionalData.func_150792_a());
        Vector3d pos = this.func_213303_ch();
        this.func_174826_a(new AxisAlignedBB(pos, pos).func_72321_a(0.01, 0.0, 0.01));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Items.field_234729_dO_);
    }

    public void setStartOwnerId(int startOwnerId) {
        this.startOwnerId = startOwnerId;
    }

    public void setEndOwnerId(int endOwnerId) {
        this.endOwnerId = endOwnerId;
    }
}

