/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.client.render.entity;

import com.lilypuree.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import com.lilypuree.connectiblechains.util.Helper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChainKnotEntityRenderer
extends EntityRenderer<ChainKnotEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("connectiblechains", "textures/entity/chain_knot.png");
    private final ChainKnotEntityModel<ChainKnotEntity> model = new ChainKnotEntityModel();

    public ChainKnotEntityRenderer(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void render(ChainKnotEntity chainKnotEntity, float f, float g, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int i) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(-0.9f, -0.9f, 0.9f);
        this.model.func_225597_a_(chainKnotEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        IVertexBuilder vertexConsumer = renderTypeBuffer.getBuffer(this.model.func_228282_a_(TEXTURE));
        this.model.func_225598_a_(matrixStack, vertexConsumer, i, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        ArrayList<Entity> entities = chainKnotEntity.getHoldingEntities();
        for (Entity entity : entities) {
            this.createChainLine(chainKnotEntity, g, matrixStack, renderTypeBuffer, entity);
        }
        super.func_225623_a_((Entity)chainKnotEntity, f, g, matrixStack, renderTypeBuffer, i);
    }

    public boolean shouldRender(ChainKnotEntity entity, ClippingHelper clippingHelper, double x, double y, double z) {
        boolean should = entity.getHoldingEntities().stream().anyMatch(entity1 -> {
            if (entity1 instanceof ChainKnotEntity) {
                return super.func_225626_a_((Entity)((ChainKnotEntity)((Object)entity1)), clippingHelper, x, y, z);
            }
            return entity1 instanceof PlayerEntity;
        });
        return super.func_225626_a_((Entity)entity, clippingHelper, x, y, z) || should;
    }

    public ResourceLocation getTextureLocation(ChainKnotEntity entity) {
        return TEXTURE;
    }

    private void createChainLine(ChainKnotEntity fromEntity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer renderTypeBuffer, Entity toEntity) {
        float lerpDistanceZ;
        float lerpDistanceY;
        float lerpDistanceX;
        if (toEntity == null) {
            return;
        }
        matrices.func_227860_a_();
        double d = MathHelper.func_219799_g((float)(tickDelta * 0.5f), (float)toEntity.field_70177_z, (float)toEntity.field_70126_B) * ((float)Math.PI / 180);
        double e = MathHelper.func_219799_g((float)(tickDelta * 0.5f), (float)toEntity.field_70125_A, (float)toEntity.field_70127_C) * ((float)Math.PI / 180);
        double g = Math.cos(d);
        double h = Math.sin(d);
        double i = Math.sin(e);
        if (toEntity instanceof HangingEntity) {
            double toLerpX = MathHelper.func_219803_d((double)tickDelta, (double)toEntity.field_70142_S, (double)toEntity.func_226277_ct_());
            double toLerpY = MathHelper.func_219803_d((double)tickDelta, (double)toEntity.field_70137_T, (double)toEntity.func_226278_cu_());
            double toLerpZ = MathHelper.func_219803_d((double)tickDelta, (double)toEntity.field_70136_U, (double)toEntity.func_226281_cx_());
            double fromLerpX = MathHelper.func_219803_d((double)tickDelta, (double)fromEntity.field_70142_S, (double)fromEntity.func_226277_ct_());
            double fromLerpY = MathHelper.func_219803_d((double)tickDelta, (double)fromEntity.field_70137_T, (double)fromEntity.func_226278_cu_());
            double fromLerpZ = MathHelper.func_219803_d((double)tickDelta, (double)fromEntity.field_70136_U, (double)fromEntity.func_226281_cx_());
            lerpDistanceX = (float)(toLerpX - fromLerpX);
            lerpDistanceY = (float)(toLerpY - fromLerpY);
            lerpDistanceZ = (float)(toLerpZ - fromLerpZ);
        } else {
            double j = Math.cos(e);
            double k = MathHelper.func_219803_d((double)tickDelta, (double)toEntity.field_70142_S, (double)toEntity.func_226277_ct_()) - g * 0.7 - h * 0.5 * j;
            double l = MathHelper.func_219803_d((double)tickDelta, (double)(toEntity.field_70137_T + (double)toEntity.func_70047_e() * 0.7), (double)(toEntity.func_226278_cu_() + (double)toEntity.func_70047_e() * 0.7)) - i * 0.5 - 0.5;
            double m = MathHelper.func_219803_d((double)tickDelta, (double)toEntity.field_70136_U, (double)toEntity.func_226281_cx_()) - h * 0.7 + g * 0.5 * j;
            double o = MathHelper.func_219803_d((double)tickDelta, (double)fromEntity.field_70142_S, (double)fromEntity.func_226277_ct_());
            double p = MathHelper.func_219803_d((double)tickDelta, (double)fromEntity.field_70137_T, (double)fromEntity.func_226278_cu_()) + (double)0.3f;
            double q = MathHelper.func_219803_d((double)tickDelta, (double)fromEntity.field_70136_U, (double)fromEntity.func_226281_cx_());
            lerpDistanceX = (float)(k - o);
            lerpDistanceY = (float)(l - p);
            lerpDistanceZ = (float)(m - q);
        }
        matrices.func_227861_a_(0.0, (double)0.3f, 0.0);
        IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(RenderType.func_228649_h_());
        float v = MathHelper.func_226165_i_((float)(lerpDistanceX * lerpDistanceX + lerpDistanceZ * lerpDistanceZ)) * 0.025f / 2.0f;
        float xOffset = lerpDistanceZ * v;
        float zOffset = lerpDistanceX * v;
        BlockPos blockPosOfStart = new BlockPos(fromEntity.func_174824_e(tickDelta));
        BlockPos blockPosOfEnd = new BlockPos(toEntity.func_174824_e(tickDelta));
        int blockLightLevelOfStart = fromEntity.field_70170_p.func_226658_a_(LightType.BLOCK, blockPosOfStart);
        int blockLightLevelOfEnd = toEntity.field_70170_p.func_226658_a_(LightType.BLOCK, blockPosOfEnd);
        int skylightLevelOfStart = fromEntity.field_70170_p.func_226658_a_(LightType.SKY, blockPosOfStart);
        int skylightLevelOfEnd = fromEntity.field_70170_p.func_226658_a_(LightType.SKY, blockPosOfEnd);
        float distance = toEntity.func_70032_d((Entity)fromEntity);
        Matrix4f matrix4f = matrices.func_227866_c_().func_227870_a_();
        ChainKnotEntityRenderer.chainDrawer(distance, vertexBuilder, matrix4f, lerpDistanceX, lerpDistanceY, lerpDistanceZ, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd, xOffset, zOffset);
        matrices.func_227865_b_();
    }

    private static void chainDrawer(float distance, IVertexBuilder vertexBuilder, Matrix4f matrix4f, float lerpDistanceX, float lerpDistanceY, float lerpDistanceZ, int blockLightLevelOfStart, int blockLightLevelOfEnd, int skylightLevelOfStart, int skylightLevelOfEnd, float xOffset, float zOffset) {
        List<Integer> topLineA = Arrays.asList(1, 2, 3, 6, 7, 8, 9, 12, 13, 14);
        List<Integer> middleLineA = Arrays.asList(1, 3, 6, 9, 12, 14);
        List<Integer> bottomLineA = Arrays.asList(1, 2, 3, 6, 7, 8, 9, 12, 13, 14);
        List<Integer> topLineB = Arrays.asList(0, 1, 3, 4, 5, 6, 9, 10, 11, 12, 14, 15);
        List<Integer> middleLineB = Arrays.asList(1, 3, 6, 9, 12, 14);
        List<Integer> bottomLineB = Arrays.asList(0, 1, 3, 4, 5, 6, 9, 10, 11, 12, 14, 15);
        int length = (int)Math.floor(distance * 24.0f);
        float s = (float)skylightLevelOfEnd / (float)(length - 1);
        int t = (int)MathHelper.func_219799_g((float)s, (float)blockLightLevelOfStart, (float)blockLightLevelOfEnd);
        int u = (int)MathHelper.func_219799_g((float)s, (float)skylightLevelOfStart, (float)skylightLevelOfEnd);
        int pack = LightTexture.func_228451_a_((int)t, (int)u);
        float[] rotate = ChainKnotEntityRenderer.rotator(lerpDistanceX, lerpDistanceY, lerpDistanceZ);
        for (int step = 0; step < length; ++step) {
            float B;
            float G;
            float R;
            Vector3f endB;
            Vector3f endA;
            Vector3f startB;
            Vector3f startA;
            float startDrip = (float)Helper.drip(step, length);
            float endDrip = (float)Helper.drip(step + 1, length);
            float startStepFraction = (float)step / (float)length;
            float endStepFraction = (float)(step + 1) / (float)length;
            float v1 = rotate[3] != 1.0f ? 1.0f : -1.0f;
            float startRootX = lerpDistanceX * startStepFraction;
            float startRootY = lerpDistanceY * startStepFraction;
            float startRootZ = lerpDistanceZ * startStepFraction;
            float endRootX = lerpDistanceX * endStepFraction;
            float endRootY = lerpDistanceY * endStepFraction;
            float endRootZ = lerpDistanceZ * endStepFraction;
            float rotate0 = rotate[0];
            float rotate1 = rotate[1];
            float rotate2 = rotate[2];
            float chainHeight = 0.0125f;
            if (topLineA.contains(step % 16)) {
                startA = new Vector3f(startRootX - rotate0 + xOffset, startRootY + chainHeight + rotate1 + startDrip, startRootZ - rotate2 - zOffset);
                startB = new Vector3f(startRootX - (rotate0 - xOffset) * 3.0f, startRootY + chainHeight + rotate1 * 3.0f + startDrip, startRootZ - (rotate2 + zOffset) * 3.0f);
                endA = new Vector3f(endRootX - rotate0 + xOffset, endRootY + chainHeight + rotate1 + endDrip, endRootZ - rotate2 - zOffset);
                endB = new Vector3f(endRootX - (rotate0 - xOffset) * 3.0f, endRootY + chainHeight + rotate1 * 3.0f + endDrip, endRootZ - (rotate2 + zOffset) * 3.0f);
                R = 0.16f;
                G = 0.17f;
                B = 0.21f;
                ChainKnotEntityRenderer.renderPixel(startA, startB, endA, endB, vertexBuilder, matrix4f, pack, R, G, B);
            }
            if (middleLineA.contains(step % 16)) {
                startA = new Vector3f(startRootX + rotate0 + xOffset, startRootY + chainHeight - rotate1 + startDrip, startRootZ + rotate2 - zOffset);
                startB = new Vector3f(startRootX - rotate0 - xOffset, startRootY + chainHeight + rotate1 + startDrip, startRootZ - rotate2 + zOffset);
                endA = new Vector3f(endRootX + rotate0 + xOffset, endRootY + chainHeight - rotate1 + endDrip, endRootZ + rotate2 - zOffset);
                endB = new Vector3f(endRootX - rotate0 - xOffset, endRootY + chainHeight + rotate1 + endDrip, endRootZ - rotate2 + zOffset);
                R = 0.084f;
                G = 0.084f;
                B = 0.119f;
                ChainKnotEntityRenderer.renderPixel(startA, startB, endA, endB, vertexBuilder, matrix4f, pack, R, G, B);
            }
            if (bottomLineA.contains(step % 16)) {
                startA = new Vector3f(startRootX + (rotate0 - xOffset) * 3.0f, startRootY + chainHeight - rotate1 * 3.0f + startDrip, startRootZ + (rotate2 + zOffset) * 3.0f);
                startB = new Vector3f(startRootX + rotate0 - xOffset, startRootY + chainHeight - rotate1 + startDrip, startRootZ + rotate2 + zOffset);
                endA = new Vector3f(endRootX + (rotate0 - xOffset) * 3.0f, endRootY + chainHeight - rotate1 * 3.0f + endDrip, endRootZ + (rotate2 + zOffset) * 3.0f);
                endB = new Vector3f(endRootX + rotate0 - xOffset, endRootY + chainHeight - rotate1 + endDrip, endRootZ + rotate2 + zOffset);
                R = 0.16f;
                G = 0.17f;
                B = 0.21f;
                ChainKnotEntityRenderer.renderPixel(startA, startB, endA, endB, vertexBuilder, matrix4f, pack, R, G, B);
            }
            if (topLineB.contains(step % 16)) {
                startA = new Vector3f(startRootX - rotate0 * v1 - xOffset, startRootY + chainHeight + rotate1 + startDrip, startRootZ - rotate2 + zOffset);
                startB = new Vector3f(startRootX - (rotate0 * v1 + xOffset) * 3.0f, startRootY + chainHeight + rotate1 * 3.0f + startDrip, startRootZ - (rotate2 - zOffset) * 3.0f);
                endA = new Vector3f(endRootX - rotate0 * v1 - xOffset, endRootY + chainHeight + rotate1 + endDrip, endRootZ - rotate2 + zOffset);
                endB = new Vector3f(endRootX - (rotate0 * v1 + xOffset) * 3.0f, endRootY + chainHeight + rotate1 * 3.0f + endDrip, endRootZ - (rotate2 - zOffset) * 3.0f);
                R = 0.128f;
                G = 0.136f;
                B = 0.168f;
                ChainKnotEntityRenderer.renderPixel(startA, startB, endA, endB, vertexBuilder, matrix4f, pack, R, G, B);
            }
            if (middleLineB.contains(step % 16)) {
                startA = new Vector3f(startRootX + rotate0 * v1 - xOffset, startRootY + chainHeight - rotate1 + startDrip, startRootZ + rotate2 + zOffset);
                startB = new Vector3f(startRootX - rotate0 * v1 + xOffset, startRootY + chainHeight + rotate1 + startDrip, startRootZ - rotate2 - zOffset);
                endA = new Vector3f(endRootX + rotate0 * v1 - xOffset, endRootY + chainHeight - rotate1 + endDrip, endRootZ + rotate2 + zOffset);
                endB = new Vector3f(endRootX - rotate0 * v1 + xOffset, endRootY + chainHeight + rotate1 + endDrip, endRootZ - rotate2 - zOffset);
                R = 0.12f;
                G = 0.12f;
                B = 0.17f;
                ChainKnotEntityRenderer.renderPixel(startA, startB, endA, endB, vertexBuilder, matrix4f, pack, R, G, B);
            }
            if (!bottomLineB.contains(step % 16)) continue;
            startA = new Vector3f(startRootX + (rotate0 * v1 + xOffset) * 3.0f, startRootY + chainHeight - rotate1 * 3.0f + startDrip, startRootZ + (rotate2 - zOffset) * 3.0f);
            startB = new Vector3f(startRootX + rotate0 * v1 + xOffset, startRootY + chainHeight - rotate1 + startDrip, startRootZ + rotate2 - zOffset);
            endA = new Vector3f(endRootX + (rotate0 * v1 + xOffset) * 3.0f, endRootY + chainHeight - rotate1 * 3.0f + endDrip, endRootZ + (rotate2 - zOffset) * 3.0f);
            endB = new Vector3f(endRootX + rotate0 * v1 + xOffset, endRootY + chainHeight - rotate1 + endDrip, endRootZ + rotate2 - zOffset);
            R = 0.128f;
            G = 0.136f;
            B = 0.168f;
            ChainKnotEntityRenderer.renderPixel(startA, startB, endA, endB, vertexBuilder, matrix4f, pack, R, G, B);
        }
    }

    private static float[] rotator(double x, double y, double z) {
        double x2 = x * x;
        double z2 = z * z;
        double zx = Math.sqrt(x2 + z2);
        double arc1 = Math.atan2(y, zx);
        double arc2 = Math.atan2(x, z);
        double d = Math.sin(arc1) * (double)0.0125f;
        float y_new = (float)(Math.cos(arc1) * (double)0.0125f);
        float z_new = (float)(Math.cos(arc2) * d);
        float x_new = (float)(Math.sin(arc2) * d);
        float v = 0.0f;
        if (zx == 0.0) {
            x_new = z_new;
            v = 1.0f;
        }
        return new float[]{x_new, y_new, z_new, v};
    }

    private static void renderPixel(Vector3f startA, Vector3f startB, Vector3f endA, Vector3f endB, IVertexBuilder vertexConsumer, Matrix4f matrix4f, int lightPack, float R, float G, float B) {
        vertexConsumer.func_227888_a_(matrix4f, startA.func_195899_a(), startA.func_195900_b(), startA.func_195902_c()).func_227885_a_(R, G, B, 1.0f).func_227886_a_(lightPack).func_181675_d();
        vertexConsumer.func_227888_a_(matrix4f, startB.func_195899_a(), startB.func_195900_b(), startB.func_195902_c()).func_227885_a_(R, G, B, 1.0f).func_227886_a_(lightPack).func_181675_d();
        vertexConsumer.func_227888_a_(matrix4f, endB.func_195899_a(), endB.func_195900_b(), endB.func_195902_c()).func_227885_a_(R, G, B, 1.0f).func_227886_a_(lightPack).func_181675_d();
        vertexConsumer.func_227888_a_(matrix4f, endA.func_195899_a(), endA.func_195900_b(), endA.func_195902_c()).func_227885_a_(R, G, B, 1.0f).func_227886_a_(lightPack).func_181675_d();
    }
}

