/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.play;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.network.PacketHandler;
import com.mrcrayfish.configured.network.message.MessageSyncServerConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerPlayHandler {
    public static void handleSyncServerConfigMessage(ServerPlayerEntity player, MessageSyncServerConfig message) {
        if (!player.func_211513_k(player.field_71133_b.func_110455_j())) {
            Configured.LOGGER.warn("{} tried to update server config without operator status", (Object)player.func_200200_C_().func_150261_e());
            return;
        }
        Configured.LOGGER.debug("Received server config sync from player: {}", (Object)player.func_200200_C_().func_150261_e());
        Optional.ofNullable(ConfigHelper.getModConfig(message.getFileName())).ifPresent(config -> {
            CommentedConfig data = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(message.getData()));
            config.getConfigData().putAll((UnmodifiableConfig)data);
            ConfigHelper.resetCache(config);
            PacketHandler.getPlayChannel().send(PacketDistributor.ALL.with(() -> null), (Object)new MessageSyncServerConfig(message.getFileName(), message.getData()));
        });
    }
}

