/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FileUtils;

public class WorldSelectionScreen
extends ListMenuScreen {
    private static final FolderName SERVER_CONFIG_FOLDER = new FolderName("serverconfig");
    private static final ResourceLocation MISSING_ICON = new ResourceLocation("textures/misc/unknown_server.png");
    private final ModConfig config;

    public WorldSelectionScreen(Screen parent, ResourceLocation background, ModConfig config, ITextComponent title) {
        super(parent, (ITextComponent)new TranslationTextComponent("configured.gui.edit_world_config", new Object[]{title.func_230531_f_().func_240699_a_(TextFormatting.YELLOW)}), background, 30);
        this.config = config;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        try {
            SaveFormat saveFormat = Minecraft.func_71410_x().func_71359_d();
            List saveList = saveFormat.func_75799_b();
            Collections.sort(saveList);
            saveList.forEach(worldSummary -> entries.add(new WorldItem((WorldSummary)worldSummary)));
        }
        catch (AnvilConverterException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 75, this.field_230709_l_ - 29, 150, 20, DialogTexts.field_240637_h_, button -> this.field_230706_i_.func_147108_a(this.parent)));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.field_230708_k_ - 30), 15.0, 0.0);
        matrixStack.func_227862_a_(2.5f, 2.5f, 2.5f);
        AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("?").func_240699_a_(TextFormatting.BOLD), (int)0, (int)0, (int)0xFFFFFF);
        matrixStack.func_227865_b_();
    }

    @Override
    protected void updateTooltip(int mouseX, int mouseY) {
        super.updateTooltip(mouseX, mouseY);
        if (ScreenUtil.isMouseWithin(this.field_230708_k_ - 30, 15, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.server_config_info"), 200));
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.entries.forEach(item -> {
            if (item instanceof WorldItem) {
                ((WorldItem)item).disposeIcon();
            }
        });
    }

    static /* synthetic */ Minecraft access$400(WorldSelectionScreen x0) {
        return x0.field_230706_i_;
    }

    public class WorldItem
    extends ListMenuScreen.Item {
        private final ITextComponent worldName;
        private final ITextComponent folderName;
        private final ResourceLocation iconId;
        private final File iconFile;
        private final DynamicTexture texture;
        private final Button modifyButton;

        public WorldItem(WorldSummary summary) {
            super(summary.func_75788_b());
            this.worldName = new StringTextComponent(summary.func_75788_b());
            this.folderName = new StringTextComponent(summary.func_75786_a()).func_240699_a_(TextFormatting.GRAY);
            this.iconId = new ResourceLocation("minecraft", "worlds/" + Util.func_244361_a((String)summary.func_75786_a(), ResourceLocation::func_240909_b_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)summary.func_75786_a()) + "/icon");
            this.iconFile = summary.func_237312_c_().isFile() ? summary.func_237312_c_() : null;
            this.texture = this.loadWorldIcon();
            this.modifyButton = new Button(0, 0, 50, 20, (ITextComponent)new TranslationTextComponent("configured.gui.select"), onPress -> this.loadServerConfig(summary.func_75786_a(), summary.func_75788_b()));
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.modifyButton);
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            WorldSelectionScreen.this.field_230706_i_.func_110434_K().func_110577_a(this.texture != null ? this.iconId : MISSING_ICON);
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(left + 4), (int)top, (int)22, (int)22, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
            AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)((WorldSelectionScreen)WorldSelectionScreen.this).field_230706_i_.field_71466_p, (ITextComponent)this.worldName, (int)(left + 32), (int)(top + 2), (int)0xFFFFFF);
            AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)((WorldSelectionScreen)WorldSelectionScreen.this).field_230706_i_.field_71466_p, (ITextComponent)this.folderName, (int)(left + 32), (int)(top + 12), (int)0xFFFFFF);
            this.modifyButton.field_230690_l_ = left + width - 51;
            this.modifyButton.field_230691_m_ = top;
            this.modifyButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        /*
         * Exception decompiling
         */
        private DynamicTexture loadWorldIcon() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void disposeIcon() {
            if (this.texture != null) {
                this.texture.close();
            }
        }

        private void loadServerConfig(String worldFileName, String worldName) {
            try (SaveFormat.LevelSave levelSave = WorldSelectionScreen.this.field_230706_i_.func_71359_d().func_237274_c_(worldFileName);){
                Path serverConfigPath = levelSave.func_237285_a_(SERVER_CONFIG_FOLDER);
                FileUtils.getOrCreateDirectory((Path)serverConfigPath, (String)"serverconfig");
                CommentedFileConfig data = (CommentedFileConfig)WorldSelectionScreen.this.config.getHandler().reader(serverConfigPath).apply(WorldSelectionScreen.this.config);
                ConfigHelper.setConfigData(WorldSelectionScreen.this.config, (CommentedConfig)data);
                ModList.get().getModContainerById(WorldSelectionScreen.this.config.getModId()).ifPresent(container -> WorldSelectionScreen.this.field_230706_i_.func_147108_a((Screen)new ConfigScreen(WorldSelectionScreen.this.parent, (ITextComponent)new StringTextComponent(worldName), WorldSelectionScreen.this.config, WorldSelectionScreen.this.background)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

