/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurableextramobdrops.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective.functions.StringFunctions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class Util {
    private static String dirpath = System.getProperty("user.dir") + File.separator + "config" + File.separator + "configurableextramobdrops";
    private static File dir = new File(dirpath);
    private static File file = new File(dirpath + File.separator + "mobdropconfig.txt");
    public static HashMap<EntityType<?>, CopyOnWriteArrayList<ItemStack>> mobdrops = new HashMap();
    private static List<EntityType<?>> specialmiscmobs = new ArrayList<EntityType>(Arrays.asList(EntityType.field_200757_aw, EntityType.field_200745_ak, EntityType.field_200756_av));

    public static void loadMobConfigFile() throws IOException, FileNotFoundException, UnsupportedEncodingException {
        mobdrops = new HashMap();
        PrintWriter writer = null;
        if (!dir.isDirectory() || !file.isFile()) {
            dir.mkdirs();
            writer = new PrintWriter(dirpath + File.separator + "mobdropconfig.txt", "UTF-8");
        } else {
            String configcontent = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "mobdropconfig.txt", new String[0])), "UTF-8");
            for (String line : configcontent.split("\n")) {
                String[] linespl;
                if (line.trim().endsWith(",")) {
                    line = line.trim();
                    line = line.substring(0, line.length() - 1).trim();
                }
                if (line.length() < 5 || !line.contains("' : '") || (linespl = line.split("' : '")).length < 2) continue;
                String entityrl = linespl[0].substring(1).trim();
                String itemstring = linespl[1].trim();
                itemstring = itemstring.substring(0, itemstring.length() - 1).trim();
                EntityType entitytype = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityrl));
                if (entitytype == null) continue;
                CopyOnWriteArrayList<ItemStack> thedrops = new CopyOnWriteArrayList<ItemStack>();
                if (itemstring.length() > 3) {
                    for (String itemdata : itemstring.split(StringFunctions.escapeSpecialRegexChars((String)"|||"))) {
                        ItemStack itemstack = null;
                        try {
                            CompoundNBT newnbt = JsonToNBT.func_180713_a((String)itemdata);
                            itemstack = ItemStack.func_199557_a((CompoundNBT)newnbt);
                        }
                        catch (CommandSyntaxException commandSyntaxException) {
                            // empty catch block
                        }
                        if (itemstack == null) continue;
                        thedrops.add(itemstack.func_77946_l());
                    }
                }
                mobdrops.put(entitytype, thedrops);
            }
        }
        if (writer != null) {
            for (EntityType entitytype : ForgeRegistries.ENTITIES) {
                EntityClassification classification = entitytype.func_220339_d();
                if (classification.equals((Object)EntityClassification.MISC) && !specialmiscmobs.contains(entitytype)) continue;
                ResourceLocation rl = entitytype.getRegistryName();
                writer.println("'" + rl.toString() + "' : '',");
                mobdrops.put(entitytype, new CopyOnWriteArrayList());
            }
            writer.close();
        }
    }

    public static boolean writeDropsMapToFile() throws FileNotFoundException, UnsupportedEncodingException {
        if (!dir.isDirectory() || !file.isFile()) {
            dir.mkdirs();
        }
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "mobdropconfig.txt", "UTF-8");
        for (EntityType entitytype : ForgeRegistries.ENTITIES) {
            CopyOnWriteArrayList<ItemStack> drops;
            EntityClassification classification = entitytype.func_220339_d();
            if (classification.equals((Object)EntityClassification.MISC) && !specialmiscmobs.contains(entitytype)) continue;
            ResourceLocation rl = entitytype.getRegistryName();
            String itemdata = "";
            if (mobdrops.containsKey(entitytype) && (drops = mobdrops.get(entitytype)).size() > 0) {
                for (ItemStack drop : drops) {
                    if (itemdata != "") {
                        itemdata = itemdata + "|||";
                    }
                    CompoundNBT nbt = new CompoundNBT();
                    nbt = drop.func_77955_b(nbt);
                    String nbtstring = nbt.toString();
                    itemdata = itemdata + nbtstring;
                }
            }
            writer.println("'" + rl.toString() + "' : '" + itemdata + "',");
        }
        writer.close();
        return true;
    }
}

