/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.util;

import com.robotgryphon.compactmachines.CompactMachines;
import com.robotgryphon.compactmachines.block.tiles.CompactMachineTile;
import com.robotgryphon.compactmachines.config.ServerConfig;
import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.data.CompactMachineServerData;
import com.robotgryphon.compactmachines.data.SavedMachineData;
import com.robotgryphon.compactmachines.data.machines.CompactMachineRegistrationData;
import com.robotgryphon.compactmachines.reference.EnumMachineSize;
import com.robotgryphon.compactmachines.util.CompactMachinePlayerUtil;
import com.robotgryphon.compactmachines.util.CompactStructureGenerator;
import com.robotgryphon.compactmachines.util.MathUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public abstract class CompactMachineUtil {
    public static void teleportInto(ServerPlayerEntity serverPlayer, BlockPos machinePos, EnumMachineSize size) {
        ServerWorld serverWorld = serverPlayer.func_71121_q();
        MinecraftServer serv = serverWorld.func_73046_m();
        if (serverWorld.func_234923_W_() == Registration.COMPACT_DIMENSION) {
            IFormattableTextComponent msg = new TranslationTextComponent("compactmachines.cannot_enter").func_240699_a_(TextFormatting.RED);
            serverPlayer.func_146105_b((ITextComponent)msg, true);
            return;
        }
        ServerWorld compactWorld = serv.func_71218_a(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            CompactMachines.LOGGER.warn("Compact dimension not found; player attempted to enter machine.");
            return;
        }
        CompactMachineTile tile = (CompactMachineTile)serverWorld.func_175625_s(machinePos);
        if (tile == null) {
            return;
        }
        serv.func_213165_a(() -> {
            BlockPos spawnPoint;
            SavedMachineData machineData = SavedMachineData.getInstance(serv);
            CompactMachineServerData serverData = machineData.getData();
            if (tile.machineId == -1) {
                int nextID = serverData.getNextMachineId();
                BlockPos center = CompactMachineUtil.getCenterForNewMachine(nextID, size);
                CompactStructureGenerator.generateCompactStructure((IWorld)compactWorld, size, center);
                tile.setMachineId(nextID);
                CompactMachineRegistrationData regData = new CompactMachineRegistrationData(nextID, center, serverPlayer.func_110124_au(), size);
                regData.setWorldPosition(serverWorld, machinePos);
                serverData.registerMachine(nextID, regData);
                machineData.func_76185_a();
                BlockPos.Mutable spawn = center.func_239590_i_();
                spawn.func_185336_p(((Integer)ServerConfig.MACHINE_FLOOR_Y.get()).intValue());
                spawnPoint = spawn.func_185334_h();
            } else {
                Optional<CompactMachineRegistrationData> info = serverData.getMachineData(tile.machineId);
                if (!info.isPresent()) {
                    IFormattableTextComponent text = new TranslationTextComponent("messages.compactmachines.no_machine_data").func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD);
                    serverPlayer.func_146105_b((ITextComponent)text, true);
                    return;
                }
                CompactMachineRegistrationData data = info.get();
                BlockPos.Mutable spawn = data.getCenter().func_239590_i_();
                spawn.func_185336_p(spawn.func_177956_o() - size.getInternalSize() / 2);
                spawnPoint = data.getSpawnPoint().orElse((BlockPos)spawn);
            }
            try {
                CompactMachinePlayerUtil.addPlayerToMachine(serverPlayer, machinePos, tile.machineId);
            }
            catch (Exception ex) {
                CompactMachines.LOGGER.error((Object)ex);
            }
            serverPlayer.func_200619_a(compactWorld, (double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, serverPlayer.field_70177_z, serverPlayer.field_70125_A);
        });
    }

    public static EnumMachineSize getMachineSizeFromNBT(@Nullable CompoundNBT tag) {
        try {
            if (tag == null) {
                return EnumMachineSize.TINY;
            }
            if (!tag.func_74764_b("size")) {
                return EnumMachineSize.TINY;
            }
            String sizeFromTag = tag.func_74779_i("size");
            return EnumMachineSize.getFromSize(sizeFromTag);
        }
        catch (Exception ex) {
            return EnumMachineSize.TINY;
        }
    }

    public static Block getMachineBlockBySize(EnumMachineSize size) {
        switch (size) {
            case TINY: {
                return (Block)Registration.MACHINE_BLOCK_TINY.get();
            }
            case SMALL: {
                return (Block)Registration.MACHINE_BLOCK_SMALL.get();
            }
            case NORMAL: {
                return (Block)Registration.MACHINE_BLOCK_NORMAL.get();
            }
            case LARGE: {
                return (Block)Registration.MACHINE_BLOCK_LARGE.get();
            }
            case GIANT: {
                return (Block)Registration.MACHINE_BLOCK_GIANT.get();
            }
            case MAXIMUM: {
                return (Block)Registration.MACHINE_BLOCK_MAXIMUM.get();
            }
        }
        return (Block)Registration.MACHINE_BLOCK_NORMAL.get();
    }

    public static Item getMachineBlockItemBySize(EnumMachineSize size) {
        switch (size) {
            case TINY: {
                return (Item)Registration.MACHINE_BLOCK_ITEM_TINY.get();
            }
            case SMALL: {
                return (Item)Registration.MACHINE_BLOCK_ITEM_SMALL.get();
            }
            case NORMAL: {
                return (Item)Registration.MACHINE_BLOCK_ITEM_NORMAL.get();
            }
            case LARGE: {
                return (Item)Registration.MACHINE_BLOCK_ITEM_LARGE.get();
            }
            case GIANT: {
                return (Item)Registration.MACHINE_BLOCK_ITEM_GIANT.get();
            }
            case MAXIMUM: {
                return (Item)Registration.MACHINE_BLOCK_ITEM_MAXIMUM.get();
            }
        }
        return (Item)Registration.MACHINE_BLOCK_ITEM_NORMAL.get();
    }

    public static BlockPos getCenterForNewMachine(int id, EnumMachineSize size) {
        Vector3i location = MathUtil.getRegionPositionByIndex(id);
        int centerY = (Integer)ServerConfig.MACHINE_FLOOR_Y.get() + size.getInternalSize() / 2;
        return new BlockPos(location.func_177958_n() * 1024 + 8, centerY, location.func_177952_p() * 1024 + 8);
    }

    public static void setMachineSpawn(MinecraftServer server, BlockPos position) {
        SavedMachineData machineData = SavedMachineData.getInstance(server);
        CompactMachineServerData serverData = machineData.getData();
        Optional<CompactMachineRegistrationData> compactMachineData = serverData.getMachineContainingPosition(position);
        compactMachineData.ifPresent(d -> {
            d.setSpawnPoint(position);
            serverData.updateMachineData((CompactMachineRegistrationData)d);
            machineData.func_76185_a();
        });
    }

    public static Optional<SavedMachineData> getMachineData(ServerWorld world) {
        if (world == null) {
            return Optional.empty();
        }
        SavedMachineData md = SavedMachineData.getInstance(world.func_73046_m());
        return Optional.of(md);
    }

    public static Optional<CompactMachineRegistrationData> getMachineInfoByInternalPosition(ServerWorld world, Vector3d pos) {
        SavedMachineData machineData = SavedMachineData.getInstance(world.func_73046_m());
        CompactMachineServerData serverData = machineData.getData();
        return serverData.getMachineContainingPosition(pos);
    }

    public static Optional<CompactMachineRegistrationData> getMachineInfoByInternalPosition(ServerWorld world, BlockPos pos) {
        SavedMachineData machineData = SavedMachineData.getInstance(world.func_73046_m());
        CompactMachineServerData serverData = machineData.getData();
        return serverData.getMachineContainingPosition(pos);
    }

    public static void updateMachineInWorldPosition(ServerWorld world, int machineID, BlockPos pos) {
        SavedMachineData machineData = SavedMachineData.getInstance(world.func_73046_m());
        CompactMachineServerData serverData = machineData.getData();
        Optional<CompactMachineRegistrationData> machineById = serverData.getMachineData(machineID);
        machineById.ifPresent(data -> {
            data.setWorldPosition(world, pos);
            data.removeFromPlayerInventory();
            serverData.updateMachineData((CompactMachineRegistrationData)data);
            machineData.func_76185_a();
        });
    }
}

