/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.util;

import com.robotgryphon.compactmachines.data.CompactMachineServerData;
import com.robotgryphon.compactmachines.data.SavedMachineData;
import com.robotgryphon.compactmachines.data.machines.CompactMachinePlayerData;
import com.robotgryphon.compactmachines.network.MachinePlayersChangedPacket;
import com.robotgryphon.compactmachines.network.NetworkHandler;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.PacketDistributor;

public class CompactMachinePlayerUtil {
    public static void addPlayerToMachine(ServerPlayerEntity serverPlayer, BlockPos machinePos, int machineId) {
        MinecraftServer serv = serverPlayer.func_184102_h();
        SavedMachineData machineData = SavedMachineData.getInstance(serv);
        CompactMachineServerData serverData = machineData.getData();
        Optional<CompactMachinePlayerData> playerData = serverData.getPlayerData(machineId);
        playerData.ifPresent(d -> {
            d.addPlayer(serverPlayer);
            machineData.func_76185_a();
            MachinePlayersChangedPacket p = new MachinePlayersChangedPacket(serv, machineId, serverPlayer.func_110124_au(), MachinePlayersChangedPacket.EnumPlayerChangeType.ENTERED);
            NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> serverPlayer.func_71121_q().func_175726_f(machinePos)), (Object)p);
        });
    }

    public static void removePlayerFromMachine(ServerPlayerEntity serverPlayer, BlockPos machinePos, int machineId) {
        MinecraftServer serv = serverPlayer.func_184102_h();
        SavedMachineData machineData = SavedMachineData.getInstance(serv);
        CompactMachineServerData serverData = machineData.getData();
        Optional<CompactMachinePlayerData> playerData = serverData.getPlayerData(machineId);
        playerData.ifPresent(d -> {
            d.removePlayer(serverPlayer);
            machineData.func_76185_a();
            MachinePlayersChangedPacket p = new MachinePlayersChangedPacket(serv, machineId, serverPlayer.func_110124_au(), MachinePlayersChangedPacket.EnumPlayerChangeType.EXITED);
            NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> serverPlayer.func_71121_q().func_175726_f(machinePos)), (Object)p);
        });
    }
}

