/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.tunnels.definitions;

import com.robotgryphon.compactmachines.api.tunnels.EnumTunnelSide;
import com.robotgryphon.compactmachines.api.tunnels.IItemTunnel;
import com.robotgryphon.compactmachines.api.tunnels.TunnelDefinition;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.teleportation.DimensionalPosition;
import com.robotgryphon.compactmachines.tunnels.TunnelHelper;
import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemTunnelDefinition
extends TunnelDefinition
implements IItemTunnel {
    @Override
    public int getTunnelRingColor() {
        return new Color(205, 143, 36).getRGB();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getInternalCapability(ServerWorld compactWorld, BlockPos tunnelPos, @Nonnull Capability<T> cap, Direction side) {
        if (cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        TileEntity te = compactWorld.func_175625_s(tunnelPos);
        if (te instanceof TunnelWallTile) {
            TileEntity connectedTile;
            TunnelWallTile twt = (TunnelWallTile)te;
            Optional<BlockState> connectedState = TunnelHelper.getConnectedState(twt, EnumTunnelSide.INSIDE);
            if (!connectedState.isPresent()) {
                return LazyOptional.empty();
            }
            Optional<DimensionalPosition> tunnelConnectedPosition = TunnelHelper.getTunnelConnectedPosition(twt, EnumTunnelSide.INSIDE);
            if (!tunnelConnectedPosition.isPresent()) {
                return LazyOptional.empty();
            }
            Direction tunnelSide = twt.getTunnelSide();
            DimensionalPosition connectedInsidePos = tunnelConnectedPosition.get();
            if (connectedState.get().hasTileEntity() && (connectedTile = compactWorld.func_175625_s(connectedInsidePos.getBlockPosition())) != null) {
                return connectedTile.getCapability(cap, tunnelSide);
            }
        }
        return LazyOptional.empty();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getExternalCapability(ServerWorld world, BlockPos tunnelPos, @Nonnull Capability<T> cap, @Nullable Direction side) {
        TileEntity te = world.func_175625_s(tunnelPos);
        if (cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        if (te instanceof TunnelWallTile) {
            TileEntity connectedTile;
            TunnelWallTile twt = (TunnelWallTile)te;
            Optional<BlockState> connectedState = TunnelHelper.getConnectedState(twt, EnumTunnelSide.OUTSIDE);
            if (!connectedState.isPresent()) {
                return LazyOptional.empty();
            }
            Optional<DimensionalPosition> connectedPosition = twt.getConnectedPosition();
            if (!connectedPosition.isPresent()) {
                return LazyOptional.empty();
            }
            DimensionalPosition dimensionalPosition = connectedPosition.get();
            Optional<ServerWorld> connectedWorld = dimensionalPosition.getWorld(world.func_73046_m());
            if (!connectedWorld.isPresent()) {
                return LazyOptional.empty();
            }
            ServerWorld csw = connectedWorld.get();
            BlockPos connectedPos = dimensionalPosition.getBlockPosition();
            if (connectedState.get().hasTileEntity() && (connectedTile = csw.func_175625_s(connectedPos)) != null) {
                return connectedTile.getCapability(cap, twt.getTunnelSide().func_176734_d());
            }
            return LazyOptional.empty();
        }
        return LazyOptional.empty();
    }
}

