/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.item;

import com.robotgryphon.compactmachines.api.tunnels.TunnelDefinition;
import com.robotgryphon.compactmachines.api.tunnels.redstone.IRedstoneReaderTunnel;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.block.walls.TunnelWallBlock;
import com.robotgryphon.compactmachines.core.Registration;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class TunnelItem
extends Item {
    public TunnelItem(Item.Properties properties) {
        super(properties);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        String key = TunnelItem.getDefinition(stack).map(def -> {
            ResourceLocation id = def.getRegistryName();
            return "item." + id.func_110624_b() + ".tunnels." + id.func_110623_a().replace('/', '.');
        }).orElse("item.compactmachines.tunnels.unnamed");
        return new TranslationTextComponent(key);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TunnelItem.getDefinition(stack).ifPresent(tunnelDef -> {
            if (Screen.func_231173_s_()) {
                IFormattableTextComponent type = new TranslationTextComponent("tooltip.compactmachines.tunnel_type", new Object[]{tunnelDef.getRegistryName()}).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC);
                tooltip.add((ITextComponent)type);
            }
        });
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            IForgeRegistry definitions = GameRegistry.findRegistry(TunnelDefinition.class);
            definitions.getValues().forEach(def -> {
                ItemStack withDef = new ItemStack((IItemProvider)this, 1);
                CompoundNBT defTag = withDef.func_190925_c("definition");
                defTag.func_74778_a("id", def.getRegistryName().toString());
                items.add((Object)withDef);
            });
        }
    }

    public static Optional<TunnelDefinition> getDefinition(ItemStack stack) {
        CompoundNBT defTag = stack.func_190925_c("definition");
        if (defTag.isEmpty() || !defTag.func_74764_b("id")) {
            return Optional.empty();
        }
        ResourceLocation defId = new ResourceLocation(defTag.func_74779_i("id"));
        IForgeRegistry tunnelReg = GameRegistry.findRegistry(TunnelDefinition.class);
        if (!tunnelReg.containsKey(defId)) {
            return Optional.empty();
        }
        return Optional.ofNullable(tunnelReg.getValue(defId));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World w = context.func_195991_k();
        if (w.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        BlockPos pos = context.func_195995_a();
        BlockState blockState = w.func_180495_p(pos);
        if (blockState.func_177230_c() != Registration.BLOCK_SOLID_WALL.get()) {
            return ActionResultType.FAIL;
        }
        if (context.func_195999_j() instanceof ServerPlayerEntity) {
            ItemStack is = context.func_195996_i();
            Item i = is.func_77973_b();
            TunnelItem ti = (TunnelItem)i;
            Optional<TunnelDefinition> definition = TunnelItem.getDefinition(context.func_195996_i());
            definition.ifPresent(def -> {
                BlockState tunnelState = (BlockState)((Block)Registration.BLOCK_TUNNEL_WALL.get()).func_176223_P().func_206870_a((Property)TunnelWallBlock.TUNNEL_SIDE, (Comparable)context.func_196000_l());
                boolean redstone = def instanceof IRedstoneReaderTunnel;
                tunnelState = (BlockState)tunnelState.func_206870_a((Property)TunnelWallBlock.REDSTONE, (Comparable)Boolean.valueOf(redstone));
                w.func_180501_a(pos, tunnelState, 3);
                MinecraftServer server = ((ServerWorld)context.func_195991_k()).func_73046_m();
                server.func_213165_a(() -> {
                    TunnelWallTile tile = (TunnelWallTile)context.func_195991_k().func_175625_s(context.func_195995_a());
                    tile.setTunnelType(def.getRegistryName());
                });
                is.func_190918_g(1);
            });
            return ActionResultType.CONSUME;
        }
        return ActionResultType.FAIL;
    }

    protected ActionResult<ItemStack> swapTunnelType(Item type, PlayerEntity player, Hand hand) {
        if (player instanceof ServerPlayerEntity && player.func_225608_bj_()) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            ItemStack stack = serverPlayer.func_184586_b(hand);
            ItemStack newStack = new ItemStack((IItemProvider)type, stack.func_190916_E());
            serverPlayer.func_184611_a(hand, newStack);
            IFormattableTextComponent msg = new StringTextComponent("switch state").func_240699_a_(TextFormatting.GOLD);
            serverPlayer.func_146105_b((ITextComponent)msg, true);
            return ActionResult.func_226249_b_((Object)newStack);
        }
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }
}

