/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.data;

import com.robotgryphon.compactmachines.data.CompactMachineCommonData;
import com.robotgryphon.compactmachines.data.NbtListCollector;
import com.robotgryphon.compactmachines.data.machines.CompactMachinePlayerData;
import com.robotgryphon.compactmachines.data.machines.CompactMachineRegistrationData;
import com.robotgryphon.compactmachines.reference.EnumMachineSize;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class CompactMachineServerData
extends CompactMachineCommonData {
    private Map<Integer, CompactMachineRegistrationData> machineData = new HashMap<Integer, CompactMachineRegistrationData>();

    CompactMachineServerData() {
    }

    public static CompactMachineServerData fromNbt(CompoundNBT nbt) {
        CompactMachineServerData d = new CompactMachineServerData();
        d.deserializeNBT(nbt);
        return d;
    }

    @Override
    public CompoundNBT serializeNBT(CompoundNBT nbt) {
        nbt = super.serializeNBT(nbt);
        ListNBT machineList = this.machineData.values().stream().map(CompactMachineRegistrationData::serializeNBT).collect(NbtListCollector.toNbtList());
        nbt.func_218657_a("machines", (INBT)machineList);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("machines")) {
            ListNBT machines = nbt.func_150295_c("machines", 10);
            machines.forEach(data -> {
                CompactMachineRegistrationData md = CompactMachineRegistrationData.fromNBT(data);
                this.machineData.put(md.getId(), md);
            });
        }
    }

    public int getNextMachineId() {
        return this.machineData.size() + 1;
    }

    public boolean registerMachine(int newID, CompactMachineRegistrationData compactMachineData) {
        if (this.machineData.containsKey(newID)) {
            return false;
        }
        this.machineData.put(newID, compactMachineData);
        this.playerData.put(newID, new CompactMachinePlayerData(newID));
        return true;
    }

    public Stream<AxisAlignedBB> getAllMachineBounds() {
        return this.machineData.values().stream().map(mach -> new AxisAlignedBB(mach.getCenter(), mach.getCenter()).func_186662_g((double)mach.getSize().getInternalSize()));
    }

    public Stream<CompactMachineRegistrationData> getMachines() {
        return this.machineData.values().stream();
    }

    public Optional<CompactMachineRegistrationData> getMachineContainingPosition(Vector3d position) {
        return this.getMachines().filter(machine -> {
            BlockPos center = machine.getCenter();
            AxisAlignedBB bounds = new AxisAlignedBB(center, center).func_186662_g((double)machine.getSize().getInternalSize());
            return bounds.func_72318_a(position);
        }).findFirst();
    }

    public Optional<CompactMachineRegistrationData> getMachineContainingPosition(BlockPos position) {
        AxisAlignedBB possibleCenters = new AxisAlignedBB(position, position).func_186662_g((double)EnumMachineSize.maximum().getInternalSize());
        return this.getMachines().filter(machine -> {
            BlockPos center = machine.getCenter();
            Vector3d center3d = new Vector3d((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p());
            return possibleCenters.func_72318_a(center3d);
        }).findFirst();
    }

    public void updateMachineData(CompactMachineRegistrationData d) {
        int id = d.getId();
        if (!this.machineData.containsKey(id)) {
            return;
        }
        this.machineData.replace(id, d);
    }

    public Optional<CompactMachineRegistrationData> getMachineData(int machineId) {
        if (!this.machineData.containsKey(machineId)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.machineData.get(machineId));
    }
}

