/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.compat.theoneprobe.providers;

import com.mojang.authlib.GameProfile;
import com.robotgryphon.compactmachines.block.tiles.CompactMachineTile;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.compat.theoneprobe.IProbeData;
import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.data.machines.CompactMachineRegistrationData;
import com.robotgryphon.compactmachines.tunnels.TunnelHelper;
import java.util.Optional;
import java.util.Set;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CompactMachineProvider {
    public static void exec(IProbeData data, PlayerEntity player, World world, BlockState state) {
        ProbeMode mode = data.getMode();
        IProbeInfo info = data.getInfo();
        IProbeHitData hitData = data.getHitData();
        CompactMachineProvider.addProbeInfo(mode, info, player, world, state, hitData);
    }

    private static void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity player, World world, BlockState state, IProbeHitData hitData) {
        TileEntity te = world.func_175625_s(hitData.getPos());
        if (te instanceof CompactMachineTile) {
            CompactMachineTile machine = (CompactMachineTile)te;
            Optional<CompactMachineRegistrationData> machineData = machine.getMachineData();
            machineData.ifPresent(md -> {
                IFormattableTextComponent id = new TranslationTextComponent(String.format("tooltip.%s.machine_id", "compactmachines"), new Object[]{md.getId()}).func_240699_a_(TextFormatting.GREEN);
                info.text((ITextComponent)id);
                PlayerEntity owner = world.func_217371_b(md.getOwner());
                if (owner != null) {
                    GameProfile ownerProfile = owner.func_146103_bH();
                    IFormattableTextComponent ownerText = new TranslationTextComponent(String.format("tooltip.%s.owner", "compactmachines"), new Object[]{ownerProfile.getName()}).func_240699_a_(TextFormatting.GRAY);
                    info.text((ITextComponent)ownerText);
                }
                Set<BlockPos> tunnelsForMachineSide = TunnelHelper.getTunnelsForMachineSide(md.getId(), (ServerWorld)world, hitData.getSideHit());
                IProbeInfo vertical = info.vertical(info.defaultLayoutStyle().spacing(0));
                ServerWorld cm = world.func_73046_m().func_71218_a(Registration.COMPACT_DIMENSION);
                tunnelsForMachineSide.forEach(pos -> {
                    TunnelWallTile tile = (TunnelWallTile)cm.func_175625_s(pos);
                    if (tile == null) {
                        return;
                    }
                    tile.getTunnelDefinition().ifPresent(tunnelDef -> vertical.text((ITextComponent)new StringTextComponent(pos.toString() + ": " + tunnelDef.getRegistryName().toString())));
                });
            });
        }
    }
}

