/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.robotgryphon.compactmachines.client.gui.widget.AbstractCMGuiWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class ScrollableWrappedTextWidget
extends AbstractCMGuiWidget {
    private String localeKey;
    private double yScroll = 0.0;
    private FontRenderer fontRenderer;
    private int maxLinesToShow;
    private int lineIndexStart;
    private List<IReorderingProcessor> lines;
    private int charSize;

    public ScrollableWrappedTextWidget(String key, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.localeKey = key;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.recalculate();
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        double temp = this.yScroll - delta;
        this.yScroll = MathHelper.func_151237_a((double)temp, (double)0.0, (double)(this.lines.size() - this.maxLinesToShow - 1));
        this.recalculate();
        return true;
    }

    private void recalculate() {
        String t = I18n.func_135052_a((String)this.localeKey, (Object[])new Object[0]);
        this.lines = this.fontRenderer.func_238425_b_((ITextProperties)new StringTextComponent(t), this.width);
        this.charSize = this.fontRenderer.func_78256_a("M");
        int maxOnScreen = this.height / (this.charSize + 4);
        this.maxLinesToShow = Math.min(this.lines.size(), maxOnScreen);
        int startClamp = Math.min((int)Math.floor(this.yScroll), this.lines.size());
        this.lineIndexStart = MathHelper.func_76125_a((int)0, (int)startClamp, (int)(this.lines.size() - 1));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.x, (double)this.y, 10.0);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        try {
            for (int y = this.lineIndexStart; y <= this.lineIndexStart + this.maxLinesToShow; ++y) {
                IReorderingProcessor s = this.lines.get(y);
                fr.func_238407_a_(matrixStack, s, 0.0f, (float)((y - this.lineIndexStart) * (this.charSize + 4)), 0xFFFFFF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrixStack.func_227865_b_();
    }
}

