/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.client;

import com.robotgryphon.compactmachines.api.tunnels.TunnelDefinition;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;

public class TunnelColors
implements IBlockColor {
    public int getColor(BlockState state, @Nullable IBlockDisplayReader reader, @Nullable BlockPos pos, int tintIndex) {
        try {
            TileEntity tile = reader.func_175625_s(pos);
            if (tile instanceof TunnelWallTile) {
                TunnelWallTile tunnel = (TunnelWallTile)tile;
                Optional<TunnelDefinition> tunnelDefinition = tunnel.getTunnelDefinition();
                switch (tintIndex) {
                    case 0: {
                        return tunnelDefinition.map(TunnelDefinition::getTunnelRingColor).orElse(Color.gray.getRGB());
                    }
                    case 1: {
                        return tunnelDefinition.map(TunnelDefinition::getTunnelIndicatorColor).orElse(3751749);
                    }
                }
            }
            return Color.gray.getRGB();
        }
        catch (Exception ex) {
            return Color.red.getRGB();
        }
    }
}

