/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.block.tiles;

import com.robotgryphon.compactmachines.api.tunnels.ICapableTunnel;
import com.robotgryphon.compactmachines.api.tunnels.TunnelDefinition;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.config.ServerConfig;
import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.data.CompactMachineCommonData;
import com.robotgryphon.compactmachines.data.SavedMachineData;
import com.robotgryphon.compactmachines.data.machines.CompactMachinePlayerData;
import com.robotgryphon.compactmachines.data.machines.CompactMachineRegistrationData;
import com.robotgryphon.compactmachines.tunnels.TunnelHelper;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class CompactMachineTile
extends TileEntity
implements ICapabilityProvider,
ITickableTileEntity {
    public int machineId = -1;
    private boolean initialized = false;
    public boolean alreadyNotifiedOnTick = false;
    public long nextSpawnTick = 0L;
    protected UUID owner;
    protected String schema;
    protected boolean locked = false;
    protected Set<String> playerWhiteList = new HashSet<String>();
    @Nullable
    private CompactMachinePlayerData playerData = null;

    public CompactMachineTile() {
        super((TileEntityType)Registration.MACHINE_TILE_ENTITY.get());
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (((Boolean)ServerConfig.MACHINE_CHUNKLOADING.get()).booleanValue()) {
            this.doChunkload(true);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (((Boolean)ServerConfig.MACHINE_CHUNKLOADING.get()).booleanValue()) {
            this.doChunkload(false);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (((Boolean)ServerConfig.MACHINE_CHUNKLOADING.get()).booleanValue()) {
            this.doChunkload(false);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.machineId = nbt.func_74762_e("coords");
        this.owner = nbt.func_74764_b("owner") ? nbt.func_186857_a("owner") : null;
        this.nextSpawnTick = nbt.func_74763_f("spawntick");
        this.schema = nbt.func_74764_b("schema") ? nbt.func_74779_i("schema") : null;
        this.locked = nbt.func_74764_b("locked") ? nbt.func_74767_n("locked") : false;
        this.playerWhiteList = new HashSet<String>();
        if (nbt.func_74764_b("playerWhiteList")) {
            ListNBT list = nbt.func_150295_c("playerWhiteList", 8);
            list.forEach(nametag -> this.playerWhiteList.add(nametag.func_150285_a_()));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74768_a("coords", this.machineId);
        if (this.owner != null) {
            nbt.func_186854_a("owner", this.owner);
        }
        nbt.func_74772_a("spawntick", this.nextSpawnTick);
        if (this.schema != null) {
            nbt.func_74778_a("schema", this.schema);
        }
        nbt.func_74757_a("locked", this.locked);
        if (this.playerWhiteList.size() > 0) {
            ListNBT list = new ListNBT();
            this.playerWhiteList.forEach(player -> {
                StringNBT nameTag = StringNBT.func_229705_a_((String)player);
                list.add((Object)nameTag);
            });
            nbt.func_218657_a("playerWhiteList", (INBT)list);
        }
        return nbt;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.field_145850_b.func_201670_d()) {
            return super.getCapability(cap, side);
        }
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        ServerWorld compactWorld = serverWorld.func_73046_m().func_71218_a(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            return LazyOptional.empty();
        }
        Set<BlockPos> tunnelPositions = TunnelHelper.getTunnelsForMachineSide(this.machineId, serverWorld, side);
        if (tunnelPositions.isEmpty()) {
            return LazyOptional.empty();
        }
        for (BlockPos possibleTunnel : tunnelPositions) {
            LazyOptional<T> capPoss;
            TunnelDefinition definition;
            Optional<TunnelDefinition> tunnel;
            TunnelWallTile tile = (TunnelWallTile)compactWorld.func_175625_s(possibleTunnel);
            if (tile == null || !(tunnel = tile.getTunnelDefinition()).isPresent() || !((definition = tunnel.get()) instanceof ICapableTunnel) || !(capPoss = ((ICapableTunnel)((Object)definition)).getInternalCapability(compactWorld, possibleTunnel, cap, side)).isPresent()) continue;
            return capPoss;
        }
        return LazyOptional.empty();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        base.func_74768_a("machine", this.machineId);
        if (this.field_145850_b instanceof ServerWorld) {
            Optional<CompactMachinePlayerData> playerData = Optional.empty();
            try {
                SavedMachineData machineData = SavedMachineData.getInstance(this.field_145850_b.func_73046_m());
                playerData = machineData.getData().getPlayerData(this.machineId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            playerData.ifPresent(data -> {
                CompoundNBT playerNbt = data.serializeNBT();
                base.func_218657_a("players", (INBT)playerNbt);
            });
            if (this.owner != null) {
                base.func_186854_a("owner", this.owner);
            }
        }
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.machineId = tag.func_74762_e("machine");
        if (tag.func_74764_b("players")) {
            CompoundNBT players = tag.func_74775_l("players");
            this.playerData = CompactMachinePlayerData.fromNBT((INBT)players);
        }
        if (tag.func_74764_b("owner")) {
            this.owner = tag.func_186857_a("owner");
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState state = null;
        if (this.field_145850_b != null) {
            state = this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        this.func_230337_a_(state, pkt.func_148857_g());
    }

    public void func_73660_a() {
    }

    public Optional<UUID> getOwnerUUID() {
        return Optional.ofNullable(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setMachineId(int id) {
        this.machineId = id;
        this.func_70296_d();
    }

    public Optional<CompactMachineRegistrationData> getMachineData() {
        if (this.machineId == 0) {
            return Optional.empty();
        }
        if (this.field_145850_b instanceof ServerWorld) {
            return Optional.ofNullable(this.field_145850_b.func_73046_m()).map(SavedMachineData::getInstance).map(SavedMachineData::getData).flatMap(d -> d.getMachineData(this.machineId));
        }
        return Optional.empty();
    }

    public boolean hasPlayersInside() {
        return CompactMachineCommonData.getInstance().getPlayerData(this.machineId).map(CompactMachinePlayerData::hasPlayers).orElse(false);
    }

    protected void doChunkload(boolean force) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.getMachineData().ifPresent(data -> {
            ServerWorld compact = this.field_145850_b.func_73046_m().func_71218_a(Registration.COMPACT_DIMENSION);
            IChunk machineChunk = compact.func_217349_x(data.getCenter());
            ChunkPos chunkPos = machineChunk.func_76632_l();
            compact.func_217458_b(chunkPos.field_77276_a, chunkPos.field_77275_b, force);
        });
    }

    public void doPostPlaced() {
        this.doChunkload(true);
    }

    public void handlePlayerLeft(UUID playerID) {
        if (this.playerData != null) {
            this.playerData.removePlayer(playerID);
        }
    }

    public void handlePlayerEntered(UUID playerID) {
        if (this.playerData != null) {
            this.playerData.addPlayer(playerID);
        }
    }
}

