/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import top.theillusivec4.comforts.common.block.ComfortsBaseBlock;
import top.theillusivec4.comforts.common.block.RopeAndNailBlock;
import top.theillusivec4.comforts.common.tileentity.HammockTileEntity;

public class HammockBlock
extends ComfortsBaseBlock {
    private static final VoxelShape HAMMOCK_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)1.0));
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0));
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
    private final DyeColor color;

    public HammockBlock(DyeColor color) {
        super(ComfortsBaseBlock.BedType.HAMMOCK, color, AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200947_a(SoundType.field_185854_g).func_200943_b(0.1f));
        this.color = color;
        this.setRegistryName("comforts", "hammock_" + color.func_176762_d());
    }

    public static Direction getDirectionToOther(BedPart part, Direction facing) {
        return part == BedPart.FOOT ? facing : facing.func_176734_d();
    }

    public static void dropRopeSupport(BlockPos pos, Direction direction, boolean isHead, World worldIn) {
        BlockPos ropePos = isHead ? pos.func_177972_a(direction) : pos.func_177972_a(direction.func_176734_d());
        BlockState ropeState = worldIn.func_180495_p(ropePos);
        if (ropeState.func_177230_c() instanceof RopeAndNailBlock) {
            worldIn.func_175656_a(ropePos, (BlockState)ropeState.func_206870_a((Property)RopeAndNailBlock.SUPPORTING, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = HammockBlock.func_226862_h_((BlockState)state).func_176734_d();
        switch (direction) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return HAMMOCK_SHAPE;
    }

    @Override
    public void func_176208_a(World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        BedPart bedpart = (BedPart)state.func_177229_b((Property)field_176472_a);
        boolean isHead = bedpart == BedPart.HEAD;
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        BlockPos otherPos = pos.func_177972_a(HammockBlock.getDirectionToOther(bedpart, direction));
        HammockBlock.dropRopeSupport(pos, direction, isHead, worldIn);
        HammockBlock.dropRopeSupport(otherPos, direction, !isHead, worldIn);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return null;
        }
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        FluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)direction)).func_206870_a((Property)ComfortsBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a)) : null;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new HammockTileEntity(this.color);
    }
}

