/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.tileentity;

import com.shblock.colossalbattery.RegistryEntries;
import com.shblock.colossalbattery.helper.MathHelper;
import com.shblock.colossalbattery.tileentity.EnumIOMode;
import com.shblock.colossalbattery.tileentity.TileBatteryCore;
import com.shblock.colossalbattery.tileentity.TileMultiBlockPartBase;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class TileBatteryInterface
extends TileMultiBlockPartBase
implements IEnergyStorage,
CyclopsTileEntity.ITickingTile {
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private EnumIOMode mode = EnumIOMode.NORMAL;

    public TileBatteryInterface() {
        super(RegistryEntries.TILE_BATTERY_INTERFACE);
        this.addCapabilityInternal(CapabilityEnergy.ENERGY, LazyOptional.of(() -> this));
    }

    public EnumIOMode getMode() {
        return this.mode;
    }

    public void changeMode() {
        this.mode = this.mode.getNext();
        this.func_70296_d();
        this.sendUpdate();
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        this.mode = EnumIOMode.getById(tag.func_74762_e("mode"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("mode", this.mode.getId());
        return tag;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        TileBatteryCore te = this.getCoreTile();
        if (te != null) {
            return te.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        TileBatteryCore te = this.getCoreTile();
        if (te != null) {
            return te.extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored() {
        TileBatteryCore te = this.getCoreTile();
        if (te != null) {
            return te.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        TileBatteryCore te = this.getCoreTile();
        if (te != null) {
            return te.getMaxEnergyStored();
        }
        return 0;
    }

    public boolean canExtract() {
        return this.isFormed();
    }

    public boolean canReceive() {
        return this.isFormed();
    }

    public static LazyOptional<IEnergyStorage> getEnergyStorage(IBlockReader world, BlockPos pos, Direction facing) {
        IEnergyStorage energyStorage = (IEnergyStorage)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)facing, (Capability)CapabilityEnergy.ENERGY).orElse(null);
        return energyStorage == null ? LazyOptional.empty() : LazyOptional.of(() -> energyStorage);
    }

    private void autoOutput(TileBatteryCore core_tile) {
        if (core_tile == null) {
            return;
        }
        for (Direction facing : Direction.values()) {
            IEnergyStorage energyStorage = (IEnergyStorage)TileBatteryInterface.getEnergyStorage((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d()).orElse(null);
            if (energyStorage == null || energyStorage instanceof TileBatteryCore && ((TileBatteryCore)energyStorage).func_174877_v().equals((Object)this.core_pos) || energyStorage instanceof TileBatteryInterface && ((TileBatteryInterface)energyStorage).core_pos.equals((Object)this.core_pos)) continue;
            int energy = energyStorage.receiveEnergy(Math.min(core_tile.this_tick_extract_left, core_tile.getEnergyStored()), false);
            core_tile.setEnergy(core_tile.getEnergy() - (long)energy);
        }
    }

    private void autoInput(TileBatteryCore core_tile) {
        if (core_tile == null) {
            return;
        }
        for (Direction facing : Direction.values()) {
            IEnergyStorage energyStorage = (IEnergyStorage)TileBatteryInterface.getEnergyStorage((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d()).orElse(null);
            if (energyStorage == null || energyStorage instanceof TileBatteryCore && ((TileBatteryCore)energyStorage).func_174877_v().equals((Object)this.core_pos) || energyStorage instanceof TileBatteryInterface && ((TileBatteryInterface)energyStorage).core_pos.equals((Object)this.core_pos)) continue;
            int energy = energyStorage.extractEnergy(Math.min(core_tile.this_tick_receive_left, MathHelper.longToInt(core_tile.getCapacity() - core_tile.getEnergy())), false);
            core_tile.setEnergy(core_tile.getEnergy() + (long)energy);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d() && this.isFormed()) {
            switch (this.mode) {
                case NORMAL: {
                    break;
                }
                case INPUT: {
                    this.autoInput(this.getCoreTile());
                    break;
                }
                case OUTPUT: {
                    this.autoOutput(this.getCoreTile());
                }
            }
        }
        this.tickingTileComponent.func_73660_a();
    }
}

