/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.tileentity;

import com.shblock.colossalbattery.RegistryEntries;
import com.shblock.colossalbattery.helper.BatteryStructure;
import com.shblock.colossalbattery.helper.MathHelper;
import com.shblock.colossalbattery.helper.MultiBlockHelper;
import com.shblock.colossalbattery.material.BatteryMaterial;
import com.shblock.colossalbattery.tileentity.EnumIOMode;
import com.shblock.colossalbattery.tileentity.TileBatteryInterface;
import com.shblock.colossalbattery.tileentity.TileMultiBlockPartBase;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class TileBatteryCore
extends TileMultiBlockPartBase
implements IEnergyStorage,
CyclopsTileEntity.ITickingTile {
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private static final AxisAlignedBB NONE = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private BatteryStructure structure;
    private long energy = 0L;
    private long capacity = 0L;
    private int transfer_rate;
    public int this_tick_receive_left = this.transfer_rate = 0;
    public int this_tick_extract_left = this.transfer_rate;

    public TileBatteryCore() {
        super(RegistryEntries.TILE_BATTERY_CORE);
        this.addCapabilityInternal(CapabilityEnergy.ENERGY, LazyOptional.of(() -> this));
    }

    @Override
    public boolean isFormed() {
        return this.structure != null;
    }

    public boolean detectStructure(@Nullable PlayerEntity player) {
        BatteryStructure result = MultiBlockHelper.validateBatteryStructure(this.field_145850_b, this.field_174879_c, player);
        if (result == null) {
            return false;
        }
        this.structure = result;
        this.setCapacity(this.structure.getCapacity());
        this.transfer_rate = this.structure.getTransferRate();
        this.structure.construct(this.field_174879_c);
        this.func_70296_d();
        this.sendUpdate();
        return true;
    }

    @Override
    public void deconstructStructure() {
        if (this.structure != null) {
            this.structure.deconstruct();
            this.structure = null;
            this.core_pos = null;
            this.func_70296_d();
            this.sendUpdate();
        }
    }

    public void onStructureRightClick(BlockPos click_pos, PlayerEntity player) {
        player.func_146105_b((ITextComponent)new StringTextComponent(MathHelper.formatLong(this.energy) + "FE/" + MathHelper.formatLong(this.capacity) + "FE (" + MathHelper.formatInt(this.transfer_rate) + "FE/t)"), true);
    }

    @Override
    public TileBatteryCore getCoreTile() {
        return this;
    }

    public int[] getStructureSize() {
        if (!this.isFormed()) {
            return null;
        }
        return this.structure.getStructureSize();
    }

    public int[] getRenderOffset() {
        if (!this.isFormed()) {
            return null;
        }
        return this.structure.getRenderOffset();
    }

    public HashSet<BlockPos> getInterfaceList() {
        return this.isFormed() ? this.structure.interface_list : null;
    }

    public Set<Direction> getInterfaceRenderFaces(BlockPos pos) {
        if (!this.isFormed()) {
            return null;
        }
        HashSet<Direction> result = new HashSet<Direction>();
        if (pos.func_177958_n() == this.structure.min_pos.func_177958_n()) {
            result.add(Direction.WEST);
        }
        if (pos.func_177958_n() == this.structure.max_pos.func_177958_n()) {
            result.add(Direction.EAST);
        }
        if (pos.func_177956_o() == this.structure.min_pos.func_177956_o()) {
            result.add(Direction.DOWN);
        }
        if (pos.func_177956_o() == this.structure.max_pos.func_177956_o()) {
            result.add(Direction.UP);
        }
        if (pos.func_177952_p() == this.structure.min_pos.func_177952_p()) {
            result.add(Direction.NORTH);
        }
        if (pos.func_177952_p() == this.structure.max_pos.func_177952_p()) {
            result.add(Direction.SOUTH);
        }
        return result;
    }

    public EnumIOMode getInterfaceMode(BlockPos pos) {
        if (!this.isFormed()) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile instanceof TileBatteryInterface) {
            return ((TileBatteryInterface)tile).getMode();
        }
        return null;
    }

    public BlockPos getInterfaceOffset(BlockPos pos) {
        if (!this.isFormed()) {
            return null;
        }
        return pos.func_177973_b(new Vector3i(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isFormed()) {
            return NONE;
        }
        return this.structure.getRenderBoundingBox();
    }

    public float getEnergyPercentage() {
        if (!this.isFormed()) {
            return 0.0f;
        }
        return (float)this.getEnergy() / (float)this.getCapacity();
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_74764_b("structure")) {
            if (!tag.func_74775_l("structure").isEmpty()) {
                this.structure = BatteryStructure.fromNBT(tag.func_74775_l("structure"));
            }
        } else {
            this.structure = null;
        }
        this.energy = tag.func_74763_f("energy");
        this.capacity = tag.func_74763_f("capacity");
        this.transfer_rate = tag.func_74762_e("transfer_rate");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        if (this.structure != null) {
            tag.func_218657_a("structure", (INBT)this.structure.toNBT());
        }
        tag.func_74772_a("energy", this.energy);
        tag.func_74772_a("capacity", this.capacity);
        tag.func_74768_a("transfer_rate", this.transfer_rate);
        return tag;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
        this.func_70296_d();
        this.sendUpdate();
    }

    public long getEnergy() {
        return this.energy;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
        this.func_70296_d();
        this.sendUpdate();
    }

    public void setEnergy(int energy) {
        this.setEnergy((long)energy);
    }

    public int getTransferRate() {
        return this.transfer_rate;
    }

    public BatteryMaterial getMaterial() {
        if (this.structure == null) {
            return null;
        }
        return this.structure.material;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.isFormed()) {
            return 0;
        }
        if (this.transfer_rate == Integer.MAX_VALUE) {
            this.this_tick_receive_left = this.transfer_rate;
        }
        if (this.this_tick_receive_left <= 0) {
            return 0;
        }
        long capacity_left = this.capacity - this.energy;
        long max_transfer = Math.min(maxReceive, this.this_tick_receive_left);
        long to_transfer = Math.min(capacity_left, max_transfer);
        int int_to_transfer = MathHelper.longToInt(to_transfer);
        if (!simulate) {
            this.setEnergy(this.energy + (long)int_to_transfer);
            this.this_tick_receive_left -= int_to_transfer;
        }
        return int_to_transfer;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.isFormed()) {
            return 0;
        }
        if (this.transfer_rate == Integer.MAX_VALUE) {
            this.this_tick_extract_left = this.transfer_rate;
        }
        if (this.this_tick_extract_left <= 0) {
            return 0;
        }
        long energy_left = this.energy;
        long max_transfer = Math.min(maxExtract, this.this_tick_extract_left);
        long to_transfer = Math.min(energy_left, max_transfer);
        int int_to_transfer = MathHelper.longToInt(to_transfer);
        if (!simulate) {
            this.setEnergy(this.energy - (long)int_to_transfer);
            this.this_tick_extract_left -= int_to_transfer;
        }
        return int_to_transfer;
    }

    public int getEnergyStored() {
        return MathHelper.longToInt(this.energy);
    }

    public int getMaxEnergyStored() {
        return MathHelper.longToInt(this.capacity);
    }

    public boolean canExtract() {
        return this.isFormed();
    }

    public boolean canReceive() {
        return this.isFormed();
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        this.this_tick_receive_left = this.transfer_rate;
        this.this_tick_extract_left = this.transfer_rate;
    }

    protected int getUpdateBackoffTicks() {
        return 1;
    }
}

