/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.helper;

import com.shblock.colossalbattery.ColossalBattery;
import com.shblock.colossalbattery.GeneralConfig;
import com.shblock.colossalbattery.helper.BatteryStructure;
import com.shblock.colossalbattery.helper.CubeStructure;
import com.shblock.colossalbattery.material.BatteryMaterial;
import com.shblock.colossalbattery.material.BatteryMaterials;
import com.shblock.colossalbattery.tileentity.TileMultiBlockPartBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.TriPredicate;
import org.apache.logging.log4j.Level;

public class MultiBlockHelper {
    private static ArrayList<IFormattableTextComponent> error_list = new ArrayList();

    private static HashSet<BlockPos> findConnectedBlocks(World world, BlockPos pos, Predicate<Block> validator_connect, Predicate<Block> validator, HashSet<BlockPos> set, HashSet<BlockPos> founded_set) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (validator.test(block)) {
            founded_set.add(pos);
        }
        if (validator_connect.or(validator).test(block)) {
            set.add(pos);
            for (Direction direction : Direction.values()) {
                BlockPos offset_pos = pos.func_177972_a(direction);
                if (set.contains(offset_pos)) continue;
                founded_set = MultiBlockHelper.findConnectedBlocks(world, offset_pos, validator_connect, validator, set, founded_set);
            }
        }
        return founded_set;
    }

    public static BlockPos findBlockSingle(World world, BlockPos pos, Predicate<Block> validator_connect, Predicate<Block> validator) {
        HashSet<BlockPos> core_set = MultiBlockHelper.findConnectedBlocks(world, pos, validator_connect, validator, new HashSet<BlockPos>(), new HashSet<BlockPos>());
        return core_set.size() != 1 ? null : core_set.iterator().next();
    }

    public static HashSet<BlockPos> findBlockMultiple(World world, BlockPos pos, Predicate<Block> validator_connect, Predicate<Block> validator) {
        return MultiBlockHelper.findConnectedBlocks(world, pos, validator_connect, validator, new HashSet<BlockPos>(), new HashSet<BlockPos>());
    }

    private static HashSet<BlockPos> scanConnectedBlocks(World world, BlockPos pos, Predicate<Block> validator, HashSet<BlockPos> set) {
        if (validator.test(world.func_180495_p(pos).func_177230_c())) {
            set.add(pos);
            for (Direction direction : Direction.values()) {
                BlockPos offset_pos = pos.func_177972_a(direction);
                if (set.contains(offset_pos)) continue;
                set = MultiBlockHelper.scanConnectedBlocks(world, offset_pos, validator, set);
            }
        }
        return set;
    }

    public static HashSet<BlockPos> scanConnectedBlocks(World world, BlockPos pos, Predicate<Block> validator) {
        return MultiBlockHelper.scanConnectedBlocks(world, pos, validator, new HashSet<BlockPos>());
    }

    public static BlockPos findMinCorner(HashSet<BlockPos> set) {
        BlockPos min_pos = null;
        for (BlockPos pos : set) {
            if (min_pos == null) {
                min_pos = pos;
                continue;
            }
            if (pos.func_177958_n() > min_pos.func_177958_n() || pos.func_177956_o() > min_pos.func_177956_o() || pos.func_177952_p() > min_pos.func_177952_p()) continue;
            min_pos = pos;
        }
        return min_pos;
    }

    public static BlockPos findMaxCorner(HashSet<BlockPos> set) {
        BlockPos min_pos = null;
        for (BlockPos pos : set) {
            if (min_pos == null) {
                min_pos = pos;
                continue;
            }
            if (pos.func_177958_n() < min_pos.func_177958_n() || pos.func_177956_o() < min_pos.func_177956_o() || pos.func_177952_p() < min_pos.func_177952_p()) continue;
            min_pos = pos;
        }
        return min_pos;
    }

    public static boolean isOutline(BlockPos min_pos, BlockPos max_pos, BlockPos pos) {
        return pos.func_177958_n() == min_pos.func_177958_n() || pos.func_177958_n() == max_pos.func_177958_n() || pos.func_177956_o() == min_pos.func_177956_o() || pos.func_177956_o() == max_pos.func_177956_o() || pos.func_177952_p() == min_pos.func_177952_p() || pos.func_177952_p() == max_pos.func_177952_p();
    }

    public static boolean isFrame(BlockPos min_pos, BlockPos max_pos, BlockPos pos) {
        int count = 0;
        if (pos.func_177958_n() == min_pos.func_177958_n() || pos.func_177958_n() == max_pos.func_177958_n()) {
            ++count;
        }
        if (pos.func_177956_o() == min_pos.func_177956_o() || pos.func_177956_o() == max_pos.func_177956_o()) {
            ++count;
        }
        if (pos.func_177952_p() == min_pos.func_177952_p() || pos.func_177952_p() == max_pos.func_177952_p()) {
            ++count;
        }
        return count >= 2;
    }

    public static int getMinSize(BlockPos min_pos, BlockPos max_pos) {
        int xl = max_pos.func_177958_n() - min_pos.func_177958_n();
        int yl = max_pos.func_177956_o() - min_pos.func_177956_o();
        int zl = max_pos.func_177952_p() - min_pos.func_177952_p();
        return Math.min(xl, Math.min(yl, zl));
    }

    public static int getMaxSize(BlockPos min_pos, BlockPos max_pos) {
        int xl = max_pos.func_177958_n() - min_pos.func_177958_n();
        int yl = max_pos.func_177956_o() - min_pos.func_177956_o();
        int zl = max_pos.func_177952_p() - min_pos.func_177952_p();
        return Math.max(xl, Math.max(yl, zl));
    }

    public static CubeStructure validateBoxStructureWithCore(World world, BlockPos pos, Predicate<Block> validator_frame, Predicate<Block> validator_outline, Predicate<Block> validator_inner, Predicate<Block> validator_must_single, TriPredicate<CubeStructure, BlockPos, Block> block_checker, TranslationTextComponent material_name) {
        BlockPos max_pos;
        HashSet<BlockPos> frame_set;
        try {
            frame_set = MultiBlockHelper.scanConnectedBlocks(world, pos, validator_frame);
        }
        catch (StackOverflowError ignored) {
            error_list.add(new TranslationTextComponent("message.colossal_battery.error.too_much_block").func_230529_a_((ITextComponent)material_name));
            ColossalBattery.clog(Level.WARN, "A structure have too much connected blocks caused StackOverflowError, the structure can't be validated, world: " + world + " , starting pos: " + pos);
            return null;
        }
        if (frame_set.isEmpty()) {
            error_list.add(new TranslationTextComponent("message.colossal_battery.error.no_structure").func_230529_a_((ITextComponent)material_name));
            return null;
        }
        BlockPos min_pos = MultiBlockHelper.findMinCorner(frame_set);
        if (MultiBlockHelper.getMinSize(min_pos, max_pos = MultiBlockHelper.findMaxCorner(frame_set)) < 2) {
            error_list.add(new TranslationTextComponent("message.colossal_battery.error.too_small").func_230529_a_((ITextComponent)material_name));
            return null;
        }
        if (MultiBlockHelper.getMaxSize(min_pos, max_pos) > GeneralConfig.max_size) {
            error_list.add(new TranslationTextComponent("message.colossal_battery.error.too_big", new Object[]{MultiBlockHelper.getMaxSize(min_pos, max_pos), GeneralConfig.max_size}).func_230529_a_((ITextComponent)material_name));
            return null;
        }
        int must_single_block_count = 0;
        for (int x = min_pos.func_177958_n(); x <= max_pos.func_177958_n(); ++x) {
            for (int y = min_pos.func_177956_o(); y <= max_pos.func_177956_o(); ++y) {
                for (int z = min_pos.func_177952_p(); z <= max_pos.func_177952_p(); ++z) {
                    BlockPos check_pos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(check_pos).func_177230_c();
                    if (!block_checker.test((Object)new CubeStructure(world, min_pos, max_pos), (Object)check_pos, (Object)block)) {
                        error_list.add(new TranslationTextComponent("message.colossal_battery.error.block_not_allowed_here", new Object[]{check_pos.toString()}).func_230529_a_((ITextComponent)material_name));
                        return null;
                    }
                    if (MultiBlockHelper.isFrame(min_pos, max_pos, check_pos)) {
                        if (!validator_frame.test(block)) {
                            error_list.add(new TranslationTextComponent("message.colossal_battery.error.frame_block_invalid", new Object[]{check_pos.toString()}).func_230529_a_((ITextComponent)material_name));
                            return null;
                        }
                    } else if (MultiBlockHelper.isOutline(min_pos, max_pos, check_pos)) {
                        if (!validator_outline.test(block)) {
                            error_list.add(new TranslationTextComponent("message.colossal_battery.error.outline_block_invalid", new Object[]{check_pos.toString()}).func_230529_a_((ITextComponent)material_name));
                            return null;
                        }
                    } else if (!validator_inner.test(block)) {
                        error_list.add(new TranslationTextComponent("message.colossal_battery.error.inner_block_invalid", new Object[]{check_pos.toString()}).func_230529_a_((ITextComponent)material_name));
                        return null;
                    }
                    if (!validator_must_single.test(block)) continue;
                    if (must_single_block_count >= 1) {
                        error_list.add(new TranslationTextComponent("message.colossal_battery.error.multiple_core_block", new Object[]{check_pos.toString()}).func_230529_a_((ITextComponent)material_name));
                        return null;
                    }
                    ++must_single_block_count;
                }
            }
        }
        return new CubeStructure(world, min_pos, max_pos);
    }

    public static void sendAllErrorMessage(PlayerEntity player) {
        for (IFormattableTextComponent textComponent : error_list) {
            player.func_146105_b((ITextComponent)textComponent, false);
        }
    }

    public static boolean isClingWithAnotherStructure(BlockPos min_pos, BlockPos max_pos, World world, TranslationTextComponent material_name) {
        for (int x = min_pos.func_177958_n(); x <= max_pos.func_177958_n(); ++x) {
            for (int y = min_pos.func_177956_o(); y <= max_pos.func_177956_o(); ++y) {
                for (int z = min_pos.func_177952_p(); z <= max_pos.func_177952_p(); ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (blockPos.func_177958_n() == min_pos.func_177958_n() && world.func_175625_s(blockPos.func_177976_e()) instanceof TileMultiBlockPartBase) {
                        error_list.add(new TranslationTextComponent("message.colossal_battery.error.close_to_another_structure", new Object[]{blockPos.func_177976_e()}).func_230529_a_((ITextComponent)material_name));
                        return true;
                    }
                    if (blockPos.func_177958_n() == max_pos.func_177958_n() && world.func_175625_s(blockPos.func_177974_f()) instanceof TileMultiBlockPartBase) {
                        error_list.add(new TranslationTextComponent("message.colossal_battery.error.close_to_another_structure", new Object[]{blockPos.func_177974_f()}).func_230529_a_((ITextComponent)material_name));
                        return true;
                    }
                    if (blockPos.func_177956_o() == min_pos.func_177956_o() && world.func_175625_s(blockPos.func_177977_b()) instanceof TileMultiBlockPartBase) {
                        error_list.add(new TranslationTextComponent("message.colossal_battery.error.close_to_another_structure", new Object[]{blockPos.func_177977_b()}).func_230529_a_((ITextComponent)material_name));
                        return true;
                    }
                    if (blockPos.func_177956_o() == max_pos.func_177956_o() && world.func_175625_s(blockPos.func_177984_a()) instanceof TileMultiBlockPartBase) {
                        error_list.add(new TranslationTextComponent("message.colossal_battery.error.close_to_another_structure", new Object[]{blockPos.func_177984_a()}).func_230529_a_((ITextComponent)material_name));
                        return true;
                    }
                    if (blockPos.func_177952_p() == min_pos.func_177952_p() && world.func_175625_s(blockPos.func_177978_c()) instanceof TileMultiBlockPartBase) {
                        error_list.add(new TranslationTextComponent("message.colossal_battery.error.close_to_another_structure", new Object[]{blockPos.func_177978_c()}).func_230529_a_((ITextComponent)material_name));
                        return true;
                    }
                    if (blockPos.func_177952_p() != max_pos.func_177952_p() || !(world.func_175625_s(blockPos.func_177968_d()) instanceof TileMultiBlockPartBase)) continue;
                    error_list.add(new TranslationTextComponent("message.colossal_battery.error.close_to_another_structure", new Object[]{blockPos.func_177968_d()}).func_230529_a_((ITextComponent)material_name));
                    return true;
                }
            }
        }
        return false;
    }

    public static BatteryStructure validateBatteryStructure(World world, BlockPos pos, @Nullable PlayerEntity player) {
        error_list.clear();
        for (BatteryMaterial material : BatteryMaterials.VALUES) {
            TranslationTextComponent material_name = new TranslationTextComponent("material." + material.name);
            CubeStructure result = MultiBlockHelper.validateBoxStructureWithCore(world, pos, material.frame_validator.or(material.core_validator).or(material.interface_validator), material.outline_validator.or(material.core_validator).or(material.interface_validator), material.inner_validator, material.core_validator, material.block_checker, material_name);
            if (result == null) continue;
            if (MultiBlockHelper.isClingWithAnotherStructure(result.min_pos, result.max_pos, world, material_name)) {
                MultiBlockHelper.sendAllErrorMessage(player);
                return null;
            }
            BatteryStructure batteryStructure = new BatteryStructure(result, material);
            batteryStructure.interface_list = MultiBlockHelper.findBlockMultiple(world, pos, material.frame_validator.or(material.core_validator), material.interface_validator);
            return batteryStructure;
        }
        MultiBlockHelper.sendAllErrorMessage(player);
        return null;
    }
}

