/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.helper;

import java.text.DecimalFormat;

public class MathHelper {
    private static final String[] NUMBER_CHARS = new String[]{"K", "M", "G", "T", "P", "E"};
    private static final DecimalFormat energyValue = new DecimalFormat("###,###,###,###,###.###");

    public static int longToInt(long num) {
        try {
            return Math.toIntExact(num);
        }
        catch (ArithmeticException ignored) {
            return num > 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
    }

    public static String formatLong(long value) {
        if (value <= 1000L) {
            return energyValue.format(value);
        }
        int cnt = 0;
        double num = (double)value / 1000.0;
        while (num >= 1000.0) {
            num /= 1000.0;
            ++cnt;
        }
        return energyValue.format(num) + NUMBER_CHARS[cnt];
    }

    public static String formatInt(int value) {
        return MathHelper.formatLong(value);
    }
}

