/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.helper;

import com.shblock.colossalbattery.block.BlockMultiBlockDummy;
import com.shblock.colossalbattery.helper.NBTHelper;
import com.shblock.colossalbattery.tileentity.TileMultiBlockDummy;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CubeStructure {
    public final World world;
    public final BlockPos min_pos;
    public final BlockPos max_pos;

    public CubeStructure(World world, BlockPos min_pos, BlockPos max_pos) {
        this.world = world;
        this.min_pos = min_pos;
        this.max_pos = max_pos;
    }

    public int[] getSize() {
        return new int[]{this.max_pos.func_177958_n() - this.min_pos.func_177958_n() + 1, this.max_pos.func_177956_o() - this.min_pos.func_177956_o() + 1, this.max_pos.func_177952_p() - this.min_pos.func_177952_p() + 1};
    }

    public int getBlockCount() {
        int[] size = this.getSize();
        return size[0] * size[1] * size[2];
    }

    public int getValidBlockCount(Predicate<Block> validator) {
        int counter = 0;
        for (int x = this.min_pos.func_177958_n(); x <= this.max_pos.func_177958_n(); ++x) {
            for (int y = this.min_pos.func_177956_o(); y <= this.max_pos.func_177956_o(); ++y) {
                for (int z = this.min_pos.func_177952_p(); z <= this.max_pos.func_177952_p(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = this.world.func_180495_p(pos).func_177230_c();
                    if (block instanceof BlockMultiBlockDummy) {
                        BlockState blockStateIn;
                        TileMultiBlockDummy tile = (TileMultiBlockDummy)this.world.func_175625_s(pos);
                        if (tile == null || (blockStateIn = tile.getBlockStateIn()) == null || !validator.test(blockStateIn.func_177230_c())) continue;
                        ++counter;
                        continue;
                    }
                    if (!validator.test(block)) continue;
                    ++counter;
                }
            }
        }
        return counter;
    }

    public void forEach(Consumer<BlockPos> consumer) {
        for (int x = this.min_pos.func_177958_n(); x <= this.max_pos.func_177958_n(); ++x) {
            for (int y = this.min_pos.func_177956_o(); y <= this.max_pos.func_177956_o(); ++y) {
                for (int z = this.min_pos.func_177952_p(); z <= this.max_pos.func_177952_p(); ++z) {
                    consumer.accept(new BlockPos(x, y, z));
                }
            }
        }
    }

    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("dim", (INBT)NBTHelper.writeWorld(this.world));
        tag.func_218657_a("min_pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.min_pos));
        tag.func_218657_a("max_pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.max_pos));
        return tag;
    }

    public static CubeStructure fromNBT(CompoundNBT tag) {
        return new CubeStructure(NBTHelper.readWorld(tag.func_74779_i("dim")), NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("min_pos")), NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("max_pos")));
    }
}

