/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.helper;

import com.shblock.colossalbattery.helper.CubeStructure;
import com.shblock.colossalbattery.material.BatteryMaterial;
import com.shblock.colossalbattery.material.BatteryMaterials;
import com.shblock.colossalbattery.tileentity.TileMultiBlockDummy;
import com.shblock.colossalbattery.tileentity.TileMultiBlockPartBase;
import java.util.HashSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class BatteryStructure
extends CubeStructure {
    public final BatteryMaterial material;
    private int material_block_count = 0;
    private BlockPos core_pos;
    private int[] structure_size_cache;
    private int[] render_offset_cache;
    private AxisAlignedBB render_bounding_box_cache;
    public HashSet<BlockPos> interface_list = new HashSet();

    public BatteryStructure(CubeStructure cubeStructure, BatteryMaterial material) {
        super(cubeStructure.world, cubeStructure.min_pos, cubeStructure.max_pos);
        this.material = material;
    }

    public int getMaterialBlockCount() {
        if (this.material_block_count == 0) {
            this.material_block_count = this.getValidBlockCount(this.material.frame_validator.or(this.material.outline_validator).or(this.material.inner_validator));
        }
        return this.material_block_count;
    }

    public BlockPos getCorePos() {
        return this.core_pos;
    }

    public long getCapacity() {
        return this.material.calculateCapacity(this.getMaterialBlockCount());
    }

    public int getTransferRate() {
        return this.material.calculateTransferRate(this.getMaterialBlockCount());
    }

    public void initCache() {
        this.structure_size_cache = this.getSize();
        this.render_offset_cache = new int[]{this.min_pos.func_177958_n() - this.core_pos.func_177958_n(), this.min_pos.func_177956_o() - this.core_pos.func_177956_o(), this.min_pos.func_177952_p() - this.core_pos.func_177952_p()};
        this.render_bounding_box_cache = new AxisAlignedBB(this.min_pos.func_177973_b(new Vector3i(1, 1, 1)), this.max_pos.func_177971_a(new Vector3i(1, 1, 1)));
    }

    public void construct(BlockPos core_pos) {
        this.core_pos = core_pos;
        this.initCache();
        this.forEach(blockPos -> {
            TileEntity tile = this.world.func_175625_s(blockPos);
            if (!(tile instanceof TileMultiBlockPartBase)) {
                TileMultiBlockDummy.construct(this.world, blockPos, core_pos);
            } else {
                ((TileMultiBlockPartBase)tile).core_pos = core_pos;
            }
            ((TileMultiBlockPartBase)this.world.func_175625_s(blockPos)).onConstruct();
        });
    }

    public void deconstruct() {
        this.world.func_217381_Z().func_76320_a("dc");
        this.forEach(blockPos -> {
            TileEntity te = this.world.func_175625_s(blockPos);
            if (te instanceof TileMultiBlockDummy) {
                this.world.func_217381_Z().func_76320_a("dc_dd");
                ((TileMultiBlockDummy)te).deconstruct();
                this.world.func_217381_Z().func_76319_b();
            } else if (te instanceof TileMultiBlockPartBase) {
                ((TileMultiBlockPartBase)te).onDeconstruct();
            }
        });
        this.world.func_217381_Z().func_76319_b();
    }

    public int[] getStructureSize() {
        return this.structure_size_cache;
    }

    public int[] getRenderOffset() {
        return this.render_offset_cache;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.render_bounding_box_cache;
    }

    @Override
    public CompoundNBT toNBT() {
        CompoundNBT tag = super.toNBT();
        tag.func_74778_a("type", this.material.name);
        tag.func_74768_a("material_block_count", this.material_block_count);
        tag.func_218657_a("core_pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.core_pos));
        ListNBT list = new ListNBT();
        for (BlockPos pos : this.interface_list) {
            list.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
        }
        tag.func_218657_a("interface_list", (INBT)list);
        return tag;
    }

    public static BatteryStructure fromNBT(CompoundNBT tag) {
        BatteryStructure structure = new BatteryStructure(CubeStructure.fromNBT(tag), BatteryMaterials.fromName(tag.func_74779_i("type")));
        structure.material_block_count = tag.func_74762_e("material_block_count");
        structure.core_pos = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("core_pos"));
        structure.initCache();
        structure.interface_list.clear();
        ListNBT list = tag.func_150295_c("interface_list", 10);
        for (INBT nbt : list) {
            structure.interface_list.add(NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)nbt)));
        }
        return structure;
    }
}

