/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.shblock.colossalbattery.client.render.battery.RenderBatteryBase;
import com.shblock.colossalbattery.material.BatteryMaterialRenders;
import com.shblock.colossalbattery.tileentity.EnumIOMode;
import com.shblock.colossalbattery.tileentity.TileBatteryCore;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderTileBatteryCore
extends TileEntityRenderer<TileBatteryCore> {
    public RenderTileBatteryCore(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileBatteryCore tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntity.isFormed()) {
            RenderBatteryBase battery_render = BatteryMaterialRenders.getRender(tileEntity.getMaterial());
            if (battery_render == null) {
                return;
            }
            matrixStack.func_227860_a_();
            int[] render_offset = tileEntity.getRenderOffset();
            matrixStack.func_227861_a_((double)render_offset[0], (double)render_offset[1], (double)render_offset[2]);
            int[] size = tileEntity.getStructureSize();
            matrixStack.func_227862_a_((float)size[0], (float)size[1], (float)size[2]);
            battery_render.render(tileEntity, partialTicks, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
            matrixStack.func_227865_b_();
            battery_render.renderCore(tileEntity.getInterfaceRenderFaces(tileEntity.func_174877_v()), partialTicks, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
            for (BlockPos pos : tileEntity.getInterfaceList()) {
                matrixStack.func_227860_a_();
                BlockPos offset = tileEntity.getInterfaceOffset(pos);
                matrixStack.func_227861_a_((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
                EnumIOMode mode = tileEntity.getInterfaceMode(pos);
                if (mode == null) {
                    mode = EnumIOMode.NORMAL;
                }
                battery_render.renderInterface(tileEntity.getInterfaceRenderFaces(pos), mode, partialTicks, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
                matrixStack.func_227865_b_();
            }
        }
    }

    public boolean isGlobalRenderer(TileBatteryCore te) {
        return true;
    }
}

