/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.client.render.battery;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.shblock.colossalbattery.GeneralConfig;
import com.shblock.colossalbattery.client.render.battery.MekRender;
import com.shblock.colossalbattery.client.render.battery.RenderBatteryBase;
import com.shblock.colossalbattery.material.BatteryMaterials;
import com.shblock.colossalbattery.tileentity.EnumIOMode;
import com.shblock.colossalbattery.tileentity.TileBatteryCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mekanism.client.MekanismClient;
import mekanism.client.model.ModelEnergyCube;
import mekanism.common.tier.EnergyCubeTier;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.gen.PerlinNoiseGenerator;

public class RenderBatteryMek
extends RenderBatteryBase {
    public static final RenderBatteryMek _instance = new RenderBatteryMek();
    public static final ModelEnergyCube ENERGY_CUBE_RENDER = new ModelEnergyCube();
    public static final ModelEnergyCube.ModelEnergyCore CORE_RENDER = new ModelEnergyCube.ModelEnergyCore();
    public static final MekRender MEK_RENDER = new MekRender();
    public static final List<PerlinNoiseGenerator> NOISE_LIST = new ArrayList<PerlinNoiseGenerator>();

    private EnergyCubeTier getCubeTier(TileBatteryCore tile) {
        if (tile.getMaterial() == BatteryMaterials.MEK_BASIC) {
            return EnergyCubeTier.BASIC;
        }
        if (tile.getMaterial() == BatteryMaterials.MEK_ADVANCED) {
            return EnergyCubeTier.ADVANCED;
        }
        if (tile.getMaterial() == BatteryMaterials.MEK_ELITE) {
            return EnergyCubeTier.ELITE;
        }
        if (tile.getMaterial() == BatteryMaterials.MEK_ULTIMATE) {
            return EnergyCubeTier.ULTIMATE;
        }
        return null;
    }

    @Override
    public void render(TileBatteryCore tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, -0.5, 0.5);
        ENERGY_CUBE_RENDER.render(matrixStack, buffer, combinedLight, combinedOverlay, this.getCubeTier(tileEntity), true, false);
        matrixStack.func_227865_b_();
        if (tileEntity.getEnergy() != 0L) {
            for (int i = 0; i < GeneralConfig.mek_core_render_count; ++i) {
                matrixStack.func_227860_a_();
                float energy_percentage = tileEntity.getEnergyPercentage();
                matrixStack.func_227861_a_((double)(-energy_percentage / 2.0f), (double)(-energy_percentage / 2.0f), (double)(-energy_percentage / 2.0f));
                matrixStack.func_227861_a_(0.5, 0.5, 0.5);
                matrixStack.func_227862_a_(energy_percentage, energy_percentage, energy_percentage);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.5, 0.5, 0.5);
                matrixStack.func_227862_a_(0.4f, 0.4f, 0.4f);
                this.rotateByNoise(matrixStack, NOISE_LIST.subList(i * 3, i * 3 + 3), partialTicks);
                CORE_RENDER.render(matrixStack, buffer, combinedLight, combinedOverlay, this.getCubeTier(tileEntity).getBaseTier().getColor(), 1.0f);
                matrixStack.func_227865_b_();
                matrixStack.func_227865_b_();
            }
        }
    }

    private void rotateByNoise(MatrixStack matrixStack, List<PerlinNoiseGenerator> noise_list, float partialTicks) {
        float tick = (float)MekanismClient.ticksPassed + partialTicks;
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)(noise_list.get(0).func_215464_a((double)tick / 100.0, 0.0, false) * 3.0)));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(noise_list.get(1).func_215464_a((double)tick / 100.0, 0.0, false) * 3.0)));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_((float)(noise_list.get(2).func_215464_a((double)tick / 100.0, 0.0, false) * 3.0)));
    }

    @Override
    public void renderCore(Set<Direction> sides, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        this.renderInterface(sides, EnumIOMode.NORMAL, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    @Override
    public void renderInterface(Set<Direction> sides, EnumIOMode mode, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, -0.5, 0.5);
        float[] port_color = null;
        switch (mode) {
            case NORMAL: {
                port_color = new float[]{0.3f, 0.3f, 0.3f};
                break;
            }
            case INPUT: {
                port_color = new float[]{0.0f, 0.658f, 0.952f};
                break;
            }
            case OUTPUT: {
                port_color = new float[]{1.0f, 0.5f, 0.15f};
            }
        }
        MEK_RENDER.renderSidesBatched(matrixStack, buffer, combinedLight, combinedOverlay, sides, port_color);
        matrixStack.func_227865_b_();
    }

    static {
        Random random = new Random();
        for (int i = 0; i < GeneralConfig.mek_core_render_count * 3; ++i) {
            NOISE_LIST.add(new PerlinNoiseGenerator(new SharedSeedRandom(random.nextLong()), (List)ImmutableList.of((Object)0)));
        }
    }
}

