/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.client.render.battery;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.shblock.colossalbattery.client.render.battery.RenderBatteryBase;
import com.shblock.colossalbattery.material.BatteryMaterial;
import com.shblock.colossalbattery.material.BatteryMaterials;
import com.shblock.colossalbattery.tileentity.EnumIOMode;
import com.shblock.colossalbattery.tileentity.TileBatteryCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderBattery6Face
extends RenderBatteryBase {
    public static final RenderBattery6Face _instance = new RenderBattery6Face();
    private static final float OFFSET = 0.001f;
    private static final float MINY = 0.0f;
    private static final float MAXY = 1.0f;
    private static final float MIN = -0.001f;
    private static final float MAX = 1.001f;
    private static final float[][][] coordinates = new float[][][]{new float[][]{{-0.001f, 0.0f, -0.001f}, {-0.001f, 0.0f, 1.001f}, {1.001f, 0.0f, 1.001f}, {1.001f, 0.0f, -0.001f}}, new float[][]{{-0.001f, 1.0f, -0.001f}, {-0.001f, 1.0f, 1.001f}, {1.001f, 1.0f, 1.001f}, {1.001f, 1.0f, -0.001f}}, new float[][]{{-0.001f, 0.0f, -0.001f}, {-0.001f, 1.0f, -0.001f}, {1.001f, 1.0f, -0.001f}, {1.001f, 0.0f, -0.001f}}, new float[][]{{1.001f, 0.0f, 1.001f}, {1.001f, 1.0f, 1.001f}, {-0.001f, 1.0f, 1.001f}, {-0.001f, 0.0f, 1.001f}}, new float[][]{{-0.001f, 0.0f, 1.001f}, {-0.001f, 1.0f, 1.001f}, {-0.001f, 1.0f, -0.001f}, {-0.001f, 0.0f, -0.001f}}, new float[][]{{1.001f, 0.0f, -0.001f}, {1.001f, 1.0f, -0.001f}, {1.001f, 1.0f, 1.001f}, {1.001f, 0.0f, 1.001f}}};
    private static final HashMap<BatteryMaterial, ResourceLocation> TEXTURES_BATTERY = new HashMap();
    private static final HashMap<BatteryMaterial, ResourceLocation> ICONS_BATTERY = new HashMap();
    private static final ResourceLocation NODES_TEXTURE = new ResourceLocation("colossal_battery", "block/interface_nodes");
    private static final HashMap<Direction, Quaternion> ROTATION_MAP = new HashMap();
    private final ModelRenderer main_model = new ModelRenderer(64, 64, 0, 0);
    private final ModelRenderer[] node_renders;

    public RenderBattery6Face() {
        this.main_model.func_228300_a_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
        ArrayList<ModelRenderer> renders = new ArrayList<ModelRenderer>();
        for (int i = 0; i < 4; ++i) {
            ModelRenderer model = new ModelRenderer(32, 32, 0, i * 8);
            model.func_228300_a_(-2.0f, 8.0f, -2.0f, 4.0f, 1.0f, 4.0f);
            renders.add(model);
        }
        this.node_renders = renders.toArray(new ModelRenderer[4]);
    }

    public static void onPreTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            for (ResourceLocation value : TEXTURES_BATTERY.values()) {
                event.addSprite(value);
            }
            event.addSprite(NODES_TEXTURE);
        }
    }

    @Override
    public void render(TileBatteryCore tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        RenderMaterial material = new RenderMaterial(Atlases.field_228747_f_, TEXTURES_BATTERY.get(tileEntity.getMaterial()));
        IVertexBuilder vertexBuilder = material.func_229311_a_(buffer, RenderType::func_228638_b_);
        this.main_model.func_228308_a_(matrixStack, vertexBuilder, LightTexture.func_228451_a_((int)15, (int)15), OverlayTexture.field_229196_a_);
        this.renderEnergyBar(tileEntity, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        matrixStack.func_227865_b_();
    }

    private void renderEnergyBar(TileBatteryCore tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (tile.getEnergy() > 0L) {
            float height = tile.getEnergyPercentage();
            height = height * 12.0f / 16.0f + 0.125f;
            for (Direction side : Direction.Plane.HORIZONTAL) {
                ResourceLocation icon = ICONS_BATTERY.get(tile.getMaterial());
                float[][] c = coordinates[side.ordinal()];
                float minU = (float)side.func_176736_b() * 0.25f;
                float maxU = minU + 0.25f;
                float minV = 0.75f + 0.25f * (1.0f - height);
                float maxV = 1.0f;
                IVertexBuilder vb = buffer.getBuffer(RenderType.func_228658_l_((ResourceLocation)icon));
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                vb.func_227888_a_(matrix, c[0][0], c[0][1] * height, c[0][2]).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(LightTexture.func_228451_a_((int)15, (int)15)).func_181675_d();
                vb.func_227888_a_(matrix, c[1][0], c[1][1] * height, c[1][2]).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(LightTexture.func_228451_a_((int)15, (int)15)).func_181675_d();
                vb.func_227888_a_(matrix, c[2][0], c[2][1] * height, c[2][2]).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(LightTexture.func_228451_a_((int)15, (int)15)).func_181675_d();
                vb.func_227888_a_(matrix, c[3][0], c[3][1] * height, c[3][2]).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(LightTexture.func_228451_a_((int)15, (int)15)).func_181675_d();
            }
        }
    }

    @Override
    public void renderCore(Set<Direction> sides, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        RenderMaterial material = new RenderMaterial(Atlases.field_228747_f_, NODES_TEXTURE);
        IVertexBuilder vertexBuilder = material.func_229311_a_(buffer, RenderType::func_228638_b_);
        for (Direction facing : sides) {
            this.renderNode(facing, this.node_renders[3], partialTicks, matrixStack, buffer, vertexBuilder, combinedLight, combinedOverlay);
        }
    }

    @Override
    public void renderInterface(Set<Direction> sides, EnumIOMode mode, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        RenderMaterial material = new RenderMaterial(Atlases.field_228747_f_, NODES_TEXTURE);
        IVertexBuilder vertexBuilder = material.func_229311_a_(buffer, RenderType::func_228638_b_);
        for (Direction facing : sides) {
            this.renderNode(facing, this.node_renders[mode.getId()], partialTicks, matrixStack, buffer, vertexBuilder, combinedLight, combinedOverlay);
        }
    }

    private void renderNode(Direction facing, ModelRenderer model, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, IVertexBuilder vertexBuilder, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        this.rotateToNodeFacing(matrixStack, facing);
        model.func_228308_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        matrixStack.func_227865_b_();
    }

    private MatrixStack rotateToNodeFacing(MatrixStack matrixStack, Direction facing) {
        matrixStack.func_227863_a_(ROTATION_MAP.get(facing));
        return matrixStack;
    }

    static {
        String start = "models/battery/";
        String end = "";
        TEXTURES_BATTERY.put(BatteryMaterials.COBBLESTONE, new ResourceLocation("colossal_battery", start + "cobblestone" + end));
        TEXTURES_BATTERY.put(BatteryMaterials.COPPER, new ResourceLocation("colossal_battery", start + "copper" + end));
        TEXTURES_BATTERY.put(BatteryMaterials.IRON, new ResourceLocation("colossal_battery", start + "iron" + end));
        TEXTURES_BATTERY.put(BatteryMaterials.SILVER, new ResourceLocation("colossal_battery", start + "silver" + end));
        TEXTURES_BATTERY.put(BatteryMaterials.GOLD, new ResourceLocation("colossal_battery", start + "gold" + end));
        TEXTURES_BATTERY.put(BatteryMaterials.DIAMOND, new ResourceLocation("colossal_battery", start + "diamond" + end));
        TEXTURES_BATTERY.put(BatteryMaterials.OBSIDIAN, new ResourceLocation("colossal_battery", start + "obsidian" + end));
        TEXTURES_BATTERY.put(BatteryMaterials.MENRIL, new ResourceLocation("colossal_battery", start + "menril" + end));
        TEXTURES_BATTERY.put(BatteryMaterials.ULTIMATE, new ResourceLocation("colossal_battery", start + "ultimate" + end));
        start = "textures/models/battery/";
        end = ".png";
        ICONS_BATTERY.put(BatteryMaterials.COBBLESTONE, new ResourceLocation("colossal_battery", start + "cobblestone" + end));
        ICONS_BATTERY.put(BatteryMaterials.COPPER, new ResourceLocation("colossal_battery", start + "copper" + end));
        ICONS_BATTERY.put(BatteryMaterials.IRON, new ResourceLocation("colossal_battery", start + "iron" + end));
        ICONS_BATTERY.put(BatteryMaterials.SILVER, new ResourceLocation("colossal_battery", start + "silver" + end));
        ICONS_BATTERY.put(BatteryMaterials.GOLD, new ResourceLocation("colossal_battery", start + "gold" + end));
        ICONS_BATTERY.put(BatteryMaterials.DIAMOND, new ResourceLocation("colossal_battery", start + "diamond" + end));
        ICONS_BATTERY.put(BatteryMaterials.OBSIDIAN, new ResourceLocation("colossal_battery", start + "obsidian" + end));
        ICONS_BATTERY.put(BatteryMaterials.MENRIL, new ResourceLocation("colossal_battery", start + "menril" + end));
        ICONS_BATTERY.put(BatteryMaterials.ULTIMATE, new ResourceLocation("colossal_battery", start + "ultimate" + end));
        ROTATION_MAP.put(Direction.DOWN, new Quaternion(180.0f, 0.0f, 0.0f, true));
        ROTATION_MAP.put(Direction.UP, new Quaternion(0.0f, 0.0f, 0.0f, true));
        ROTATION_MAP.put(Direction.NORTH, new Quaternion(-90.0f, 0.0f, 0.0f, true));
        ROTATION_MAP.put(Direction.SOUTH, new Quaternion(90.0f, 0.0f, 0.0f, true));
        ROTATION_MAP.put(Direction.WEST, new Quaternion(0.0f, 0.0f, 90.0f, true));
        ROTATION_MAP.put(Direction.EAST, new Quaternion(0.0f, 0.0f, -90.0f, true));
    }
}

