/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.colossalbattery.block;

import com.shblock.colossalbattery.tileentity.TileBatteryCore;
import com.shblock.colossalbattery.tileentity.TileMultiBlockPartBase;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class BlockMultiBlockPartBase
extends BlockTile {
    public static final BooleanProperty FORMED = BooleanProperty.func_177716_a((String)"formed");

    public BlockMultiBlockPartBase(AbstractBlock.Properties properties, Supplier<CyclopsTileEntity> tileEntitySupplier) {
        super(properties, tileEntitySupplier);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FORMED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FORMED});
        super.func_206840_a(builder);
    }

    public void setFormed(World world, BlockPos pos, boolean formed) {
        BlockState bs = world.func_180495_p(pos);
        if ((Boolean)bs.func_177229_b((Property)FORMED) != formed) {
            world.func_175656_a(pos, (BlockState)bs.func_206870_a((Property)FORMED, (Comparable)Boolean.valueOf(formed)));
            world.func_195593_d(pos, this.getBlock());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileMultiBlockPartBase tile;
        if (!world.func_201670_d() && !player.func_225608_bj_() && player.func_184586_b(hand).func_190926_b() && (tile = (TileMultiBlockPartBase)world.func_175625_s(pos)) != null) {
            if (tile instanceof TileBatteryCore) {
                ((TileBatteryCore)tile).onStructureRightClick(pos, player);
                return ActionResultType.SUCCESS;
            }
            if (tile.isFormed()) {
                TileEntity core_tile = world.func_175625_s(tile.core_pos);
                if (core_tile instanceof TileBatteryCore) {
                    ((TileBatteryCore)core_tile).onStructureRightClick(pos, player);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void onDestroy(IWorld world, BlockPos pos) {
        TileMultiBlockPartBase tile;
        if (!world.func_201670_d() && (tile = (TileMultiBlockPartBase)world.func_175625_s(pos)) != null) {
            tile.deconstructStructure();
        }
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        this.onDestroy(world, pos);
        super.func_176206_d(world, pos, state);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosionIn) {
        this.onDestroy((IWorld)world, pos);
        super.func_180652_a(world, pos, explosionIn);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        this.onDestroy((IWorld)world, pos);
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState blockState, PlayerEntity player) {
        this.onDestroy((IWorld)world, pos);
        super.func_176208_a(world, pos, blockState, player);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return (Boolean)state.func_177229_b((Property)FORMED) != false ? BlockRenderType.INVISIBLE : super.func_149645_b(state);
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        TileBatteryCore core_tile;
        TileMultiBlockPartBase tile;
        if (((Boolean)state.func_177229_b((Property)FORMED)).booleanValue() && (tile = (TileMultiBlockPartBase)world.func_175625_s(pos)) != null && (core_tile = tile.getCoreTile()) != null) {
            return core_tile.getMaterial().isExplosionResistance() ? Float.MAX_VALUE : 0.0f;
        }
        return 0.0f;
    }
}

