/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.check.RegisterMod;
import com.natamus.collective_common_fabric.config.CollectiveConfigHandler;
import com.natamus.collective_common_fabric.data.GlobalVariables;
import com.natamus.collective_common_fabric.features.PlayerHeadCacheFeature;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.collective_common_fabric.functions.SpawnEntityFunctions;
import com.natamus.collective_common_fabric.objects.SAMObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.server.MinecraftServer;

public class CollectiveEvents {
    public static WeakHashMap<class_3218, List<class_1297>> entitiesToSpawn = new WeakHashMap();
    public static WeakHashMap<class_3218, WeakHashMap<class_1297, class_1297>> entitiesToRide = new WeakHashMap();
    public static CopyOnWriteArrayList<Pair<Integer, Runnable>> scheduledRunnables = new CopyOnWriteArrayList();

    public static void onWorldTick(class_3218 serverLevel) {
        if (entitiesToSpawn.computeIfAbsent(serverLevel, k -> new ArrayList()).size() > 0) {
            class_1297 tospawn = entitiesToSpawn.get(serverLevel).get(0);
            serverLevel.method_30771(tospawn);
            if (entitiesToRide.computeIfAbsent(serverLevel, k -> new WeakHashMap()).containsKey(tospawn)) {
                class_1297 rider = entitiesToRide.get(serverLevel).get(tospawn);
                rider.method_5804(tospawn);
                entitiesToRide.get(serverLevel).remove(tospawn);
            }
            entitiesToSpawn.get(serverLevel).remove(0);
        }
    }

    public static void onServerTick(MinecraftServer minecraftServer) {
        int serverTickCount = minecraftServer.method_3780();
        for (Pair<Integer, Runnable> pair : scheduledRunnables) {
            if ((Integer)pair.getFirst() > serverTickCount) continue;
            minecraftServer.method_18858((Runnable)new class_3738(minecraftServer.method_3780(), (Runnable)pair.getSecond()));
            scheduledRunnables.remove(pair);
        }
    }

    public static boolean onEntityJoinLevel(class_1937 level, class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return true;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (RegisterMod.shouldDoCheck) {
                RegisterMod.joinWorldProcess(level, player);
            }
            if (PlayerHeadCacheFeature.isHeadCachingEnabled()) {
                PlayerHeadCacheFeature.cachePlayer(player);
            }
        }
        if (entity.method_31481()) {
            return true;
        }
        if (GlobalVariables.globalSAMs.isEmpty()) {
            return true;
        }
        Set tags = entity.method_5752();
        if (tags.contains("collective.checked")) {
            return true;
        }
        entity.method_5780("collective.checked");
        class_1299 entityType = entity.method_5864();
        if (!GlobalVariables.activeSAMEntityTypes.contains(entityType)) {
            return true;
        }
        boolean isFromSpawner = tags.contains("collective.fromspawner");
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject sam : GlobalVariables.globalSAMs) {
            if (sam == null || sam.fromEntityType == null || !sam.fromEntityType.equals((Object)entityType) || sam.onlyFromSpawner && !isFromSpawner || !sam.onlyFromSpawner && isFromSpawner) continue;
            possibles.add(sam);
        }
        int size = possibles.size();
        if (size == 0) {
            return true;
        }
        class_243 eVec = entity.method_19538();
        boolean ageable = entity instanceof class_1296;
        boolean isOnSurface = BlockPosFunctions.isOnSurface(level, eVec);
        for (SAMObject sam : possibles) {
            class_1309 le;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.changeChance || (!sam.onlyOnSurface ? sam.onlyBelowSurface && isOnSurface : !isOnSurface)) continue;
            if (sam.onlyBelowSpecificY && eVec.field_1351 >= (double)sam.specificY) continue;
            class_1297 to = sam.toEntityType.method_5883(level);
            if (to == null) {
                return true;
            }
            to.method_5814(eVec.field_1352, eVec.field_1351, eVec.field_1350);
            if (ageable && to instanceof class_1296) {
                class_1296 am = (class_1296)to;
                am.method_5614(((class_1296)entity).method_5618());
                to = am;
            }
            boolean ignoreMainhand = false;
            if (sam.itemToHold != null && to instanceof class_1309 && !(le = (class_1309)to).method_6047().method_7909().equals(sam.itemToHold)) {
                le.method_6122(class_1268.field_5808, new class_1799((class_1935)sam.itemToHold, 1));
                ignoreMainhand = true;
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideNotReplace) {
                class_1496 ah = (class_1496)to;
                ah.method_6766(true);
                ride = true;
            } else if (CollectiveConfigHandler.transferItemsBetweenReplacedEntities) {
                EntityFunctions.transferItemsBetweenEntities(entity, to, ignoreMainhand);
            }
            if (!(level instanceof class_3218)) {
                return true;
            }
            class_3218 serverLevel = (class_3218)level;
            if (ride) {
                SpawnEntityFunctions.startRidingEntityOnNextTick(serverLevel, to, entity);
            } else {
                entity.method_5650(class_1297.class_5529.field_26999);
            }
            to.method_5780("collective.checked");
            SpawnEntityFunctions.spawnEntityOnNextTick(serverLevel, to);
            return ride;
        }
        return true;
    }
}

