/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.events;

import com.mojang.brigadier.CommandDispatcher;
import com.natamus.collective_common_forge.cmds.CommandCollective;
import com.natamus.collective_common_forge.config.GenerateJSONFiles;
import com.natamus.collective_common_forge.events.CollectiveEvents;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RegisterCollectiveForgeEvents {
    @SubscribeEvent
    public void onServerStarted(ServerAboutToStartEvent e) {
        GenerateJSONFiles.initGeneration(e.getServer());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent e) {
        Level level = e.level;
        if (level.f_46443_ || !e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        CollectiveEvents.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (!e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        CollectiveEvents.onServerTick(e.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMobSpawnerSpecialSpawn(MobSpawnEvent.FinalizeSpawn e) {
        Level Level2 = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (Level2 == null) {
            return;
        }
        if (!e.isSpawnCancelled() && e.getSpawner() != null) {
            e.getEntity().m_20049_("collective.fromspawner");
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent e) {
        if (!CollectiveEvents.onEntityJoinLevel(e.getLevel(), e.getEntity())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent e) {
        CommandCollective.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }
}

