/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import com.natamus.collective_common_forge.services.Services;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.ArrayUtils;

public class DataFunctions {
    public static String readStringFromURL(String requestURL) {
        String data = "";
        try (Scanner scanner = new Scanner(new URL(requestURL).openStream(), StandardCharsets.UTF_8);){
            scanner.useDelimiter("\\A");
            data = scanner.hasNext() ? scanner.next() : "";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static String getCurrentMinecraftVersion() {
        return "1.20.1";
    }

    public static String getGameDirectory() {
        return Services.MODLOADER.getGameDirectory();
    }

    public static Path getGameDirectoryPath() {
        return Path.of(DataFunctions.getGameDirectory(), new String[0]);
    }

    public static String getModDirectory() {
        return DataFunctions.getGameDirectory() + File.separator + "mods";
    }

    public static Path getModDirectoryPath() {
        return Path.of(DataFunctions.getModDirectory(), new String[0]);
    }

    public static String getConfigDirectory() {
        return DataFunctions.getGameDirectory() + File.separator + "config";
    }

    public static Path getConfigDirectoryPath() {
        return Path.of(DataFunctions.getConfigDirectory(), new String[0]);
    }

    public static List<String> getInstalledModJars() {
        ArrayList<String> installedmods = new ArrayList<String>();
        File mainFolder = new File(DataFunctions.getModDirectory());
        Object[] listOfMainFiles = mainFolder.listFiles();
        File subFolder = new File(DataFunctions.getModDirectory() + File.separator + DataFunctions.getCurrentMinecraftVersion());
        Object[] listOfSubFiles = subFolder.listFiles();
        for (File file : (File[])ArrayUtils.addAll((Object[])listOfMainFiles, (Object[])listOfSubFiles)) {
            if (!file.isFile()) continue;
            String filename = file.getName().replaceAll(" +\\([0-9]+\\)", "");
            installedmods.add(filename);
        }
        return installedmods;
    }

    public static byte setBit(byte b, int i, boolean bo) {
        b = bo ? (byte)(b | i) : (byte)(b & ~i);
        return b;
    }
}

