/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

import cofh.lib.util.SocialUtils;
import cofh.lib.util.helpers.SecurityHelper;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.scoreboard.Team;

public interface ISecurable {
    public AccessMode getAccess();

    public GameProfile getOwner();

    public void setAccess(AccessMode var1);

    public boolean setOwner(GameProfile var1);

    default public String getOwnerName() {
        return this.getOwner().getName();
    }

    default public boolean canAccess(Entity entity) {
        return this.getAccess().matches(this.getOwner(), entity);
    }

    default public boolean isSecurable() {
        return true;
    }

    default public boolean hasSecurity() {
        return !SecurityHelper.isDefaultProfile(this.getOwner());
    }

    public static enum AccessMode {
        PUBLIC,
        PRIVATE,
        FRIENDS,
        TEAM;

        public static final AccessMode[] VALUES;

        public boolean matches(GameProfile owner, Entity entity) {
            UUID ownerID = owner.getId();
            if (SecurityHelper.isDefaultUUID(ownerID)) {
                return true;
            }
            UUID otherID = SecurityHelper.getID(entity);
            switch (this) {
                case PRIVATE: {
                    return ownerID.equals(otherID);
                }
                case FRIENDS: {
                    return ownerID.equals(otherID) || entity instanceof ServerPlayerEntity && SocialUtils.isFriendOrSelf(owner, (ServerPlayerEntity)entity);
                }
                case TEAM: {
                    if (ownerID.equals(otherID)) {
                        return true;
                    }
                    Team team = entity.func_96124_cp();
                    if (team == null) {
                        return false;
                    }
                    return team.func_96670_d().contains(owner.getName());
                }
            }
            return true;
        }

        public boolean isPublic() {
            return this == PUBLIC;
        }

        public boolean isPrivate() {
            return this == PRIVATE;
        }

        public boolean isTeamOnly() {
            return this == TEAM;
        }

        public boolean isFriendsOnly() {
            return this == FRIENDS;
        }

        static {
            VALUES = AccessMode.values();
        }
    }
}

