/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoreReferences;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AreaUtils {
    public static final int HORZ_MAX = 32;
    public static final int VERT_MAX = 16;
    public static final Set<BlockState> REPLACEABLE_AIR = new ObjectOpenHashSet((Object[])new BlockState[]{Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P()});
    public static final IEffectApplier igniteEntities = (target, duration, power, source) -> {
        if (!target.func_230279_az_() && !target.func_70090_H() && target.func_223314_ad() <= 0) {
            target.func_70015_d(duration / 20);
        }
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.func_195063_d(CoreReferences.CHILLED);
        }
    };
    public static final IEffectApplier chillEntities = (target, duration, power, source) -> {
        if (target.func_223314_ad() > 0) {
            target.func_241209_g_(0);
        }
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.func_195064_c(new EffectInstance(CoreReferences.CHILLED, duration, power));
        }
    };
    public static final IEffectApplier sunderEntities = (target, duration, power, source) -> {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.func_195064_c(new EffectInstance(CoreReferences.SUNDERED, duration, power));
        }
    };
    public static final IEffectApplier shockEntities = (target, duration, power, source) -> {
        LivingEntity living;
        if (target instanceof LivingEntity && !(living = (LivingEntity)target).func_70644_a(CoreReferences.LIGHTNING_RESISTANCE)) {
            living.func_195064_c(new EffectInstance(CoreReferences.SHOCKED, duration, power));
        }
    };
    public static final IBlockTransformer fireTransform = (world, pos, face, entity) -> {
        boolean succeeded = false;
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos) && AbstractFireBlock.func_241465_a_((World)world, (BlockPos)pos, (Direction)face)) {
            succeeded |= world.func_180501_a(pos, AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)pos), 11);
        }
        return succeeded;
    };
    public static final IBlockTransformer fireTransformSpecial = (world, pos, face, entity) -> {
        boolean succeeded = false;
        BlockState state = world.func_180495_p(pos);
        if (AreaUtils.isUnlitCampfire(state)) {
            succeeded = world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
        } else if (AreaUtils.isUnlitTNT(state)) {
            state.func_177230_c().catchFire(state, world, pos, Direction.UP, entity instanceof LivingEntity ? (LivingEntity)entity : null);
            succeeded = world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        } else if (state.func_177230_c() == Blocks.field_150432_aD || state.func_177230_c() == Blocks.field_185778_de) {
            succeeded = world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
        } else if (state.func_177230_c() == Blocks.field_150433_aE) {
            succeeded = world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        return succeeded;
    };
    public static final IBlockTransformer iceTransform = (world, pos, face, entity) -> {
        boolean isFull;
        boolean succeeded = false;
        BlockState state = world.func_180495_p(pos);
        boolean permanentWater = true;
        boolean permanentLava = true;
        if (AreaUtils.isLitCampfire(state)) {
            succeeded |= world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)));
        }
        if (world.func_175623_d(pos) && AreaUtils.isValidSnowPosition(world, pos)) {
            succeeded |= world.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
        }
        if (state.func_177230_c() == Blocks.field_150480_ab) {
            succeeded |= world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        boolean bl = isFull = state.func_177230_c() == Blocks.field_150355_j && (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
        if (state.func_185904_a() == Material.field_151586_h && isFull && state.func_196955_c((IWorldReader)world, pos) && world.func_226663_a_(state, pos, ISelectionContext.func_216377_a())) {
            succeeded |= world.func_175656_a(pos, permanentWater ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_185778_de.func_176223_P());
            if (!permanentWater) {
                world.func_205220_G_().func_205360_a(pos, (Object)Blocks.field_185778_de, net.minecraft.util.math.MathHelper.func_76136_a((Random)world.field_73012_v, (int)60, (int)120));
            }
        }
        boolean bl2 = isFull = state.func_177230_c() == Blocks.field_150353_l && (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
        if (state.func_185904_a() == Material.field_151587_i && isFull && state.func_196955_c((IWorldReader)world, pos) && world.func_226663_a_(state, pos, ISelectionContext.func_216377_a())) {
            succeeded |= world.func_175656_a(pos, permanentLava ? Blocks.field_150343_Z.func_176223_P() : CoreReferences.GLOSSED_MAGMA.func_176223_P());
            if (!permanentLava) {
                world.func_205220_G_().func_205360_a(pos, (Object)CoreReferences.GLOSSED_MAGMA, net.minecraft.util.math.MathHelper.func_76136_a((Random)world.field_73012_v, (int)60, (int)120));
            }
        }
        return succeeded;
    };
    public static final IBlockTransformer iceSurfaceTransform = (world, pos, face, entity) -> {
        BlockPos above;
        BlockState frozenLava;
        boolean succeeded = false;
        BlockState state = world.func_180495_p(pos);
        boolean permanentWater = true;
        boolean permanentLava = true;
        BlockState frozenWater = permanentWater ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_185778_de.func_176223_P();
        BlockState blockState = frozenLava = permanentLava ? Blocks.field_150343_Z.func_176223_P() : CoreReferences.GLOSSED_MAGMA.func_176223_P();
        if (world.func_175623_d(pos) && AreaUtils.isValidSnowPosition(world, pos)) {
            succeeded |= world.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
        }
        if (world.func_180495_p(above = pos.func_177972_a(Direction.UP)).isAir((IBlockReader)world, above)) {
            boolean isFull;
            boolean bl = isFull = state.func_177230_c() == Blocks.field_150355_j && (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (state.func_185904_a() == Material.field_151586_h && isFull && state.func_196955_c((IWorldReader)world, pos) && world.func_226663_a_(state, pos, ISelectionContext.func_216377_a())) {
                succeeded |= world.func_175656_a(pos, frozenWater);
                if (!permanentWater) {
                    world.func_205220_G_().func_205360_a(pos, (Object)Blocks.field_185778_de, net.minecraft.util.math.MathHelper.func_76136_a((Random)world.field_73012_v, (int)60, (int)120));
                }
            }
            boolean bl2 = isFull = state.func_177230_c() == Blocks.field_150353_l && (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (state.func_185904_a() == Material.field_151587_i && isFull && state.func_196955_c((IWorldReader)world, pos) && world.func_226663_a_(state, pos, ISelectionContext.func_216377_a())) {
                succeeded |= world.func_175656_a(pos, frozenLava);
                if (!permanentLava) {
                    world.func_205220_G_().func_205360_a(pos, (Object)CoreReferences.GLOSSED_MAGMA, net.minecraft.util.math.MathHelper.func_76136_a((Random)world.field_73012_v, (int)60, (int)120));
                }
            }
        }
        return succeeded;
    };
    public static final IBlockTransformer earthTransform = (world, pos, face, entity) -> {
        boolean succeeded = false;
        BlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        if (material == Material.field_151576_e || material == Material.field_151578_c || state.func_177230_c() instanceof SnowyDirtBlock) {
            succeeded |= Utils.destroyBlock(world, pos, true, entity);
        }
        return succeeded;
    };
    public static final IBlockTransformer lightningTransform = (world, pos, face, entity) -> {
        boolean succeeded = false;
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos) && AreaUtils.isValidLightningBoltPosition(world, pos, 1.0)) {
            succeeded |= world.func_175656_a(pos, CoreReferences.LIGHTNING_AIR.func_176223_P());
        }
        return succeeded;
    };
    public static final IBlockTransformer signalAirTransform = AreaUtils.getConversionTransform(REPLACEABLE_AIR, CoreReferences.SIGNAL_AIR.func_176223_P(), false);
    public static final IBlockTransformer glowAirTransform = AreaUtils.getConversionTransform(REPLACEABLE_AIR, CoreReferences.GLOW_AIR.func_176223_P(), false);
    public static final IEffectApplier glowEntities = (target, duration, power, source) -> {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.func_195064_c(new EffectInstance(Effects.field_188423_x, duration, power));
            if (living.func_70668_bt() == CreatureAttribute.field_223223_b_) {
                living.func_70097_a(DamageSource.func_188405_b((LivingEntity)(source instanceof LivingEntity ? (LivingEntity)source : null)), 4.0f);
                living.func_70015_d(duration / 20);
            }
        }
    };
    public static final IBlockTransformer enderAirTransform = AreaUtils.getConversionTransform(REPLACEABLE_AIR, CoreReferences.ENDER_AIR.func_176223_P(), false);
    public static final IEffectApplier enderfereEntities = (target, duration, power, source) -> {
        if (target instanceof EndermanEntity || target instanceof EndermiteEntity) {
            LivingEntity living = (LivingEntity)target;
            living.func_195064_c(new EffectInstance(CoreReferences.ENDERFERENCE, duration, power));
            living.func_70097_a(DamageSource.func_188405_b((LivingEntity)(source instanceof LivingEntity ? (LivingEntity)source : null)), 4.0f);
        }
    };
    public static final IBlockTransformer myceliumTransform = AreaUtils.getConversionTransform((Set<BlockState>)new ObjectOpenHashSet((Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P()}), Blocks.field_150391_bh.func_176223_P(), true);
    public static final IBlockTransformer grassTransform = AreaUtils.getConversionTransform(Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P(), true);
    public static final IBlockTransformer growMushrooms = new IBlockTransformer(){

        @Override
        public boolean transformBlock(World world, BlockPos pos, Direction face, @Nullable Entity entity) {
            Block below = world.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c();
            if (world.func_180495_p(pos).isAir((IBlockReader)world, pos) && (below.equals(Blocks.field_150391_bh) || below.equals(Blocks.field_196661_l))) {
                return world.func_175656_a(pos, world.field_73012_v.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P());
            }
            return false;
        }

        @Override
        public void transformSphere(World world, Vector3d pos, float radius, float chance, int max, @Nullable Entity entity) {
            float f = Math.min(32.0f, radius);
            float v = Math.min(16.0f, radius);
            float f2 = f * f;
            BlockPos origin = new BlockPos(pos);
            if (this.transformBlock(world, origin.func_177972_a(Direction.UP), Direction.DOWN, entity)) {
                --max;
            }
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)origin.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)origin.func_177963_a((double)(f + 1.0f), (double)(v + 1.0f), (double)(f + 1.0f)))) {
                if (max <= 0) {
                    return;
                }
                double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2) || !(world.field_73012_v.nextDouble() < 0.5 - distance / (double)f2) || !this.transformBlock(world, iterPos, Direction.DOWN, entity)) continue;
                --max;
            }
        }
    };
    public static final IBlockTransformer growPlants = (world, pos, face, entity) -> {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IGrowable) {
            IGrowable growable = (IGrowable)state.func_177230_c();
            if (!world.field_72995_K && growable.func_176473_a((IBlockReader)world, pos, state, world.field_72995_K) && growable.func_180670_a(world, world.field_73012_v, pos, state)) {
                block4: {
                    try {
                        growable.func_225535_a_((ServerWorld)world, world.field_73012_v, pos, state);
                    }
                    catch (Exception e) {
                        if (growable instanceof BambooBlock) break block4;
                        throw e;
                    }
                }
                return true;
            }
        }
        return false;
    };

    private AreaUtils() {
    }

    private static IBlockTransformer getConversionTransform(Set<BlockState> replaceable, BlockState replacement, boolean requireAir) {
        if (requireAir) {
            return (worldIn, pos, face, entity) -> {
                BlockPos above = pos.func_177972_a(Direction.UP);
                if (worldIn.func_180495_p(above).isAir((IBlockReader)worldIn, above) && replaceable.contains(worldIn.func_180495_p(pos))) {
                    return worldIn.func_175656_a(pos, replacement);
                }
                return false;
            };
        }
        return (worldIn, pos, face, entity) -> {
            if (replaceable.contains(worldIn.func_180495_p(pos))) {
                return worldIn.func_175656_a(pos, replacement);
            }
            return false;
        };
    }

    private static IBlockTransformer getConversionTransform(BlockState replaceable, BlockState replacement, boolean requireAir) {
        if (requireAir) {
            return (worldIn, pos, face, entity) -> {
                BlockPos above = pos.func_177972_a(Direction.UP);
                if (worldIn.func_180495_p(above).isAir((IBlockReader)worldIn, above) && replaceable.equals(worldIn.func_180495_p(pos))) {
                    return worldIn.func_175656_a(pos, replacement);
                }
                return false;
            };
        }
        return (worldIn, pos, face, entity) -> {
            if (replaceable.equals(worldIn.func_180495_p(pos))) {
                return worldIn.func_175656_a(pos, replacement);
            }
            return false;
        };
    }

    public static boolean isLitCampfire(BlockState state) {
        return state.func_177230_c() instanceof CampfireBlock && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false;
    }

    public static boolean isUnlitCampfire(BlockState state) {
        return state.func_177230_c() instanceof CampfireBlock && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) == false && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) == false;
    }

    public static boolean isUnlitTNT(BlockState state) {
        return state.func_177230_c() instanceof TNTBlock;
    }

    public static void igniteNearbyEntities(Entity entity, World worldIn, BlockPos pos, int radius, int duration) {
        AxisAlignedBB area = new AxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(1 + radius, 1 + radius, 1 + radius));
        List mobs = worldIn.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a);
        mobs.removeIf(Entity::func_70090_H);
        mobs.removeIf(Entity::func_230279_az_);
        mobs.removeIf(mob -> mob instanceof EndermanEntity);
        for (LivingEntity mob2 : mobs) {
            mob2.func_70015_d(duration);
        }
    }

    public static void igniteNearbyGround(Entity entity, World worldIn, BlockPos pos, int radius, double chance) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !AreaUtils.isValidFirePosition(worldIn, (BlockPos)mutable, chance)) continue;
            worldIn.func_175656_a((BlockPos)mutable, ((FireBlock)Blocks.field_150480_ab).func_196448_a((IBlockReader)worldIn, (BlockPos)mutable));
        }
    }

    public static void igniteSpecial(Entity entity, World worldIn, BlockPos pos, int radius, boolean campfire, boolean tnt, @Nullable Entity igniter) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            BlockState state = worldIn.func_180495_p(blockpos);
            if (campfire && AreaUtils.isUnlitCampfire(state)) {
                worldIn.func_175656_a(blockpos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
                continue;
            }
            if (!tnt || !AreaUtils.isUnlitTNT(state)) continue;
            state.func_177230_c().catchFire(state, worldIn, blockpos, Direction.UP, igniter instanceof LivingEntity ? (LivingEntity)igniter : null);
            worldIn.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public static boolean isValidFirePosition(World worldIn, BlockPos pos, double chance) {
        BlockPos below = pos.func_177977_b();
        BlockState state = worldIn.func_180495_p(below);
        if (Block.func_208061_a((VoxelShape)state.func_196952_d((IBlockReader)worldIn, below), (Direction)Direction.UP)) {
            return state.func_185904_a().func_76217_h() || worldIn.field_73012_v.nextDouble() < chance;
        }
        return false;
    }

    public static void freezeNearbyGround(Entity entity, World worldIn, BlockPos pos, int radius) {
        BlockState state = Blocks.field_150433_aE.func_176223_P();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !(worldIn.func_226691_t_((BlockPos)mutable).func_225486_c(blockpos) < 0.8f) || !AreaUtils.isValidSnowPosition(worldIn, (BlockPos)mutable)) continue;
            worldIn.func_175656_a((BlockPos)mutable, state);
        }
    }

    public static void freezeSpecial(Entity entity, World worldIn, BlockPos pos, int radius, boolean campfire, boolean fire) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            BlockState state = worldIn.func_180495_p(blockpos);
            if (campfire && AreaUtils.isLitCampfire(state)) {
                worldIn.func_175656_a(blockpos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)));
                continue;
            }
            if (!fire || state.func_177230_c() != Blocks.field_150480_ab) continue;
            worldIn.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public static void freezeSurfaceWater(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        BlockState state = permanent ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_185778_de.func_176223_P();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150355_j && (Integer)blockstate2.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151586_h || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            if (permanent) continue;
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)Blocks.field_185778_de, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static void freezeAllWater(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        BlockState state = permanent ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_185778_de.func_176223_P();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150355_j && (Integer)blockstate2.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151586_h || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            if (permanent) continue;
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)Blocks.field_185778_de, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static void freezeSurfaceLava(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        if (CoreReferences.GLOSSED_MAGMA == null && !permanent) {
            return;
        }
        BlockState state = permanent ? Blocks.field_150343_Z.func_176223_P() : CoreReferences.GLOSSED_MAGMA.func_176223_P();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150353_l && (Integer)blockstate2.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151587_i || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            if (permanent) continue;
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)CoreReferences.GLOSSED_MAGMA, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static void freezeAllLava(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        if (CoreReferences.GLOSSED_MAGMA == null && !permanent) {
            return;
        }
        BlockState state = permanent ? Blocks.field_150343_Z.func_176223_P() : CoreReferences.GLOSSED_MAGMA.func_176223_P();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150353_l && (Integer)blockstate2.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151587_i || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            if (permanent) continue;
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)CoreReferences.GLOSSED_MAGMA, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static boolean isValidSnowPosition(World worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj || block == Blocks.field_180401_cv || block == Blocks.field_185778_de || block == CoreReferences.GLOSSED_MAGMA) {
            return false;
        }
        return Block.func_208061_a((VoxelShape)state.func_196952_d((IBlockReader)worldIn, pos.func_177977_b()), (Direction)Direction.UP) || block == Blocks.field_150433_aE && (Integer)state.func_177229_b((Property)SnowBlock.field_176315_a) == 8;
    }

    private static boolean isValidLightningBoltPosition(World worldIn, BlockPos pos, double chance) {
        BlockPos below = pos.func_177977_b();
        BlockState state = worldIn.func_180495_p(below);
        if (worldIn.func_226660_f_(pos) && Block.func_208061_a((VoxelShape)state.func_196952_d((IBlockReader)worldIn, below), (Direction)Direction.UP)) {
            return worldIn.field_73012_v.nextDouble() < chance;
        }
        return false;
    }

    public static void transformArea(Entity entity, World worldIn, BlockPos pos, BlockState replaceable, BlockState replacement, int radius, boolean requireAir) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (requireAir) {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2)) continue;
                mutable.func_181079_c(iterPos.func_177958_n(), iterPos.func_177956_o() + 1, iterPos.func_177952_p());
                BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
                if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || worldIn.func_180495_p(iterPos) != replaceable) continue;
                worldIn.func_175656_a(iterPos, replacement);
            }
        } else {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2) || worldIn.func_180495_p(iterPos) != replaceable) continue;
                worldIn.func_175656_a(iterPos, replacement);
            }
        }
    }

    public static void transformArea(Entity entity, World worldIn, BlockPos pos, Set<BlockState> replaceable, BlockState replacement, int radius, boolean requireAir) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (requireAir) {
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2)) continue;
                mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
                BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
                if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !replaceable.contains(worldIn.func_180495_p(blockpos))) continue;
                worldIn.func_175656_a(blockpos, replacement);
            }
        } else {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                if (!iterPos.func_218137_a((IPosition)entity.func_213303_ch(), (double)f) || !replaceable.contains(worldIn.func_180495_p(iterPos))) continue;
                worldIn.func_175656_a(iterPos, replacement);
            }
        }
    }

    public static void transformGrass(Entity entity, World worldIn, BlockPos pos, int radius) {
        AreaUtils.transformArea(entity, worldIn, pos, Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P(), radius, true);
    }

    public static void transformMycelium(Entity entity, World worldIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P()});
        AreaUtils.transformArea(entity, worldIn, pos, (Set<BlockState>)replaceable, Blocks.field_150391_bh.func_176223_P(), radius, true);
    }

    public static void transformSignalAir(Entity entity, World worldIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P()});
        AreaUtils.transformArea(entity, worldIn, pos, (Set<BlockState>)replaceable, CoreReferences.SIGNAL_AIR.func_176223_P(), radius, false);
    }

    public static void transformGlowAir(Entity entity, World worldIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P()});
        AreaUtils.transformArea(entity, worldIn, pos, (Set<BlockState>)replaceable, CoreReferences.GLOW_AIR.func_176223_P(), radius, false);
    }

    public static void transformEnderAir(Entity entity, World worldIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P()});
        AreaUtils.transformArea(entity, worldIn, pos, (Set<BlockState>)replaceable, CoreReferences.ENDER_AIR.func_176223_P(), radius, false);
    }

    public static void zapNearbyGround(Entity entity, World worldIn, BlockPos pos, int radius, double chance, int max) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int count = 0;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            if (count >= max) {
                return;
            }
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !AreaUtils.isValidLightningBoltPosition(worldIn, (BlockPos)mutable, chance)) continue;
            worldIn.func_175656_a((BlockPos)mutable, CoreReferences.LIGHTNING_AIR.func_176223_P());
            ++count;
        }
    }

    public static void growMushrooms(Entity entity, World worldIn, BlockPos pos, int radius, int count) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        int grow = 0;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        mutable.func_189533_g((Vector3i)entity.func_233580_cy_().func_177984_a());
        BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
        if (blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) && AreaUtils.isValidMushroomPosition(worldIn, entity.func_233580_cy_(), 1.0)) {
            worldIn.func_175656_a((BlockPos)mutable, worldIn.field_73012_v.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P());
            ++grow;
        }
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            if (grow >= count) {
                return;
            }
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(iterPos.func_177958_n(), iterPos.func_177956_o() + 1, iterPos.func_177952_p());
            blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !AreaUtils.isValidMushroomPosition(worldIn, iterPos, 0.5 - distance / (double)f2)) continue;
            worldIn.func_175656_a((BlockPos)mutable, worldIn.field_73012_v.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P());
            ++grow;
        }
    }

    private static boolean isValidMushroomPosition(World worldIn, BlockPos pos, double chance) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return worldIn.field_73012_v.nextDouble() < chance && (block == Blocks.field_150391_bh || block == Blocks.field_196661_l);
    }

    public static void growPlants(Entity entity, World worldIn, BlockPos pos, int radius) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            IGrowable growable;
            BlockState state;
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2) || !((state = worldIn.func_180495_p(iterPos)).func_177230_c() instanceof IGrowable) || !(growable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)worldIn, iterPos, state, worldIn.field_72995_K) || worldIn.field_72995_K || !growable.func_180670_a(worldIn, worldIn.field_73012_v, iterPos, state)) continue;
            try {
                growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, iterPos, state);
            }
            catch (Exception e) {
                if (growable instanceof BambooBlock) continue;
                throw e;
            }
        }
    }

    public static void growPlants(Entity entity, World worldIn, BlockPos pos, int radius, int count) {
        BlockState state;
        int grow;
        float f2;
        float v;
        float f;
        block7: {
            IGrowable growable;
            f = Math.min(32, radius);
            v = Math.min(16, radius);
            f2 = f * f;
            grow = 0;
            state = worldIn.func_180495_p(entity.func_233580_cy_());
            if (state.func_177230_c() instanceof IGrowable && (growable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos, state, worldIn.field_72995_K) && !worldIn.field_72995_K && growable.func_180670_a(worldIn, worldIn.field_73012_v, pos, state)) {
                try {
                    growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, state);
                    ++grow;
                }
                catch (Exception e) {
                    if (growable instanceof BambooBlock) break block7;
                    throw e;
                }
            }
        }
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            IGrowable growable;
            if (grow >= count) {
                return;
            }
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2) || !((state = worldIn.func_180495_p(iterPos)).func_177230_c() instanceof IGrowable) || !(growable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)worldIn, iterPos, state, worldIn.field_72995_K) || worldIn.field_72995_K || !growable.func_180670_a(worldIn, worldIn.field_73012_v, iterPos, state)) continue;
            try {
                growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, iterPos, state);
                ++grow;
            }
            catch (Exception e) {
                if (growable instanceof BambooBlock) continue;
                throw e;
            }
        }
    }

    public static interface IBlockTransformer {
        public boolean transformBlock(World var1, BlockPos var2, Direction var3, @Nullable Entity var4);

        default public void transformSphere(World world, Vector3d pos, float radius, @Nullable Entity entity) {
            float f = Math.min(32.0f, radius);
            float v = Math.min(16.0f, radius);
            float f2 = f * f;
            BlockPos origin = new BlockPos(pos);
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)origin.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)origin.func_177963_a((double)(f + 1.0f), (double)(v + 1.0f), (double)(f + 1.0f)))) {
                if (!(iterPos.func_218138_a((IPosition)pos, true) < (double)f2)) continue;
                this.transformBlock(world, iterPos, Direction.DOWN, entity);
            }
        }

        default public void transformSphere(World world, Vector3d pos, float radius, float chance, @Nullable Entity entity) {
            float f = Math.min(32.0f, radius);
            float v = Math.min(16.0f, radius);
            float f2 = f * f;
            BlockPos origin = new BlockPos(pos);
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)origin.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)origin.func_177963_a((double)f, (double)v, (double)f))) {
                double distSqr = iterPos.func_218138_a((IPosition)pos, true);
                if (!(distSqr < (double)f2) || !(chance > 0.99999f) && !(world.field_73012_v.nextDouble() < (double)chance)) continue;
                this.transformBlock(world, iterPos, Direction.DOWN, entity);
            }
        }

        default public void transformSphere(World world, Vector3d pos, float radius, float chance, int max, @Nullable Entity entity) {
            float f = Math.min(32.0f, radius);
            float v = Math.min(16.0f, radius);
            float f2 = f * f;
            BlockPos origin = new BlockPos(pos);
            if (this.transformBlock(world, origin, Direction.DOWN, entity)) {
                --max;
            }
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)origin.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)origin.func_177963_a((double)f, (double)v, (double)f))) {
                if (max <= 0) {
                    return;
                }
                double distSqr = iterPos.func_218138_a((IPosition)pos, true);
                if (!(distSqr < (double)f2) || !(chance > 0.99999f) && !(world.field_73012_v.nextDouble() < (double)chance) || !this.transformBlock(world, iterPos, Direction.DOWN, entity)) continue;
                --max;
            }
        }
    }

    public static interface IEffectApplier {
        public void applyEffect(Entity var1, int var2, int var3, @Nullable Entity var4);

        default public void applyEffectNearby(World worldIn, Vector3d pos, Predicate<? super Entity> filter, float radius, int duration, int amplifier, @Nullable Entity source) {
            worldIn.func_175674_a(source, new AxisAlignedBB(pos.func_178786_a((double)radius, (double)radius, (double)radius), pos.func_72441_c((double)radius, (double)radius, (double)radius)).func_186662_g(1.0), filter).forEach(livingEntity -> this.applyEffect((Entity)livingEntity, duration, amplifier, source));
        }

        default public void applyEffectNearby(World worldIn, Vector3d pos, float radius, int duration, int amplifier, @Nullable Entity source) {
            this.applyEffectNearby(worldIn, pos, EntityPredicates.field_94557_a, radius, duration, amplifier, source);
        }

        default public void applyEffectNearby(World worldIn, Vector3d pos, float radius, int duration, int amplifier) {
            this.applyEffectNearby(worldIn, pos, radius, duration, amplifier, null);
        }
    }
}

