/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers.vfx;

import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.SplittableRandom;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public final class VFXHelper {
    private static final SortedMap<Float, List<int[]>> shockwaveOffsets = VFXHelper.getOffsets(16);
    public static final List<RenderType> chunkRenderTypes = RenderType.func_228661_n_();
    private static final Vector3f[][] arcs = VFXHelper.getRandomArcs(new Random(), 16, 50);
    private static final int WIND_SEGMENTS = 48;
    private static final float WIND_INCR = 0.1308997f;

    public static float lengthSqr(Vector3f vec) {
        return MathHelper.distSqr(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c());
    }

    public static float length(Vector3f vec) {
        return MathHelper.dist(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c());
    }

    public static Vector4f subtract(Vector4f a, Vector4f b) {
        return new Vector4f(a.func_195910_a() - b.func_195910_a(), a.func_195913_b() - b.func_195913_b(), a.func_195914_c() - b.func_195914_c(), a.func_195915_d() - b.func_195915_d());
    }

    public static int packRGBA(float r, float g, float b, float a) {
        return VFXHelper.packRGBA((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a));
    }

    public static int packRGBA(int r, int g, int b, int a) {
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static Vector4f mid(Vector4f a, Vector4f b) {
        return new Vector4f((a.func_195910_a() + b.func_195910_a()) * 0.5f, (a.func_195913_b() + b.func_195913_b()) * 0.5f, (a.func_195914_c() + b.func_195914_c()) * 0.5f, (a.func_195915_d() + b.func_195915_d()) * 0.5f);
    }

    private static void renderNodes(Matrix3f normal, IVertexBuilder builder, int packedLight, VFXNode[] nodes, int r, int g, int b, int a) {
        nodes[0].renderStart(normal, builder, packedLight, r, g, b, a);
        int count = nodes.length - 1;
        for (int i = 1; i < count; ++i) {
            nodes[i].renderMid(normal, builder, packedLight, r, g, b, a);
        }
        nodes[count].renderEnd(normal, builder, packedLight, r, g, b, a);
    }

    public static Vector2f axialPerp(Vector4f start, Vector4f end, float width) {
        float x = -start.func_195910_a();
        float y = -start.func_195913_b();
        if (Math.abs(start.func_195914_c()) > 0.0f) {
            float ratio = end.func_195914_c() / start.func_195914_c();
            x = end.func_195910_a() + x * ratio;
            y = end.func_195913_b() + y * ratio;
        } else if (Math.abs(end.func_195914_c()) <= 0.0f) {
            x += end.func_195910_a();
            y += end.func_195913_b();
        }
        if (start.func_195914_c() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / MathHelper.dist(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vector2f(-y, x);
    }

    public static Vector2f axialPerp(Vector3f start, Vector3f end, float width) {
        float x = -start.func_195899_a();
        float y = -start.func_195900_b();
        if (Math.abs(start.func_195902_c()) > 0.0f) {
            float ratio = end.func_195902_c() / start.func_195902_c();
            x = end.func_195899_a() + x * ratio;
            y = end.func_195900_b() + y * ratio;
        } else if (Math.abs(end.func_195902_c()) <= 0.0f) {
            x += end.func_195899_a();
            y += end.func_195900_b();
        }
        if (start.func_195902_c() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / MathHelper.dist(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vector2f(-y, x);
    }

    public static void transformVertical(MatrixStack stack, Vector3f dir) {
        boolean neg;
        dir.func_229194_d_();
        boolean bl = neg = dir.func_195900_b() < 0.0f;
        if ((double)(dir.func_195899_a() * dir.func_195899_a() + dir.func_195902_c() * dir.func_195902_c()) > 0.001) {
            dir.func_195896_c(Vector3f.field_229181_d_);
            float angle = -MathHelper.asin(VFXHelper.length(dir));
            if (neg) {
                angle = -((float)Math.PI + angle);
            }
            dir.func_229194_d_();
            stack.func_227863_a_(dir.func_229193_c_(angle));
        } else if (neg) {
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)Math.PI));
        }
    }

    public static void transformVertical(MatrixStack stack, Vector3f start, Vector3f end) {
        Vector3f diff = end.func_229195_e_();
        diff.func_195897_a(start);
        float scale = VFXHelper.length(diff);
        stack.func_227861_a_((double)start.func_195899_a(), (double)start.func_195900_b(), (double)start.func_195902_c());
        VFXHelper.transformVertical(stack, diff);
        stack.func_227862_a_(scale, scale, scale);
    }

    public static void renderTest(MatrixStack stack, IRenderTypeBuffer buffer) {
        IVertexBuilder builder = buffer.getBuffer(RenderTypes.FLAT_TRANSLUCENT);
        Vector4f center = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        center.func_229372_a_(stack.func_227866_c_().func_227870_a_());
        Matrix3f normal = stack.func_227866_c_().func_227872_b_();
        float xp = center.func_195910_a() + 0.5f;
        float xn = center.func_195910_a() - 0.5f;
        float yp = center.func_195913_b() + 0.5f;
        float yn = center.func_195913_b() - 0.5f;
        float z = center.func_195914_c();
        int r = 255;
        int g = 0;
        int b = 255;
        int a = 128;
        int packedLight = 0xF000F0;
        builder.func_225582_a_((double)xp, (double)yp, (double)z).func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)xn, (double)yp, (double)z).func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)xn, (double)yn, (double)z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)xp, (double)yn, (double)z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void renderTest(MatrixStack stack) {
        VFXHelper.renderTest(stack, (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_());
    }

    private static void renderSkeleton(IVertexBuilder builder, VFXNode[] nodes) {
        VFXNode node = nodes[0];
        float xm = node.xMid();
        float ym = node.yMid();
        builder.func_225582_a_((double)node.xp, (double)node.yp, (double)node.z).func_225586_a_(255, 0, 0, 255).func_181675_d();
        builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(255, 0, 0, 255).func_181675_d();
        builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(0, 0, 255, 255).func_181675_d();
        builder.func_225582_a_((double)node.xn, (double)node.yn, (double)node.z).func_225586_a_(0, 0, 255, 255).func_181675_d();
        builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(255, 255, 255, 255).func_181675_d();
        for (int i = 1; i < nodes.length - 1; ++i) {
            node = nodes[i];
            xm = node.xMid();
            ym = node.yMid();
            builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(255, 255, 255, 255).func_181675_d();
            builder.func_225582_a_((double)node.xp, (double)node.yp, (double)node.z).func_225586_a_(255, 0, 0, 255).func_181675_d();
            builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(255, 0, 0, 255).func_181675_d();
            builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(0, 0, 255, 255).func_181675_d();
            builder.func_225582_a_((double)node.xn, (double)node.yn, (double)node.z).func_225586_a_(0, 0, 255, 255).func_181675_d();
            builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(255, 255, 255, 255).func_181675_d();
        }
        node = nodes[nodes.length - 1];
        xm = node.xMid();
        ym = node.yMid();
        builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(255, 255, 255, 255).func_181675_d();
        builder.func_225582_a_((double)node.xp, (double)node.yp, (double)node.z).func_225586_a_(255, 0, 0, 255).func_181675_d();
        builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(255, 0, 0, 255).func_181675_d();
        builder.func_225582_a_((double)xm, (double)ym, (double)node.z).func_225586_a_(0, 0, 255, 255).func_181675_d();
        builder.func_225582_a_((double)node.xn, (double)node.yn, (double)node.z).func_225586_a_(0, 0, 255, 255).func_181675_d();
    }

    private static void renderSkeleton(VFXNode[] nodes) {
        VFXHelper.renderSkeleton(Minecraft.func_71410_x().func_228019_au_().func_228487_b_().getBuffer((RenderType)RenderType.field_228614_Q_), nodes);
    }

    public static void renderShockwave(MatrixStack stack, IRenderTypeBuffer buffer, IBlockDisplayReader world, BlockPos origin, float time, float radius, float heightScale, Predicate<BlockPos> canRender) {
        SortedMap<Float, List<int[]>> blocks = shockwaveOffsets.subMap(Float.valueOf(Math.min(time - 5.0f, radius)), Float.valueOf(Math.min(time, radius + 1.0f)));
        for (Float dist : blocks.keySet()) {
            float progress = time - dist.floatValue();
            double height = (double)heightScale * 0.16 * (double)(radius - dist.floatValue() * 0.5f) * (double)progress * (double)(5.0f - progress) / (double)radius;
            block1: for (int[] offset : (List)blocks.get(dist)) {
                for (int y = 1; y >= -1; --y) {
                    BlockPos pos = origin.func_177982_a(offset[0], y, offset[1]);
                    BlockState state = world.func_180495_p(pos);
                    if (!canRender.test(pos)) continue;
                    if (state.func_185901_i() != BlockRenderType.MODEL) continue block1;
                    stack.func_227860_a_();
                    stack.func_227861_a_((double)offset[0], height + (double)y, (double)offset[1]);
                    stack.func_227862_a_(1.01f, 1.01f, 1.01f);
                    for (RenderType type : chunkRenderTypes) {
                        if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                        ForgeHooksClient.setRenderLayer((RenderType)type);
                        BlockRendererDispatcher renderer = RenderHelper.renderBlock();
                        renderer.func_175019_b().renderModel(world, renderer.func_184389_a(state), state, pos.func_177972_a(Direction.UP), stack, buffer.getBuffer(type), false, new Random(), state.func_209533_a(pos), OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                    }
                    stack.func_227865_b_();
                    continue block1;
                }
            }
        }
        ForgeHooksClient.setRenderLayer(null);
    }

    public static void renderShockwave(MatrixStack stack, IRenderTypeBuffer buffer, IBlockDisplayReader world, BlockPos origin, float time, float radius, float heightScale) {
        VFXHelper.renderShockwave(stack, buffer, world, origin, time, radius, heightScale, pos -> {
            BlockState state = world.func_180495_p(pos);
            return !state.isAir((IBlockReader)world, pos) && state.func_215686_e((IBlockReader)world, pos) && state.getHarvestLevel() <= 5 && state.func_235785_r_((IBlockReader)world, pos) && !state.hasTileEntity() && !world.func_180495_p(pos.func_177984_a()).func_235785_r_((IBlockReader)world, pos.func_177984_a());
        });
    }

    private static SortedMap<Float, List<int[]>> getOffsets(int maxRadius) {
        TreeMap<Float, List<int[]>> blocks = new TreeMap<Float, List<int[]>>();
        float maxSqr = maxRadius * maxRadius;
        for (int x = 0; x <= net.minecraft.util.math.MathHelper.func_76123_f((float)maxRadius); ++x) {
            for (int z = 0; z <= x; ++z) {
                int distSqr = x * x + z * z;
                if (!((float)distSqr < maxSqr)) continue;
                float dist = net.minecraft.util.math.MathHelper.func_76129_c((float)distSqr);
                if (!blocks.containsKey(Float.valueOf(dist))) {
                    blocks.put(Float.valueOf(dist), new ArrayList());
                }
                VFXHelper.addReflections((List)blocks.get(Float.valueOf(dist)), x, z);
            }
        }
        return blocks;
    }

    private static void addReflections(List<int[]> list, int x, int z) {
        list.add(new int[]{x, z});
        list.add(new int[]{-x, -z});
        if (z != 0) {
            list.add(new int[]{-x, z});
            list.add(new int[]{x, -z});
        }
        if (x != 0 && x != z) {
            list.add(new int[]{z, x});
            list.add(new int[]{-z, -x});
            if (z != 0) {
                list.add(new int[]{-z, x});
                list.add(new int[]{z, -x});
            }
        }
    }

    private static void renderArcGlow(Matrix3f normal, IRenderTypeBuffer buffer, int packedLight, VFXNode[] nodes, float width, int r, int g, int b, int a) {
        int i;
        IVertexBuilder builder = buffer.getBuffer(RenderTypes.LINEAR_GLOW);
        Function<VFXNode, Float> glowWidth = node -> Float.valueOf((width * 0.3f + node.width * 0.7f) / node.width);
        Function<VFXNode, VFXNode> posGlow = node -> {
            float w = ((Float)glowWidth.apply((VFXNode)node)).floatValue();
            return new VFXNode(node.xp + (node.xp - node.xn) * w, node.xp, node.yp + (node.yp - node.yn) * w, node.yp, node.z, w);
        };
        Function<VFXNode, VFXNode> negGlow = node -> {
            float w = ((Float)glowWidth.apply((VFXNode)node)).floatValue();
            return new VFXNode(node.xn, node.xn - (node.xp - node.xn) * w, node.yn, node.yn - (node.yp - node.yn) * w, node.z, w);
        };
        int count = nodes.length - 1;
        posGlow.apply(nodes[0]).renderStart(normal, builder, packedLight, r, g, b, a, 0.0f, 0.0f, 0.5f, 1.0f);
        for (i = 1; i < count; ++i) {
            posGlow.apply(nodes[i]).renderMid(normal, builder, packedLight, r, g, b, a, 0.0f, 0.0f, 0.5f, 1.0f);
        }
        posGlow.apply(nodes[count]).renderEnd(normal, builder, packedLight, r, g, b, a, 0.0f, 0.0f, 0.5f, 1.0f);
        negGlow.apply(nodes[0]).renderStart(normal, builder, packedLight, r, g, b, a, 0.5f, 0.0f, 1.0f, 1.0f);
        for (i = 1; i < count; ++i) {
            negGlow.apply(nodes[i]).renderMid(normal, builder, packedLight, r, g, b, a, 0.5f, 0.0f, 1.0f, 1.0f);
        }
        negGlow.apply(nodes[count]).renderEnd(normal, builder, packedLight, r, g, b, a, 0.5f, 0.0f, 1.0f, 1.0f);
        VFXNode node2 = nodes[count];
        float nw = glowWidth.apply(node2).floatValue();
        float xw = (node2.xp - node2.xn) * nw;
        float yw = (node2.yp - node2.yn) * nw;
        builder.func_225582_a_((double)node2.xn, (double)node2.yn, (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xn + yw), (double)(node2.yn - xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xp + yw), (double)(node2.yp - xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)node2.xp, (double)node2.yp, (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder = buffer.getBuffer(RenderTypes.ROUND_GLOW);
        builder.func_225582_a_((double)node2.xp, (double)node2.yp, (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.5f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xp + yw), (double)(node2.yp - xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xp + xw + yw), (double)(node2.yp + yw - xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xp + xw), (double)(node2.yp + yw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 0.5f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)node2.xn, (double)node2.yn, (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.5f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xn - xw), (double)(node2.yn - yw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xn - xw + yw), (double)(node2.yn - yw - xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xn + yw), (double)(node2.yn - xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 0.5f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        node2 = nodes[0];
        nw = glowWidth.apply(node2).floatValue();
        xw = (node2.xp - node2.xn) * nw;
        yw = (node2.yp - node2.yn) * nw;
        builder.func_225582_a_((double)node2.xp, (double)node2.yp, (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.5f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xp + xw), (double)(node2.yp + yw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xp + xw - yw), (double)(node2.yp + yw + xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xp - yw), (double)(node2.yp + xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 0.5f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)node2.xn, (double)node2.yn, (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.5f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xn - yw), (double)(node2.yn + xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xn - xw - yw), (double)(node2.yn - yw + xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xn - xw), (double)(node2.yn - yw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 0.5f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder = buffer.getBuffer(RenderTypes.LINEAR_GLOW);
        builder.func_225582_a_((double)node2.xn, (double)node2.yn, (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)node2.xp, (double)node2.yp, (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xp - yw), (double)(node2.yp + xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_((double)(node2.xn - yw), (double)(node2.yn + xw), (double)node2.z).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void renderArc(Matrix3f normal, IRenderTypeBuffer buffer, int packedLight, VFXNode[] nodes, float width, int rgba) {
        VFXHelper.renderNodes(normal, buffer.getBuffer(RenderTypes.FLAT_TRANSLUCENT), packedLight, nodes, 255, 255, 255, 255);
        VFXHelper.renderArcGlow(normal, buffer, packedLight, nodes, width, rgba >> 24 & 0xFF, rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba & 0xFF);
    }

    public static void renderStraightArcs(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, int packedLightIn, int arcCount, float arcWidth, long seed, int rgba, float taperOffset) {
        SplittableRandom rand = new SplittableRandom(seed);
        matrixStackIn.func_227860_a_();
        int nodeCount = arcs[0].length;
        int first = MathHelper.clamp((int)((float)nodeCount * (taperOffset - 0.25f) + 1.0f), 0, nodeCount);
        int last = MathHelper.clamp((int)((float)nodeCount * (1.25f + taperOffset) + 1.0f), 0, nodeCount);
        if (last - first > 1) {
            MatrixStack.Entry stackEntry = matrixStackIn.func_227866_c_();
            Matrix4f pose = stackEntry.func_227870_a_();
            Matrix3f normal = stackEntry.func_227872_b_();
            Vector4f start = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            start.func_229372_a_(pose);
            Vector4f end = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
            end.func_229372_a_(pose);
            Vector2f perp = VFXHelper.axialPerp(start, end, 1.0f);
            Vector3f[][] randomArcs = new Vector3f[nodeCount][arcCount];
            float[] rotations = new float[arcCount];
            for (int i = 0; i < arcCount; ++i) {
                randomArcs[i] = arcs[rand.nextInt(arcs.length)];
                rotations[i] = (float)rand.nextDouble(360.0);
            }
            float incr = 1.0f / (float)nodeCount;
            for (int i = 0; i < arcCount; ++i) {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotations[i]));
                Vector3f[] arc = randomArcs[i];
                VFXNode[] nodes = new VFXNode[last - first];
                for (int j = first; j < last; ++j) {
                    Vector4f center = new Vector4f(0.0f, arc[j].func_195900_b(), 0.0f, 1.0f);
                    center.func_229372_a_(pose);
                    Vector4f pos = new Vector4f(arc[j]);
                    pos.func_229372_a_(pose);
                    float dot = VFXHelper.subtract(pos, center).func_229373_a_(new Vector4f(perp.field_189982_i, perp.field_189983_j, 0.0f, 0.0f));
                    float xc = center.func_195910_a() + perp.field_189982_i * dot * 3.0f;
                    float yc = center.func_195913_b() + perp.field_189983_j * dot * 3.0f;
                    float width = arcWidth * ((float)rand.nextDouble() * 0.6f + 0.7f) * MathHelper.clamp(4.0f * (0.75f - Math.abs((float)j * incr - 0.5f - taperOffset)), 0.0f, 1.0f);
                    float xw = perp.field_189982_i * width;
                    float yw = perp.field_189983_j * width;
                    nodes[j - first] = new VFXNode(xc + xw, xc - xw, yc + yw, yc - yw, center.func_195914_c(), width);
                }
                VFXHelper.renderArc(normal, buffer, packedLightIn, nodes, arcWidth, rgba);
            }
        }
        matrixStackIn.func_227865_b_();
    }

    public static void renderStraightArcs(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, int packedLightIn, float length, int arcCount, float arcWidth, long seed, int rgba, float taperOffset) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(length, length, length);
        VFXHelper.renderStraightArcs(matrixStackIn, buffer, packedLightIn, arcCount, arcWidth / Math.abs(length), seed, rgba, taperOffset);
        matrixStackIn.func_227865_b_();
    }

    public static long getSeedWithTime(long seed, float time, float flickerRate) {
        return seed + (long)(69420 * (int)(time * flickerRate));
    }

    public static long getSeedWithTime(long seed, float time) {
        return VFXHelper.getSeedWithTime(seed, time, 0.8f);
    }

    public static float getTaperOffsetFromTimes(float time, float endTime, float taperTime) {
        float offset = 0.0f;
        if (time < taperTime) {
            offset = 1.25f * (time - taperTime) / taperTime;
        } else if (endTime - time < taperTime) {
            offset = 1.25f * (time + taperTime - endTime) / taperTime;
        }
        return offset;
    }

    public static float getTaperOffsetFromTimes(float time, float startTime, float endTime, float taperTime) {
        return VFXHelper.getTaperOffsetFromTimes(time - startTime, endTime - startTime, taperTime);
    }

    private static Vector3f[][] getRandomArcs(Random random, int arcCount, int nodeCount) {
        Vector3f[][] arcs = new Vector3f[arcCount][nodeCount];
        for (int i = 0; i < arcs.length; ++i) {
            arcs[i] = VFXHelper.getRandomNodes(random, nodeCount);
        }
        return arcs;
    }

    private static Vector3f[] getRandomNodes(Random random, int count) {
        float[] y = new float[count];
        for (int i = 0; i < y.length; ++i) {
            y[i] = random.nextFloat();
        }
        Arrays.sort(y);
        Vector3f[] nodes = new Vector3f[y.length];
        nodes[0] = new Vector3f(0.0f, 0.0f, 0.0f);
        nodes[nodes.length - 1] = new Vector3f(0.0f, 1.0f, 0.0f);
        for (int i = 1; i < nodes.length - 1; ++i) {
            float eccentricity = 0.3f * (y[i] - y[i - 1]);
            float centering = Math.min(1.0f, 3.0f - 3.0f * (float)i / (float)nodes.length);
            nodes[i] = new Vector3f(centering * nodes[i - 1].func_195899_a() + eccentricity * VFXHelper.boundedGaussian(random, 1.65f), y[i], centering * nodes[i - 1].func_195902_c() + eccentricity * VFXHelper.boundedGaussian(random, 1.65f));
        }
        return nodes;
    }

    private static float boundedGaussian(Random random, float z) {
        return MathHelper.clamp((float)random.nextGaussian(), -z, z);
    }

    public static Function<Float, Float> getWidthFunc(float width) {
        return index -> Float.valueOf(width * MathHelper.easePlateau(index.floatValue()));
    }

    public static void renderStreamLine(MatrixStack stack, IVertexBuilder builder, int packedLight, Vector4f[] poss, int rgba, Function<Float, Float> widthFunc) {
        if (poss.length < 3) {
            return;
        }
        int a = rgba & 0xFF;
        if (a <= 0) {
            return;
        }
        int r = rgba >> 24 & 0xFF;
        int g = rgba >> 16 & 0xFF;
        int b = rgba >> 8 & 0xFF;
        MatrixStack.Entry stackEntry = stack.func_227866_c_();
        Matrix4f pose = stackEntry.func_227870_a_();
        Matrix3f normal = stackEntry.func_227872_b_();
        for (Vector4f pos : poss) {
            pos.func_229372_a_(pose);
        }
        int count = poss.length - 1;
        VFXNode[] nodes = new VFXNode[count];
        float increment = 1.0f / (float)(count - 1);
        for (int i = 0; i < count; ++i) {
            Vector4f start = poss[i];
            Vector4f end = poss[i + 1];
            float width = widthFunc.apply(Float.valueOf(increment * (float)i)).floatValue();
            nodes[i] = new VFXNode(VFXHelper.mid(start, end), VFXHelper.axialPerp(start, end, width), width);
        }
        VFXHelper.renderNodes(normal, builder, packedLight, nodes, r, g, b, a);
    }

    public static void renderStreamLine(MatrixStack stack, IRenderTypeBuffer buffer, int packedLight, Vector4f[] poss, int rgba, Function<Float, Float> widthFunc) {
        VFXHelper.renderStreamLine(stack, buffer.getBuffer(RenderTypes.FLAT_TRANSLUCENT), packedLight, poss, rgba, widthFunc);
    }

    public static void renderCyclone(MatrixStack stack, IVertexBuilder builder, int packedLight, int streamCount, float streamWidth, float time, float alphaScale) {
        SplittableRandom rand = new SplittableRandom(69420L);
        streamCount *= 2;
        stack.func_227860_a_();
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(time * 6.2832f));
        for (int i = 0; i < streamCount; ++i) {
            float relRot = ((float)rand.nextDouble() - 0.5f) * time * 0.5f + (float)(2 * i);
            float scale = 1.0f + ((float)rand.nextDouble() + MathHelper.sin(time * 0.1f + (float)i)) * 0.1f;
            float width = streamWidth * ((float)rand.nextDouble() * 0.8f + 0.6f) / scale;
            int alpha = (int)MathHelper.clamp((float)(64 + rand.nextInt(64)) * alphaScale * (MathHelper.bevel((float)rand.nextDouble(4.0) + time * 0.06f) + 1.0f), 0.0f, 255.0f);
            int value = rand.nextInt(32) + 224;
            float y = ((float)rand.nextDouble() + MathHelper.cos(time * 0.2f + (float)i)) * 0.16f;
            int length = rand.nextInt(24) + 24;
            if (alpha <= 0) continue;
            Vector4f[] nodes = new Vector4f[length];
            stack.func_227860_a_();
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(relRot));
            stack.func_227862_a_(scale, scale, scale);
            for (int j = 0; j < length; ++j) {
                float angle = (float)j * 0.1308997f;
                nodes[j] = new Vector4f(MathHelper.cos(angle) * 0.5f, y, MathHelper.sin(angle) * 0.5f, 1.0f);
            }
            VFXHelper.renderStreamLine(stack, builder, packedLight, nodes, VFXHelper.packRGBA(value, value, value, alpha), VFXHelper.getWidthFunc(width));
            stack.func_227865_b_();
        }
        stack.func_227865_b_();
    }

    public static void renderCyclone(MatrixStack stack, IRenderTypeBuffer buffer, int packedLight, float radius, float height, int streamCount, float streamWidth, float time, float alphaScale) {
        stack.func_227860_a_();
        float diameter = radius * 2.0f;
        stack.func_227862_a_(diameter, height, diameter);
        VFXHelper.renderCyclone(stack, buffer.getBuffer(RenderTypes.FLAT_TRANSLUCENT), packedLight, streamCount, streamWidth, time, alphaScale);
        stack.func_227865_b_();
    }

    public static class VFXNode {
        public final float xp;
        public final float xn;
        public final float yp;
        public final float yn;
        public final float z;
        public final float width;

        public VFXNode(float xp, float xn, float yp, float yn, float z, float width) {
            this.xp = xp;
            this.xn = xn;
            this.yp = yp;
            this.yn = yn;
            this.z = z;
            this.width = width;
        }

        public VFXNode(Vector4f pos, Vector2f perp, float width) {
            this(pos.func_195910_a() + perp.field_189982_i, pos.func_195910_a() - perp.field_189982_i, pos.func_195913_b() + perp.field_189983_j, pos.func_195913_b() - perp.field_189983_j, pos.func_195914_c(), width);
        }

        public VFXNode(float xp, float xn, float yp, float yn, float z) {
            this(xp, xn, yp, yn, z, MathHelper.dist(xp - xn, yp - yn));
        }

        public float xMid() {
            return (this.xp + this.xn) * 0.5f;
        }

        public float yMid() {
            return (this.yp + this.yn) * 0.5f;
        }

        public VFXNode renderStart(Matrix3f normal, IVertexBuilder builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1) {
            builder.func_225582_a_((double)this.xp, (double)this.yp, (double)this.z).func_225586_a_(r, g, b, a).func_225583_a_(u0, v0).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_225582_a_((double)this.xn, (double)this.yn, (double)this.z).func_225586_a_(r, g, b, a).func_225583_a_(u1, v0).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
            return this;
        }

        public VFXNode renderEnd(Matrix3f normal, IVertexBuilder builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1) {
            builder.func_225582_a_((double)this.xn, (double)this.yn, (double)this.z).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_225582_a_((double)this.xp, (double)this.yp, (double)this.z).func_225586_a_(r, g, b, a).func_225583_a_(u0, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
            return this;
        }

        public VFXNode renderMid(Matrix3f normal, IVertexBuilder builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1, float u2, float v2, float u3, float v3) {
            this.renderEnd(normal, builder, packedLight, r, g, b, a, u0, v0, u1, v1);
            this.renderStart(normal, builder, packedLight, r, g, b, a, u2, v2, u3, v3);
            return this;
        }

        public VFXNode renderMid(Matrix3f normal, IVertexBuilder builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1, float u2, float v2) {
            return this.renderMid(normal, builder, packedLight, r, g, b, a, u0, v0, u1, v1, u1, v1, u2, v2);
        }

        public VFXNode renderMid(Matrix3f normal, IVertexBuilder builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1) {
            return this.renderMid(normal, builder, packedLight, r, g, b, a, u0, v0, u1, v1, u0, v0, u1, v1);
        }

        public VFXNode renderStart(Matrix3f normal, IVertexBuilder builder, int packedLight, int r, int g, int b, int a) {
            return this.renderStart(normal, builder, packedLight, r, g, b, a, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        public VFXNode renderEnd(Matrix3f normal, IVertexBuilder builder, int packedLight, int r, int g, int b, int a) {
            return this.renderEnd(normal, builder, packedLight, r, g, b, a, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        public VFXNode renderMid(Matrix3f normal, IVertexBuilder builder, int packedLight, int r, int g, int b, int a) {
            return this.renderMid(normal, builder, packedLight, r, g, b, a, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }
}

