/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.renderer.model;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.util.helpers.MathHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fluids.FluidStack;

public class ModelUtils {
    public static final ModelProperty<Direction> FACING = new ModelProperty();
    public static final ModelProperty<FluidStack> FLUID = new ModelProperty();
    public static final ModelProperty<Integer> LEVEL = new ModelProperty();
    public static final ModelProperty<byte[]> SIDES = new ModelProperty();
    public static final ModelProperty<ResourceLocation> UNDERLAY = new ModelProperty();

    private ModelUtils() {
    }

    public static class FluidCacheWrapper {
        BlockState state;
        FluidStack stack;

        public FluidCacheWrapper(BlockState state, FluidStack stack) {
            this.state = state;
            this.stack = new FluidStack(stack, 1000);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FluidCacheWrapper that = (FluidCacheWrapper)o;
            return Objects.equals(this.state, that.state) && Objects.equals(this.stack, that.stack);
        }

        public int hashCode() {
            return Objects.hash(this.state, FluidHelper.fluidHashcode(this.stack));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBakedModelBuilder {
        private final List<BakedQuad> builderGeneralQuads = new ArrayList<BakedQuad>();
        private final Map<Direction, List<BakedQuad>> builderUnderlayQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        private final Map<Direction, List<BakedQuad>> builderFaceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        private final ItemOverrideList builderItemOverrideList;
        private final boolean builderAmbientOcclusion;
        private TextureAtlasSprite builderTexture;
        private final boolean builderSideLit;
        private final boolean builderGui3d;
        private final ItemCameraTransforms builderCameraTransforms;

        public WrappedBakedModelBuilder(IBakedModel model) {
            for (Direction direction : Direction.values()) {
                this.builderUnderlayQuads.put(direction, new ArrayList());
                this.builderFaceQuads.put(direction, new LinkedList(model.func_200117_a(null, direction, MathHelper.RANDOM)));
            }
            this.builderGeneralQuads.addAll(model.func_200117_a(null, null, MathHelper.RANDOM));
            this.builderItemOverrideList = model.func_188617_f();
            this.builderAmbientOcclusion = model.func_177555_b();
            this.builderTexture = model.func_177554_e();
            this.builderSideLit = model.func_230044_c_();
            this.builderGui3d = model.func_177556_c();
            this.builderCameraTransforms = model.func_177552_f();
        }

        public WrappedBakedModelBuilder addUnderlayQuad(Direction facing, BakedQuad quad) {
            this.builderUnderlayQuads.get(facing).add(quad);
            return this;
        }

        public WrappedBakedModelBuilder addFaceQuad(Direction facing, BakedQuad quad) {
            this.builderFaceQuads.get(facing).add(quad);
            return this;
        }

        public WrappedBakedModelBuilder addGeneralQuad(BakedQuad quad) {
            this.builderGeneralQuads.add(quad);
            return this;
        }

        public List<BakedQuad> getQuads(Direction facing) {
            return facing == null ? this.builderGeneralQuads : this.builderFaceQuads.get(facing);
        }

        public WrappedBakedModelBuilder setTexture(TextureAtlasSprite texture) {
            this.builderTexture = texture;
            return this;
        }

        public IBakedModel build() {
            if (this.builderTexture == null) {
                throw new RuntimeException("Missing particle!");
            }
            for (Direction dir : Direction.values()) {
                this.builderUnderlayQuads.get(dir).addAll((Collection<BakedQuad>)this.builderFaceQuads.get(dir));
            }
            return new SimpleBakedModel(this.builderGeneralQuads, this.builderUnderlayQuads, this.builderAmbientOcclusion, this.builderSideLit, this.builderGui3d, this.builderTexture, this.builderCameraTransforms, this.builderItemOverrideList);
        }
    }
}

