/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.CoFHCore;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.client.gui.IGuiAccess;
import cofh.lib.util.IResourceStorage;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ElementResourceStorage
extends ElementBase {
    protected ResourceLocation creativeTexture;
    protected ResourceLocation underlayTexture;
    protected ResourceLocation overlayTexture;
    protected IResourceStorage storage;
    protected int minDisplay = 1;
    protected BooleanSupplier drawStorage = Constants.TRUE;
    protected BooleanSupplier drawUnderlay = Constants.TRUE;
    protected BooleanSupplier drawOverlay = Constants.TRUE;
    protected BooleanSupplier claimStorage = Constants.FALSE;
    protected BooleanSupplier clearStorage = Constants.FALSE;
    protected BooleanSupplier claimable = Constants.FALSE;
    protected BooleanSupplier clearable;

    public ElementResourceStorage(IGuiAccess gui, int posX, int posY, IResourceStorage storage) {
        super(gui, posX, posY);
        this.storage = storage;
        this.clearable = () -> storage.getStored() > 0;
    }

    public final ElementResourceStorage setCreativeTexture(String texture) {
        if (texture == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL creative texture.");
            return this;
        }
        this.creativeTexture = new ResourceLocation(texture);
        return this;
    }

    public final ElementResourceStorage setUnderlayTexture(String texture) {
        return this.setUnderlayTexture(texture, Constants.TRUE);
    }

    public final ElementResourceStorage setUnderlayTexture(String texture, BooleanSupplier draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL underlay texture.");
            return this;
        }
        this.underlayTexture = new ResourceLocation(texture);
        this.drawUnderlay = draw;
        return this;
    }

    public final ElementResourceStorage setOverlayTexture(String texture) {
        return this.setOverlayTexture(texture, Constants.TRUE);
    }

    public final ElementResourceStorage setOverlayTexture(String texture, BooleanSupplier draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL overlay texture.");
            return this;
        }
        this.overlayTexture = new ResourceLocation(texture);
        this.drawOverlay = draw;
        return this;
    }

    public final ElementResourceStorage setClaimStorage(BooleanSupplier claimStorage) {
        this.claimStorage = claimStorage;
        return this;
    }

    public final ElementResourceStorage setClearStorage(BooleanSupplier clearStorage) {
        this.clearStorage = clearStorage;
        return this;
    }

    public ElementResourceStorage setMinDisplay(int minDisplay) {
        this.minDisplay = minDisplay;
        return this;
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawStorage();
        this.drawUnderlayTexture();
        this.drawResource();
        this.drawOverlayTexture();
    }

    @Override
    public void addTooltip(List<ITextComponent> tooltipList, int mouseX, int mouseY) {
        if (this.storage.isCreative()) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.infinite").func_240699_a_(TextFormatting.LIGHT_PURPLE).func_240699_a_(TextFormatting.ITALIC));
        } else {
            tooltipList.add((ITextComponent)new StringTextComponent(StringHelper.format(this.storage.getStored()) + " / " + StringHelper.format(this.storage.getCapacity()) + " " + this.storage.getUnit()));
        }
        if (this.clearable.getAsBoolean() && this.clearStorage != Constants.FALSE && (Screen.func_231174_t_() || Screen.func_231173_s_())) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.click_to_clear").func_240699_a_(TextFormatting.GRAY));
        } else if (this.claimable.getAsBoolean()) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.click_to_claim").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.clearable.getAsBoolean() && Screen.func_231173_s_() && Screen.func_231174_t_()) {
            return this.clearStorage.getAsBoolean();
        }
        if (this.claimable.getAsBoolean()) {
            return this.claimStorage.getAsBoolean();
        }
        return false;
    }

    protected int getScaled(int scale) {
        double fraction = (double)this.storage.getStored() * (double)scale / (double)this.storage.getCapacity();
        int amount = MathHelper.clamp(MathHelper.round(fraction), 0, scale);
        return fraction > 0.0 ? Math.max(this.minDisplay, amount) : amount;
    }

    protected void drawStorage() {
        if (this.drawStorage.getAsBoolean() && this.texture != null) {
            RenderHelper.bindTexture(this.texture);
            this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }

    protected void drawUnderlayTexture() {
        if (this.drawUnderlay.getAsBoolean() && this.underlayTexture != null) {
            RenderHelper.bindTexture(this.underlayTexture);
            this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }

    protected abstract void drawResource();

    protected void drawOverlayTexture() {
        if (this.drawOverlay.getAsBoolean() && this.overlayTexture != null) {
            RenderHelper.bindTexture(this.overlayTexture);
            this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }
}

