/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block.nyi;

import cofh.lib.util.helpers.MathHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpecialAirBlock
extends AirBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)3);

    public SpecialAirBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
        builder.func_206894_a(new Property[]{AGE});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (blockIn == this && this.shouldDisperse((IBlockReader)worldIn, pos, 3)) {
            this.turnIntoAir(state, worldIn, pos);
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.func_225534_a_(state, worldIn, pos, random);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if ((rand.nextInt(4) == 0 || this.shouldDisperse((IBlockReader)worldIn, pos, 4)) && this.slightlyDisperse(state, (World)worldIn, pos)) {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (Direction direction : Direction.values()) {
                blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
                BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$mutable);
                if (!blockstate.func_203425_a((Block)this) || this.slightlyDisperse(blockstate, (World)worldIn, (BlockPos)blockpos$mutable)) continue;
                worldIn.func_205220_G_().func_205360_a((BlockPos)blockpos$mutable, (Object)this, net.minecraft.util.math.MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
            }
        } else {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.nextInt(rand, 20, 40));
        }
    }

    protected void turnIntoAir(BlockState state, World worldIn, BlockPos pos) {
        BlockState newState = worldIn.func_204610_c(pos).func_206883_i();
        worldIn.func_175656_a(pos, newState);
        worldIn.func_190524_a(pos, newState.func_177230_c(), pos);
    }

    protected boolean shouldDisperse(IBlockReader worldIn, BlockPos pos, int neighborsRequired) {
        int i = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            if (!worldIn.func_180495_p((BlockPos)blockpos$mutable).func_203425_a((Block)this) || ++i < neighborsRequired) continue;
            return false;
        }
        return true;
    }

    protected boolean slightlyDisperse(BlockState state, World worldIn, BlockPos pos) {
        int i = (Integer)state.func_177229_b((Property)AGE);
        if (i < 1) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.turnIntoAir(state, worldIn, pos);
        return true;
    }
}

