/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.entity.collision;

import com.github.alexthe666.citadel.server.entity.collision.ICustomCollisions;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.border.WorldBorder;

public class CitadelVoxelShapeSpliterator
extends Spliterators.AbstractSpliterator<VoxelShape> {
    @Nullable
    private final Entity entity;
    private final AxisAlignedBB aabb;
    private final ISelectionContext context;
    private final CubeCoordinateIterator cubeCoordinateIterator;
    private final BlockPos.Mutable mutablePos;
    private final VoxelShape shape;
    private final ICollisionReader reader;
    private final BiPredicate<BlockState, BlockPos> statePositionPredicate;
    private boolean field_234875_h_;

    public CitadelVoxelShapeSpliterator(ICollisionReader reader, @Nullable Entity entity, AxisAlignedBB aabb) {
        this(reader, entity, aabb, (p_241459_0_, p_241459_1_) -> true);
    }

    public CitadelVoxelShapeSpliterator(ICollisionReader reader, @Nullable Entity entity, AxisAlignedBB aabb, BiPredicate<BlockState, BlockPos> statePositionPredicate) {
        super(Long.MAX_VALUE, 1280);
        this.context = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        this.mutablePos = new BlockPos.Mutable();
        this.shape = VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
        this.reader = reader;
        this.field_234875_h_ = entity != null;
        this.entity = entity;
        this.aabb = aabb;
        this.statePositionPredicate = statePositionPredicate;
        int i = MathHelper.func_76128_c((double)(aabb.field_72340_a - 1.0E-7)) - 1;
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0E-7)) + 1;
        int k = MathHelper.func_76128_c((double)(aabb.field_72338_b - 1.0E-7)) - 1;
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0E-7)) + 1;
        int i1 = MathHelper.func_76128_c((double)(aabb.field_72339_c - 1.0E-7)) - 1;
        int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0E-7)) + 1;
        this.cubeCoordinateIterator = new CubeCoordinateIterator(i, k, i1, j, l, j1);
    }

    private static boolean func_241460_a_(VoxelShape p_241460_0_, AxisAlignedBB p_241460_1_) {
        return VoxelShapes.func_197879_c((VoxelShape)p_241460_0_, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)p_241460_1_.func_186662_g(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_);
    }

    private static boolean func_241461_b_(VoxelShape p_241461_0_, AxisAlignedBB p_241461_1_) {
        return VoxelShapes.func_197879_c((VoxelShape)p_241461_0_, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)p_241461_1_.func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_);
    }

    public static boolean func_234877_a_(WorldBorder p_234877_0_, AxisAlignedBB p_234877_1_) {
        double d0 = MathHelper.func_76128_c((double)p_234877_0_.func_177726_b());
        double d1 = MathHelper.func_76128_c((double)p_234877_0_.func_177736_c());
        double d2 = MathHelper.func_76143_f((double)p_234877_0_.func_177728_d());
        double d3 = MathHelper.func_76143_f((double)p_234877_0_.func_177733_e());
        return p_234877_1_.field_72340_a > d0 && p_234877_1_.field_72340_a < d2 && p_234877_1_.field_72339_c > d1 && p_234877_1_.field_72339_c < d3 && p_234877_1_.field_72336_d > d0 && p_234877_1_.field_72336_d < d2 && p_234877_1_.field_72334_f > d1 && p_234877_1_.field_72334_f < d3;
    }

    @Override
    public boolean tryAdvance(Consumer<? super VoxelShape> p_tryAdvance_1_) {
        return this.field_234875_h_ && this.func_234879_b_(p_tryAdvance_1_) || this.func_234878_a_(p_tryAdvance_1_);
    }

    boolean func_234878_a_(Consumer<? super VoxelShape> p_234878_1_) {
        while (this.cubeCoordinateIterator.func_218301_a()) {
            IBlockReader iblockreader;
            int i = this.cubeCoordinateIterator.func_218304_b();
            int j = this.cubeCoordinateIterator.func_218302_c();
            int k = this.cubeCoordinateIterator.func_218303_d();
            int l = this.cubeCoordinateIterator.func_223473_e();
            if (l == 3 || (iblockreader = this.func_234876_a_(i, k)) == null) continue;
            this.mutablePos.func_181079_c(i, j, k);
            BlockState blockstate = iblockreader.func_180495_p((BlockPos)this.mutablePos);
            if (!this.statePositionPredicate.test(blockstate, (BlockPos)this.mutablePos) || l == 1 && !blockstate.func_215704_f() || l == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb) continue;
            VoxelShape voxelshape = blockstate.func_215685_b((IBlockReader)this.reader, (BlockPos)this.mutablePos, this.context);
            if (this.entity instanceof ICustomCollisions && ((ICustomCollisions)this.entity).canPassThrough((BlockPos)this.mutablePos, blockstate, voxelshape)) continue;
            if (voxelshape == VoxelShapes.func_197868_b()) {
                if (!this.aabb.func_186668_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0)) continue;
                p_234878_1_.accept((VoxelShape)voxelshape.func_197751_a((double)i, (double)j, (double)k));
                return true;
            }
            VoxelShape voxelshape1 = voxelshape.func_197751_a((double)i, (double)j, (double)k);
            if (!VoxelShapes.func_197879_c((VoxelShape)voxelshape1, (VoxelShape)this.shape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
            p_234878_1_.accept((VoxelShape)voxelshape1);
            return true;
        }
        return false;
    }

    @Nullable
    private IBlockReader func_234876_a_(int p_234876_1_, int p_234876_2_) {
        int i = p_234876_1_ >> 4;
        int j = p_234876_2_ >> 4;
        return this.reader.func_225522_c_(i, j);
    }

    boolean func_234879_b_(Consumer<? super VoxelShape> p_234879_1_) {
        VoxelShape voxelshape;
        Objects.requireNonNull(this.entity);
        this.field_234875_h_ = false;
        WorldBorder worldborder = this.reader.func_175723_af();
        AxisAlignedBB axisalignedbb = this.entity.func_174813_aQ();
        if (!CitadelVoxelShapeSpliterator.func_234877_a_(worldborder, axisalignedbb) && !CitadelVoxelShapeSpliterator.func_241461_b_(voxelshape = worldborder.func_222521_a(), axisalignedbb) && CitadelVoxelShapeSpliterator.func_241460_a_(voxelshape, axisalignedbb)) {
            p_234879_1_.accept((VoxelShape)voxelshape);
            return true;
        }
        return false;
    }
}

