/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public abstract class AbstractModConfig {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    transient Path file;

    public void save() {
        if (this.file == null) {
            throw new IllegalStateException("This config object has not been given a path, use AbstractModConfig.loadConfigFile() to give it one.");
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem occurred when trying to save config: " + this.file, e);
        }
    }

    public static <T extends AbstractModConfig> T loadConfigFile(Path file, T defaultInstance) {
        AbstractModConfig config = null;
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader fileReader = Files.newBufferedReader(file);){
                config = (AbstractModConfig)GSON.fromJson((Reader)fileReader, defaultInstance.getClass());
            }
            catch (IOException e) {
                throw new RuntimeException("Problem occurred when trying to load config: " + file, e);
            }
        }
        if (config == null) {
            config = defaultInstance;
        }
        config.file = file;
        config.save();
        return (T)config;
    }
}

